/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DisiWrapper;
import guideme.internal.shaded.lucene.search.DisjunctionScorer;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.MathUtil;
import java.io.IOException;
import java.util.List;

final class DisjunctionSumScorer
extends DisjunctionScorer {
    private final List<Scorer> scorers;

    DisjunctionSumScorer(Weight weight, List<Scorer> subScorers, ScoreMode scoreMode) throws IOException {
        super(weight, subScorers, scoreMode);
        this.scorers = subScorers;
    }

    @Override
    protected float score(DisiWrapper topList) throws IOException {
        double score = 0.0;
        DisiWrapper w = topList;
        while (w != null) {
            score += (double)w.scorer.score();
            w = w.next;
        }
        return (float)score;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int min = Integer.MAX_VALUE;
        for (Scorer scorer : this.scorers) {
            if (scorer.docID() > target) continue;
            min = Math.min(min, scorer.advanceShallow(target));
        }
        return min;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer scorer : this.scorers) {
            if (scorer.docID() > upTo) continue;
            maxScore += (double)scorer.getMaxScore(upTo);
        }
        return (float)MathUtil.sumUpperBound(maxScore, this.scorers.size());
    }
}

