/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.surround.query;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.MultiTerms;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.queryparser.surround.query.SimpleTerm;
import guideme.internal.shaded.lucene.search.PrefixQuery;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public class SrndPrefixQuery
extends SimpleTerm {
    private final CompiledAutomaton compiled;
    private final String prefix;
    private final char truncator;

    public SrndPrefixQuery(String prefix, boolean quoted, char truncator) {
        super(quoted);
        this.prefix = prefix;
        this.compiled = new CompiledAutomaton(PrefixQuery.toAutomaton(new BytesRef(prefix)), true, true, 10000, true);
        this.truncator = truncator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getSuffixOperator() {
        return this.truncator;
    }

    @Override
    public String toStringUnquoted() {
        return this.getPrefix();
    }

    @Override
    protected void suffixToString(StringBuilder r) {
        r.append(this.getSuffixOperator());
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null) {
            BytesRef br;
            TermsEnum termsEnum = this.compiled.getTermsEnum(terms);
            while ((br = termsEnum.next()) != null) {
                mtv.visitMatchingTerm(new Term(fieldName, BytesRef.deepCopyOf(br)));
            }
        }
    }
}

