/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.hunspell;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.hunspell.Dictionary;
import guideme.internal.shaded.lucene.analysis.hunspell.HunspellStemFilter;
import guideme.internal.shaded.lucene.store.FSDirectory;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.ResourceLoader;
import guideme.internal.shaded.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;

public class HunspellStemFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "hunspellStem";
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String PARAM_LONGEST_ONLY = "longestOnly";
    private final String dictionaryFiles;
    private final String affixFile;
    private final boolean ignoreCase;
    private final boolean longestOnly;
    private Dictionary dictionary;

    public HunspellStemFilterFactory(Map<String, String> args) {
        super(args);
        this.dictionaryFiles = this.require(args, PARAM_DICTIONARY);
        this.affixFile = this.get(args, PARAM_AFFIX);
        this.ignoreCase = this.getBoolean(args, PARAM_IGNORE_CASE, false);
        this.longestOnly = this.getBoolean(args, PARAM_LONGEST_ONLY, false);
        this.getBoolean(args, "strictAffixParsing", true);
        this.getInt(args, "recursionCap", 0);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public HunspellStemFilterFactory() {
        throw HunspellStemFilterFactory.defaultCtorException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String[] dicts = this.dictionaryFiles.split(",");
        InputStream affix = null;
        ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
        try {
            dictionaries = new ArrayList();
            for (String file : dicts) {
                dictionaries.add(loader.openResource(file));
            }
            affix = loader.openResource(this.affixFile);
            Path tempPath = Files.createTempDirectory(Dictionary.getDefaultTempDir(), "Hunspell", new FileAttribute[0]);
            try (FSDirectory tempDir = FSDirectory.open(tempPath);){
                this.dictionary = new Dictionary(tempDir, "hunspell", affix, dictionaries, this.ignoreCase);
            }
            catch (Throwable throwable) {
                IOUtils.rm(tempPath);
                throw throwable;
            }
            IOUtils.rm(tempPath);
        }
        catch (ParseException e) {
            try {
                throw new IOException("Unable to load hunspell data! [dictionary=" + dictionaries + ",affix=" + this.affixFile + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(affix);
                IOUtils.closeWhileHandlingException(dictionaries);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(affix);
        IOUtils.closeWhileHandlingException(dictionaries);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, true, this.longestOnly);
    }
}

