/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.boost;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.boost.DelimitedBoostTokenFilter;
import java.util.Map;

public class DelimitedBoostTokenFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "delimitedBoost";
    public static final String DELIMITER_ATTR = "delimiter";
    public static final char DEFAULT_DELIMITER = '|';
    private final char delimiter;

    public DelimitedBoostTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.delimiter = this.getChar(args, DELIMITER_ATTR, '|');
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public DelimitedBoostTokenFilterFactory() {
        throw DelimitedBoostTokenFilterFactory.defaultCtorException();
    }

    @Override
    public DelimitedBoostTokenFilter create(TokenStream input) {
        return new DelimitedBoostTokenFilter(input, this.delimiter);
    }
}

