/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import guideme.Guides;
import guideme.GuidesCommon;
import guideme.PageAnchor;
import guideme.internal.command.GuideIdArgument;
import guideme.internal.command.PageAnchorArgument;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public final class GuideCommand {
    private GuideCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder rootCommand = Commands.m_82127_((String)"guideme");
        ((LiteralArgumentBuilder)rootCommand.requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"guide", (ArgumentType)GuideIdArgument.argument()).executes(context -> {
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            for (ServerPlayer target : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                GuidesCommon.openGuide((Player)target, guideId);
            }
            return 0;
        })).then(Commands.m_82129_((String)"page", (ArgumentType)PageAnchorArgument.argument()).executes(context -> {
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            PageAnchor anchor = PageAnchorArgument.getPageAnchor((CommandContext<CommandSourceStack>)context, "page");
            for (ServerPlayer target : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                GuidesCommon.openGuide((Player)target, guideId, anchor);
            }
            return 0;
        })))));
        ((LiteralArgumentBuilder)rootCommand.requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"guide", (ArgumentType)GuideIdArgument.argument()).executes(context -> GuideCommand.giveGuide((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), GuideIdArgument.getGuide(context, "guide"))))));
        dispatcher.register(rootCommand);
    }

    private static int giveGuide(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation guideId) {
        ItemStack guideItem = Guides.createGuideItem(guideId);
        for (ServerPlayer target : targets) {
            ItemHandlerHelper.giveItemToPlayer((Player)target, (ItemStack)guideItem.m_41777_());
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, guideItem.m_41611_(), ((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, guideItem.m_41611_(), targets.size()}), true);
        }
        return targets.size();
    }
}

