/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.video.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFClient;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.rendering.video.mcef.MCEFVideoPlayer;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCEFVideoManager {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final MCEFVideoManager INSTANCE = new MCEFVideoManager();
    public static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    protected final Map<String, MCEFVideoPlayer> players = new HashMap<String, MCEFVideoPlayer>();
    protected boolean webResourcesRegistered = false;
    private static volatile boolean jsResultHandlerRegistered = false;
    private static final Map<String, CompletableFuture<String>> pendingJsResults = new ConcurrentHashMap<String, CompletableFuture<String>>();
    private static boolean is_initializing = false;
    public static boolean initialized = false;

    public static MCEFVideoManager getInstance() {
        return INSTANCE;
    }

    public static Map<String, CompletableFuture<String>> getPendingJsResults() {
        return pendingJsResults;
    }

    public void initialize() {
        if (initialized) {
            return;
        }
        if (is_initializing) {
            return;
        }
        is_initializing = true;
        LOGGER.info("[FANCYMENU] Starting initialization of MCEFVideoManager..");
        if (!MCEFUtil.MCEF_initialized) {
            LOGGER.warn("[FANCYMENU] MCEF not initialized yet! Will wait for MCEF to be ready before initializing MCEFVideoManager!");
        }
        new Thread(() -> {
            try {
                while (true) {
                    if (MCEFUtil.MCEF_initialized) {
                        MainThreadTaskExecutor.executeInMainThread(() -> {
                            try {
                                if (this.isVideoPlaybackAvailable()) {
                                    if (!jsResultHandlerRegistered) {
                                        MCEFVideoManager.registerJsResultHandlerInternal();
                                    }
                                    if (!this.webResourcesRegistered) {
                                        try {
                                            this.extractWebResources();
                                            this.webResourcesRegistered = true;
                                            LOGGER.info("[FANCYMENU] MCEFVideoManager: Successfully extracted video player web resources");
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("[FANCYMENU] MCEFVideoManager: Failed to extract video player web resources", (Throwable)e);
                                        }
                                    }
                                }
                                initialized = true;
                                LOGGER.info("[FANCYMENU] MCEFVideoManager successfully initialized!");
                            }
                            catch (Exception ex) {
                                LOGGER.error("[FANCYMENU] Failed to initialize MCEFVideoManager!", (Throwable)ex);
                            }
                        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to initialize MCEFVideoManager!", (Throwable)ex);
            }
        }).start();
    }

    private static synchronized void registerJsResultHandlerInternal() {
        if (jsResultHandlerRegistered) {
            return;
        }
        try {
            MCEFClient client = MCEF.getClient();
            client.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

                public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                    if (message != null && message.startsWith("MCEF_ASYNC_RESULT:")) {
                        try {
                            String[] parts = message.split(":", 3);
                            if (parts.length == 3) {
                                String requestId = parts[1];
                                String jsonData = parts[2];
                                CompletableFuture<String> future = pendingJsResults.remove(requestId);
                                if (future != null) {
                                    if ("undefined".equals(jsonData)) {
                                        future.complete(null);
                                    } else {
                                        future.complete(jsonData);
                                    }
                                } else {
                                    LOGGER.warn("[FANCYMENU] Received JS result for unknown or timed-out request ID: {}", (Object)requestId);
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("[FANCYMENU] Error processing MCEF_ASYNC_RESULT: " + message, (Throwable)e);
                        }
                        return true;
                    }
                    return false;
                }
            });
            jsResultHandlerRegistered = true;
        }
        catch (Throwable t) {
            LOGGER.error("[FANCYMENU] Failed to register JS result display handler with MCEF.", t);
        }
        if (!jsResultHandlerRegistered) {
            LOGGER.warn("[FANCYMENU] JS result handler NOT registered. Getting duration/playtime will likely fail.");
        }
    }

    protected void extractWebResources() {
        File webDir = new File(FancyMenu.TEMP_DATA_DIR, "web/videoplayer");
        if (!webDir.exists() && !webDir.mkdirs()) {
            LOGGER.error("[FANCYMENU] Failed to create web resource directory: {}", (Object)webDir.getAbsolutePath());
            return;
        }
        this.extractResourceInternal("/assets/fancymenu/web/videoplayer/player.html", new File(webDir, "player.html"), true);
    }

    private void extractResourceInternal(String resourcePath, File destinationFile, boolean isCritical) {
        block15: {
            try (InputStream is = FancyMenu.class.getResourceAsStream(resourcePath);){
                if (is != null) {
                    Files.copy(is, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    String message = "[FANCYMENU] Could not find resource {} in mod JAR";
                    if (isCritical) {
                        LOGGER.error(message + " (CRITICAL)", (Object)resourcePath);
                    } else {
                        LOGGER.warn(message, (Object)resourcePath);
                    }
                    if (isCritical && resourcePath.endsWith("player.html")) {
                        this.webResourcesRegistered = false;
                    }
                }
            }
            catch (Exception e) {
                String message = "[FANCYMENU] Failed to extract resource {}: {}";
                if (isCritical) {
                    LOGGER.error(message + " (CRITICAL)", (Object)resourcePath, (Object)e.getMessage(), (Object)e);
                } else {
                    LOGGER.warn(message, (Object)resourcePath, (Object)e.getMessage());
                }
                if (!isCritical || !resourcePath.endsWith("player.html")) break block15;
                this.webResourcesRegistered = false;
            }
        }
    }

    public boolean isVideoPlaybackAvailable() {
        return MCEFUtil.isMCEFLoaded();
    }

    @Nullable
    public String createPlayer() {
        return this.createPlayer(0, 0, 200, 200);
    }

    @Nullable
    public String createPlayer(int x, int y, int width, int height) {
        if (!this.isVideoPlaybackAvailable()) {
            LOGGER.warn("[FANCYMENU] Cannot create video player: MCEF is not loaded");
            return null;
        }
        if (!this.webResourcesRegistered) {
            this.initialize();
            if (!this.webResourcesRegistered) {
                LOGGER.error("[FANCYMENU] Failed to initialize/verify web resources for video player. Cannot create player.");
                return null;
            }
        }
        if (!jsResultHandlerRegistered && this.isVideoPlaybackAvailable()) {
            MCEFVideoManager.registerJsResultHandlerInternal();
            if (!jsResultHandlerRegistered) {
                LOGGER.error("[FANCYMENU] JS Result Handler not registered. Video info (duration, etc.) may not work.");
            }
        }
        try {
            String playerId = UUID.randomUUID().toString();
            MCEFVideoPlayer player = new MCEFVideoPlayer(x, y, width, height);
            this.players.put(playerId, player);
            return playerId;
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Failed to create video player", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public MCEFVideoPlayer getPlayer(@NotNull String playerId) {
        return this.players.get(playerId);
    }

    public void removePlayer(@NotNull String playerId) {
        MCEFVideoPlayer player = this.players.remove(playerId);
        if (player != null) {
            player.dispose();
        }
    }

    public void disposeAll() {
        for (MCEFVideoPlayer player : this.players.values()) {
            try {
                player.dispose();
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Error disposing video player", (Throwable)e);
            }
        }
        this.players.clear();
    }
}

