/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.cycle.ILocalizedValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CellScreen
extends Screen
implements InitialWidgetFocusScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    public ScrollArea scrollArea;
    @Nullable
    protected RenderCell selectedCell;
    protected final List<AbstractWidget> rightSideWidgets = new ArrayList<AbstractWidget>();
    @Nullable
    protected ExtendedButton doneButton;
    @Nullable
    protected ExtendedButton cancelButton;
    protected int lastWidth = 0;
    protected int lastHeight = 0;
    protected final List<RenderCell> allCells = new ArrayList<RenderCell>();
    protected boolean searchBarEnabled = false;
    @Nullable
    protected ExtendedEditBox searchBar;
    @NotNull
    protected Component searchBarPlaceholder = Component.m_237115_((String)"fancymenu.ui.generic.search");
    protected boolean descriptionAreaEnabled = false;
    @Nullable
    protected ScrollArea descriptionScrollArea;

    protected CellScreen(@NotNull Component title) {
        super(title);
    }

    protected void initCells() {
    }

    protected void initRightSideWidgets() {
    }

    public void rebuild() {
        this.m_6574_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    protected void setSearchBarEnabled(boolean enabled) {
        this.searchBarEnabled = enabled;
    }

    protected void setSearchBarPlaceholder(@NotNull Component placeholder) {
        this.searchBarPlaceholder = placeholder;
    }

    protected void setDescriptionAreaEnabled(boolean enabled) {
        this.descriptionAreaEnabled = enabled;
    }

    @Nullable
    protected List<Component> getCurrentDescription() {
        Supplier<List<Component>> supplier;
        if (this.selectedCell != null && (supplier = this.selectedCell.getDescriptionSupplier()) != null) {
            return supplier.get();
        }
        return null;
    }

    protected void updateDescriptionArea() {
        if (this.descriptionScrollArea == null) {
            return;
        }
        this.descriptionScrollArea.clearEntries();
        this.descriptionScrollArea.addEntry(new SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
        List<Component> description = this.getCurrentDescription();
        if (description != null) {
            for (Component line : description) {
                this.addDescriptionLine(line);
            }
        }
        this.descriptionScrollArea.addEntry(new SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
    }

    protected void addDescriptionLine(@NotNull Component line) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15.0f);
        if (this.f_96547_.m_92852_((FormattedText)line) > maxWidth) {
            this.f_96547_.m_92865_().m_92414_((FormattedText)line, maxWidth, Style.f_131099_).forEach(formatted -> lines.add((Component)TextFormattingUtils.convertFormattedTextToComponent(formatted)));
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, (Component)component, entry -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected void updateCellsVisibility() {
        if (!this.searchBarEnabled || this.searchBar == null || this.scrollArea == null) {
            return;
        }
        String searchValue = this.searchBar.m_94155_();
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        float scrollX = this.scrollArea.horizontalScrollBar.getScroll();
        float scrollY = this.scrollArea.verticalScrollBar.getScroll();
        this.scrollArea.clearEntries();
        for (RenderCell cell : this.allCells) {
            if (!this.cellMatchesSearch(cell, searchValue)) continue;
            CellScrollEntry entry = new CellScrollEntry(this.scrollArea, cell);
            this.scrollArea.addEntry(entry);
            cell.updateSize(entry);
            entry.setHeight(cell.getHeight());
        }
        this.scrollArea.horizontalScrollBar.setScroll(scrollX);
        this.scrollArea.verticalScrollBar.setScroll(scrollY);
    }

    protected boolean cellMatchesSearch(@NotNull RenderCell cell, @Nullable String searchValue) {
        List<Component> description;
        if (searchValue == null || searchValue.isBlank()) {
            return true;
        }
        if (cell.ignoreSearch) {
            return true;
        }
        String searchLower = searchValue.toLowerCase();
        String cellSearchString = cell.getSearchString();
        if (cellSearchString != null && cellSearchString.toLowerCase().contains(searchLower)) {
            return true;
        }
        Supplier<List<Component>> descSupplier = cell.getDescriptionSupplier();
        if (descSupplier != null && (description = descSupplier.get()) != null) {
            for (Component c : description) {
                if (!c.getString().toLowerCase().contains(searchLower)) continue;
                return true;
            }
        }
        return false;
    }

    protected void m_7856_() {
        this.rightSideWidgets.clear();
        this.allCells.clear();
        this.selectedCell = null;
        int scrollAreaX = 20;
        int scrollAreaY = 65;
        int scrollAreaWidth = this.f_96543_ - 40 - this.getRightSideWidgetWidth() - 20;
        int scrollAreaHeight = this.f_96544_ - 85;
        if (this.descriptionAreaEnabled) {
            scrollAreaWidth = this.f_96543_ / 2 - 40;
            this.descriptionScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
            this.descriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
            this.descriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
            this.descriptionScrollArea.setX((float)(this.f_96543_ - 20) - this.descriptionScrollArea.getWidthWithBorder(), true);
            this.descriptionScrollArea.setY(65.0f, true);
            this.descriptionScrollArea.horizontalScrollBar.active = false;
            this.m_142416_(this.descriptionScrollArea);
        }
        if (this.searchBarEnabled) {
            scrollAreaY += 25;
            scrollAreaHeight -= 25;
            String oldSearchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
            this.searchBar = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, scrollAreaX + 1, 66, scrollAreaWidth - 2, 18, (Component)Component.m_237119_());
            if (this.searchBarPlaceholder != null) {
                this.searchBar.setHintFancyMenu(consumes -> this.searchBarPlaceholder);
            }
            this.searchBar.m_94144_(oldSearchValue);
            this.searchBar.m_94151_(s -> this.updateCellsVisibility());
            UIBase.applyDefaultWidgetSkinTo(this.searchBar);
            this.searchBar.m_94199_(100000);
            this.m_142416_((GuiEventListener)this.searchBar);
            this.setupInitialFocusWidget(this, (GuiEventListener)this.searchBar);
        }
        float oldScrollX = 0.0f;
        float oldScrollY = 0.0f;
        if (this.scrollArea != null) {
            oldScrollX = this.scrollArea.horizontalScrollBar.getScroll();
            oldScrollY = this.scrollArea.verticalScrollBar.getScroll();
        }
        this.scrollArea = new ScrollArea(scrollAreaX, scrollAreaY, scrollAreaWidth, scrollAreaHeight);
        this.initCells();
        this.m_7787_(this.scrollArea);
        this.scrollArea.horizontalScrollBar.setScroll(oldScrollX);
        this.scrollArea.verticalScrollBar.setScroll(oldScrollY);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof CellScrollEntry)) continue;
            CellScrollEntry ce = (CellScrollEntry)e;
            ce.cell.updateSize(ce);
            ce.setHeight(ce.cell.getHeight());
        }
        this.initRightSideWidgets();
        this.addRightSideDefaultSpacer();
        this.cancelButton = this.addRightSideButton(20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> this.onCancel());
        this.doneButton = this.addRightSideButton(20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> {
            if (this.allowDone()) {
                this.onDone();
            }
        }).setIsActiveSupplier(consumes -> this.allowDone());
        int widgetWidth = this.getRightSideWidgetWidth();
        int widgetX = this.f_96543_ - 20 - widgetWidth;
        int widgetY = this.f_96544_ - 20;
        AbstractWidget topRightSideWidget = null;
        for (AbstractWidget w : Lists.reverse(this.rightSideWidgets)) {
            if (!(w instanceof RightSideSpacer)) {
                UIBase.applyDefaultWidgetSkinTo(w);
                w.m_252865_(widgetX);
                w.m_253211_(widgetY - w.m_93694_());
                w.m_93674_(widgetWidth);
                this.m_142416_((GuiEventListener)w);
                topRightSideWidget = w;
            }
            widgetY -= w.m_93694_() + this.getRightSideDefaultSpaceBetweenWidgets();
        }
        Window window = Minecraft.m_91087_().m_91268_();
        boolean resized = window.m_85443_() != this.lastWidth || window.m_85444_() != this.lastHeight;
        this.lastWidth = window.m_85443_();
        this.lastHeight = window.m_85444_();
        if (topRightSideWidget != null && topRightSideWidget.m_252907_() < 20 && window.m_85449_() > 1.0) {
            double newScale = window.m_85449_();
            if ((newScale -= 1.0) < 1.0) {
                newScale = 1.0;
            }
            window.m_85378_(newScale);
            this.m_6574_(Minecraft.m_91087_(), window.m_85445_(), window.m_85446_());
        } else if (topRightSideWidget != null && topRightSideWidget.m_252907_() >= 20 && resized) {
            RenderingUtils.resetGuiScale();
            this.m_6574_(Minecraft.m_91087_(), window.m_85445_(), window.m_85446_());
        }
        if (this.descriptionAreaEnabled) {
            this.updateDescriptionArea();
        }
    }

    protected void m_264313_(GuiEventListener $$0) {
    }

    protected abstract void onCancel();

    protected abstract void onDone();

    public void m_7379_() {
        this.onCancel();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateSelectedCell();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        if (this.descriptionAreaEnabled && this.descriptionScrollArea != null) {
            this.descriptionScrollArea.m_88315_(graphics, mouseX, mouseY, partial);
        }
        this.scrollArea.m_88315_(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
        this.performInitialWidgetFocusActionInRender();
    }

    public void m_86600_() {
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof CellScrollEntry)) continue;
            CellScrollEntry c = (CellScrollEntry)e;
            c.cell.tick();
        }
    }

    public int getRightSideWidgetWidth() {
        return 150;
    }

    public int getRightSideDefaultSpaceBetweenWidgets() {
        return 5;
    }

    public boolean allowDone() {
        return true;
    }

    public boolean allowEnterForDone() {
        return true;
    }

    protected void addRightSideDefaultSpacer() {
        this.addRightSideSpacer(5);
    }

    protected void addRightSideSpacer(int height) {
        this.rightSideWidgets.add(new RightSideSpacer(height));
    }

    protected <T> CycleButton<T> addRightSideCycleButton(int height, @NotNull ILocalizedValueCycle<T> cycle, @NotNull CycleButton.CycleButtonClickFeedback<T> clickFeedback) {
        return this.addRightSideWidget((T)new CycleButton<T>(0, 0, 0, height, cycle, clickFeedback));
    }

    protected ExtendedButton addRightSideButton(int height, @NotNull Component label, @NotNull Consumer<ExtendedButton> onClick) {
        return this.addRightSideWidget(new ExtendedButton(0, 0, 0, height, label, var1 -> onClick.accept((ExtendedButton)var1)));
    }

    protected <T extends AbstractWidget> T addRightSideWidget(@NotNull T widget) {
        if (widget instanceof NavigatableWidget) {
            NavigatableWidget n = (NavigatableWidget)widget;
            n.setNavigatable(false);
        }
        this.rightSideWidgets.add(widget);
        return widget;
    }

    @NotNull
    protected TextInputCell addTextInputCell(@Nullable CharacterFilter characterFilter, boolean allowEditor, boolean allowEditorPlaceholders) {
        return this.addCell(new TextInputCell(characterFilter, allowEditor, allowEditorPlaceholders));
    }

    @NotNull
    protected LabelCell addLabelCell(@NotNull Component text) {
        return this.addCell(new LabelCell(text));
    }

    protected void addDescriptionEndSeparatorCell() {
        this.addSpacerCell(5);
        this.addSeparatorCell();
        this.addSpacerCell(5);
    }

    @NotNull
    protected SeparatorCell addSeparatorCell(int height) {
        return this.addCell(new SeparatorCell(height));
    }

    @NotNull
    protected SeparatorCell addSeparatorCell() {
        return this.addCell(new SeparatorCell());
    }

    @NotNull
    protected SpacerCell addCellGroupEndSpacerCell() {
        return this.addSpacerCell(7);
    }

    @NotNull
    protected SpacerCell addStartEndSpacerCell() {
        return this.addSpacerCell(20);
    }

    @NotNull
    protected SpacerCell addSpacerCell(int height) {
        return this.addCell(new SpacerCell(height));
    }

    @NotNull
    protected <T> WidgetCell addCycleButtonCell(@NotNull ILocalizedValueCycle<T> cycle, boolean applyDefaultButtonSkin, CycleButton.CycleButtonClickFeedback<T> clickFeedback) {
        return this.addWidgetCell((AbstractWidget)new CycleButton<T>(0, 0, 20, 20, cycle, clickFeedback), applyDefaultButtonSkin);
    }

    @NotNull
    protected WidgetCell addWidgetCell(@NotNull AbstractWidget widget, boolean applyDefaultButtonSkin) {
        return this.addCell(new WidgetCell(widget, applyDefaultButtonSkin));
    }

    @NotNull
    protected <T extends RenderCell> T addCell(@NotNull T cell) {
        this.allCells.add(cell);
        if (cell.ignoreSearch || !this.searchBarEnabled || this.searchBar == null || this.cellMatchesSearch(cell, this.searchBar.m_94155_())) {
            CellScrollEntry entry = new CellScrollEntry(this.scrollArea, cell);
            this.scrollArea.addEntry(entry);
        }
        return (T)((Object)((RenderCell)this.m_7787_((GuiEventListener)cell)));
    }

    protected void updateSelectedCell() {
        RenderCell last = this.selectedCell;
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof CellScrollEntry)) continue;
            CellScrollEntry c = (CellScrollEntry)e;
            if (!c.cell.selectable || !c.cell.selected) continue;
            this.selectedCell = c.cell;
            if (last != this.selectedCell) {
                this.updateDescriptionArea();
            }
            return;
        }
        this.selectedCell = null;
        if (last != this.selectedCell) {
            this.updateDescriptionArea();
        }
    }

    @Nullable
    protected RenderCell getSelectedCell() {
        return this.selectedCell;
    }

    public boolean m_7933_(int keycode, int scancode, int modifiers) {
        if (keycode == 257 && this.allowDone() && this.allowEnterForDone()) {
            this.onDone();
            return true;
        }
        return super.m_7933_(keycode, scancode, modifiers);
    }

    public boolean m_6375_(double $$0, double $$1, int $$2) {
        if (this.searchBarEnabled && this.searchBar != null && !this.searchBar.m_274382_()) {
            this.searchBar.m_93692_(false);
        }
        return super.m_6375_($$0, $$1, $$2);
    }

    public FocusNavigationEvent.ArrowNavigation m_264409_(ScreenDirection $$0) {
        return null;
    }

    public FocusNavigationEvent.TabNavigation m_264442_() {
        return null;
    }

    public abstract class RenderCell
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        private boolean selectable = false;
        private boolean selected = false;
        protected boolean hovered = false;
        protected Supplier<DrawableColor> hoverColorSupplier = () -> UIBase.getUIColorTheme().list_entry_color_selected_hovered;
        @Nullable
        protected Supplier<List<Component>> descriptionSupplier = null;
        @NotNull
        protected Supplier<String> searchStringSupplier = () -> null;
        protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
        protected final Map<String, String> memory = new HashMap<String, String>();
        protected boolean ignoreSearch = false;

        public abstract void renderCell(@NotNull GuiGraphics var1, int var2, int var3, float var4);

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            if (!this.selectable) {
                this.selected = false;
            }
            this.renderCell(graphics, mouseX, mouseY, partial);
            for (GuiEventListener l : this.children) {
                if (!(l instanceof Renderable)) continue;
                Renderable r = (Renderable)l;
                r.m_88315_(graphics, mouseX, mouseY, partial);
            }
        }

        public void tick() {
        }

        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth((int)(CellScreen.this.scrollArea.getInnerWidth() - 40.0f));
            this.setHeight(20);
        }

        protected void updatePosition(@NotNull CellScrollEntry scrollEntry) {
            this.setX((int)(scrollEntry.getX() + 20.0f));
            this.setY((int)scrollEntry.getY());
        }

        @Nullable
        public String getSearchString() {
            return this.searchStringSupplier.get();
        }

        @NotNull
        public Supplier<String> getSearchStringSupplier() {
            return this.searchStringSupplier;
        }

        public RenderCell setSearchStringSupplier(@NotNull Supplier<String> searchStringSupplier) {
            this.searchStringSupplier = searchStringSupplier;
            return this;
        }

        @Nullable
        public Supplier<List<Component>> getDescriptionSupplier() {
            return this.descriptionSupplier;
        }

        public RenderCell setDescriptionSupplier(@Nullable Supplier<List<Component>> descriptionSupplier) {
            this.descriptionSupplier = descriptionSupplier;
            return this;
        }

        public int getTopBottomSpace() {
            return 3;
        }

        public int getX() {
            return this.x;
        }

        public RenderCell setX(int x) {
            this.x = x;
            return this;
        }

        public int getY() {
            return this.y + this.getTopBottomSpace();
        }

        public RenderCell setY(int y) {
            this.y = y;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public RenderCell setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return this.height + this.getTopBottomSpace() * 2;
        }

        public RenderCell setHeight(int height) {
            this.height = height;
            return this;
        }

        public boolean isHovered() {
            return this.hovered;
        }

        public RenderCell setSelected(boolean selected) {
            this.selected = selected;
            if (!this.selectable) {
                this.selected = false;
            }
            if (CellScreen.this.descriptionAreaEnabled) {
                CellScreen.this.updateDescriptionArea();
            }
            return this;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public RenderCell setSelectable(boolean selectable) {
            this.selectable = selectable;
            if (!this.selectable) {
                this.setSelected(false);
            }
            return this;
        }

        public RenderCell setHoverColorSupplier(@NotNull Supplier<DrawableColor> hoverColorSupplier) {
            this.hoverColorSupplier = hoverColorSupplier;
            return this;
        }

        public RenderCell putMemoryValue(@NotNull String key, @NotNull String value) {
            this.memory.put(key, value);
            return this;
        }

        public RenderCell setIgnoreSearch() {
            this.ignoreSearch = true;
            return this;
        }

        @Nullable
        public String getMemoryValue(@NotNull String key) {
            return this.memory.get(key);
        }

        @NotNull
        public List<GuiEventListener> m_6702_() {
            return this.children;
        }

        @NotNull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(@NotNull NarrationElementOutput var1) {
        }

        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (CellScreen.this.scrollArea.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!CellScreen.this.scrollArea.isInnerAreaHovered()) {
                return false;
            }
            if (this.hovered && this.selectable) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        public boolean m_7979_(double $$0, double $$1, int $$2, double $$3, double $$4) {
            if (CellScreen.this.scrollArea.isMouseInteractingWithGrabbers()) {
                return false;
            }
            return super.m_7979_($$0, $$1, $$2, $$3, $$4);
        }

        public boolean m_6348_(double $$0, double $$1, int $$2) {
            if (CellScreen.this.scrollArea.isMouseInteractingWithGrabbers()) {
                return false;
            }
            return super.m_6348_($$0, $$1, $$2);
        }
    }

    public static class SpacerScrollAreaEntry
    extends TextScrollAreaEntry {
        private int spacerHeight;

        public SpacerScrollAreaEntry(ScrollArea parent, int height) {
            super(parent, (Component)Component.m_237119_(), button -> {});
            this.spacerHeight = height;
            this.height = height;
        }

        @Override
        public float getHeight() {
            return this.spacerHeight;
        }

        @Override
        public void setHeight(float height) {
            this.spacerHeight = (int)height;
        }
    }

    protected class CellScrollEntry
    extends ScrollAreaEntry {
        public final RenderCell cell;

        public CellScrollEntry(@NotNull ScrollArea parent, RenderCell cell) {
            super(parent, 10.0f, 10.0f);
            this.clickable = false;
            this.selectable = false;
            this.selectOnClick = false;
            this.playClickSound = false;
            this.setBackgroundColorHover(this.getBackgroundColorNormal());
            this.cell = cell;
        }

        @Override
        public void renderEntry(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.cell.updateSize(this);
            this.setWidth(this.cell.getWidth() + 40);
            if (this.getWidth() < this.parent.getInnerWidth()) {
                this.setWidth(this.parent.getInnerWidth());
            }
            this.setHeight(this.cell.getHeight());
            this.cell.updatePosition(this);
            this.cell.hovered = UIBase.isXYInArea((double)mouseX, (double)mouseY, this.getX(), this.getY(), this.parent.getInnerWidth(), this.getHeight());
            if (this.cell.isSelectable() && this.cell.isHovered() || this.cell == CellScreen.this.selectedCell) {
                RenderingUtils.resetShaderColor(graphics);
                graphics.m_280509_((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.parent.getInnerWidth()), (int)(this.getY() + this.getHeight()), this.cell.hoverColorSupplier.get().getColorInt());
                RenderingUtils.resetShaderColor(graphics);
            }
            this.cell.m_88315_(graphics, mouseX, mouseY, partial);
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        }
    }

    protected class RightSideSpacer
    extends AbstractWidget {
        protected RightSideSpacer(int height) {
            super(0, 0, 0, height, (Component)Component.m_237119_());
        }

        public void m_93692_(boolean var1) {
        }

        public void m_87963_(GuiGraphics graphics, int var2, int var3, float var4) {
        }

        public boolean m_93696_() {
            return false;
        }

        protected void m_168797_(NarrationElementOutput var1) {
        }
    }

    public class TextInputCell
    extends RenderCell {
        public ExtendedEditBox editBox;
        public ExtendedButton openEditorButton;
        public final boolean allowEditor;
        protected boolean widgetSizesSet = false;
        protected BiConsumer<String, TextInputCell> editorCallback = (s, cell) -> cell.editBox.m_94144_(s.replace("\n", "\\n"));
        protected ConsumingSupplier<TextInputCell, String> editorSetTextSupplier = consumes -> {
            if (this.editorMultiLineMode) {
                return consumes.editBox.m_94155_().replace("\\n", "\n");
            }
            return consumes.editBox.m_94155_().replace("\n", "\\n");
        };
        protected boolean editorMultiLineMode = false;

        public TextInputCell(CharacterFilter characterFilter, boolean allowEditor, boolean allowEditorPlaceholders) {
            this.allowEditor = allowEditor;
            this.editBox = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 20, 18, (Component)Component.m_237119_());
            this.editBox.m_94199_(1000000);
            this.editBox.setCharacterFilter(characterFilter);
            UIBase.applyDefaultWidgetSkinTo(this.editBox);
            this.m_6702_().add((GuiEventListener)this.editBox);
            if (this.allowEditor) {
                this.openEditorButton = new ExtendedButton(0, 0, 20, 20, (Component)Component.m_237115_((String)"fancymenu.ui.screens.string_builder_screen.edit_in_editor"), button -> {
                    if (allowEditor) {
                        TextEditorScreen s = new TextEditorScreen(characterFilter != null ? characterFilter.convertToLegacyFilter() : null, callback -> {
                            if (callback != null) {
                                this.editorCallback.accept((String)callback, this);
                            }
                            Minecraft.m_91087_().m_91152_((Screen)CellScreen.this);
                        });
                        s.setMultilineMode(this.editorMultiLineMode);
                        s.setPlaceholdersAllowed(allowEditorPlaceholders);
                        s.setText(this.editorSetTextSupplier.get(this));
                        Minecraft.m_91087_().m_91152_((Screen)s);
                    }
                });
                UIBase.applyDefaultWidgetSkinTo(this.openEditorButton);
                this.m_6702_().add((GuiEventListener)this.openEditorButton);
            }
            this.setSearchStringSupplier(() -> this.editBox.m_94155_());
        }

        @Override
        public void renderCell(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            if (!this.widgetSizesSet) {
                this.setWidgetSizes();
                this.widgetSizesSet = true;
            }
            this.editBox.m_252865_(this.getX() + 1);
            this.editBox.m_253211_(this.getY() + 1);
            if (this.allowEditor) {
                this.openEditorButton.m_252865_(this.getX() + this.getWidth() - this.openEditorButton.m_5711_());
                this.openEditorButton.m_253211_(this.getY());
            }
            if (MouseInput.isLeftMouseDown() && !this.editBox.m_274382_()) {
                this.editBox.m_93692_(false);
            }
        }

        protected void setWidgetSizes() {
            int editorButtonWidth = (this.allowEditor ? Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.openEditorButton.getLabelSupplier().get(this.openEditorButton)) : 0) + 6;
            this.editBox.m_93674_(this.allowEditor ? this.getWidth() - editorButtonWidth - 5 : this.getWidth());
            if (this.allowEditor) {
                this.openEditorButton.m_93674_(editorButtonWidth);
            }
        }

        @Override
        public void tick() {
            this.editBox.m_94120_();
        }

        public TextInputCell setEditorPresetTextSupplier(@NotNull ConsumingSupplier<TextInputCell, String> supplier) {
            this.editorSetTextSupplier = Objects.requireNonNull(supplier);
            return this;
        }

        public TextInputCell setEditorCallback(@NotNull BiConsumer<String, TextInputCell> callback) {
            this.editorCallback = Objects.requireNonNull(callback);
            return this;
        }

        public TextInputCell setEditListener(@Nullable Consumer<String> listener) {
            this.editBox.m_94151_(listener);
            return this;
        }

        @NotNull
        public String getText() {
            return this.editBox.m_94155_();
        }

        public TextInputCell setText(@Nullable String text) {
            if (text == null) {
                text = "";
            }
            this.editBox.m_94144_(text);
            this.editBox.m_94196_(0);
            this.editBox.m_94208_(0);
            this.editBox.setDisplayPosition(0);
            return this;
        }

        public boolean isEditorMultiLineMode() {
            return this.editorMultiLineMode;
        }

        public TextInputCell setEditorMultiLineMode(boolean editorMultiLineMode) {
            this.editorMultiLineMode = editorMultiLineMode;
            return this;
        }
    }

    public class LabelCell
    extends RenderCell {
        @NotNull
        protected Component text;

        public LabelCell(Component label) {
            this.text = label;
            this.setSearchStringSupplier(() -> this.text.getString());
        }

        @Override
        public void renderCell(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            RenderingUtils.resetShaderColor(graphics);
            UIBase.drawElementLabel(graphics, Minecraft.m_91087_().f_91062_, this.text, this.getX(), this.getY());
            RenderingUtils.resetShaderColor(graphics);
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text));
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.setHeight(9);
        }

        @NotNull
        public Component getText() {
            return this.text;
        }

        public LabelCell setText(@NotNull Component text) {
            this.text = text;
            return this;
        }
    }

    public class SpacerCell
    extends RenderCell {
        public SpacerCell(int height) {
            this.setHeight(height);
            this.setWidth(10);
        }

        @Override
        public int getTopBottomSpace() {
            return 0;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }

        @Override
        public RenderCell setSelectable(boolean selectable) {
            throw new RuntimeException("You can't make SpacerCells selectable.");
        }

        @Override
        public void renderCell(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
        }
    }

    public class SeparatorCell
    extends RenderCell {
        protected Supplier<DrawableColor> separatorColorSupplier = () -> UIBase.getUIColorTheme().element_border_color_normal;
        protected int separatorThickness = 1;

        public SeparatorCell() {
            this.setHeight(10);
        }

        public SeparatorCell(int height) {
            this.setHeight(height);
        }

        @Override
        public int getTopBottomSpace() {
            return 0;
        }

        @Override
        public void renderCell(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            int centerY = this.getY() + this.getHeight() / 2;
            int halfThickness = Math.max(1, this.separatorThickness / 2);
            graphics.m_280509_(this.getX(), centerY - (halfThickness > 1 ? halfThickness : 0), this.getX() + this.getWidth(), centerY + halfThickness, this.separatorColorSupplier.get().getColorInt());
            RenderingUtils.resetShaderColor(graphics);
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth((int)(CellScreen.this.scrollArea.getInnerWidth() - 40.0f));
        }

        @NotNull
        public Supplier<DrawableColor> getSeparatorColorSupplier() {
            return this.separatorColorSupplier;
        }

        public SeparatorCell setSeparatorColorSupplier(@NotNull Supplier<DrawableColor> separatorColorSupplier) {
            this.separatorColorSupplier = separatorColorSupplier;
            return this;
        }

        public int getSeparatorThickness() {
            return this.separatorThickness;
        }

        public SeparatorCell setSeparatorThickness(int separatorThickness) {
            this.separatorThickness = separatorThickness;
            return this;
        }
    }

    public class WidgetCell
    extends RenderCell {
        public final AbstractWidget widget;

        public WidgetCell(AbstractWidget widget, boolean applyDefaultSkin) {
            this.widget = widget;
            if (applyDefaultSkin) {
                UIBase.applyDefaultWidgetSkinTo(this.widget);
            }
            this.m_6702_().add((GuiEventListener)this.widget);
            this.setSearchStringSupplier(() -> this.widget.m_6035_().getString());
        }

        @Override
        public void renderCell(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.widget.m_252865_(this.getX());
            this.widget.m_253211_(this.getY());
            this.widget.m_93674_(this.getWidth());
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth((int)(CellScreen.this.scrollArea.getInnerWidth() - 40.0f));
            this.setHeight(this.widget.m_93694_());
        }
    }
}

