/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.cursor;

import com.mojang.blaze3d.platform.TextureUtil;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.resource.resources.texture.SimpleTexture;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CursorHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final long CURSOR_RESIZE_HORIZONTAL = GLFW.glfwCreateStandardCursor((int)221189);
    public static final long CURSOR_RESIZE_VERTICAL = GLFW.glfwCreateStandardCursor((int)221190);
    public static final long CURSOR_RESIZE_ALL = GLFW.glfwCreateStandardCursor((int)221193);
    public static final long CURSOR_WRITING = GLFW.glfwCreateStandardCursor((int)221186);
    public static final long CURSOR_POINTING_HAND = GLFW.glfwCreateStandardCursor((int)221188);
    public static final long CURSOR_NORMAL = GLFW.glfwCreateStandardCursor((int)221185);
    private static final Map<String, CustomCursor> CUSTOM_CURSORS = new HashMap<String, CustomCursor>();
    private static long clientTickCursor = -2L;
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        EventHandler.INSTANCE.registerListenersOf(new CursorHandler());
    }

    public static void registerCustomCursor(@NotNull String uniqueCursorName, @NotNull CustomCursor cursor) {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] CursorHandler accessed too early!");
        }
        LOGGER.info("[FANCYMENU] Registering GLFW custom cursor: NAME: " + uniqueCursorName + " | TEXTURE CONTEXT: " + cursor.textureName);
        CUSTOM_CURSORS.put(Objects.requireNonNull(uniqueCursorName), Objects.requireNonNull(cursor));
    }

    public static void unregisterCustomCursor(@NotNull String cursorName) {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] CursorHandler accessed too early!");
        }
        CustomCursor c = CUSTOM_CURSORS.get(cursorName);
        if (c != null) {
            c.destroy();
        }
        CUSTOM_CURSORS.remove(cursorName);
    }

    @Nullable
    public static CustomCursor getCustomCursor(@NotNull String cursorName) {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] CursorHandler accessed too early!");
        }
        return CUSTOM_CURSORS.get(cursorName);
    }

    public static void setClientTickCursor(long cursor) {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] CursorHandler accessed too early!");
        }
        clientTickCursor = cursor;
    }

    public static void setClientTickCursor(@NotNull String customCursorName) {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] CursorHandler accessed too early!");
        }
        CustomCursor c = CursorHandler.getCustomCursor(customCursorName);
        if (c != null) {
            CursorHandler.setClientTickCursor(c.id_long);
        }
    }

    private static void setCursor(long cursor) {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] CursorHandler accessed too early!");
        }
        GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)cursor);
    }

    @EventListener
    public void onClientTickPre(ClientTickEvent.Pre e) {
        if (clientTickCursor != -1L && clientTickCursor != -2L) {
            CursorHandler.setCursor(clientTickCursor);
            clientTickCursor = -1L;
        } else if (clientTickCursor == -1L) {
            CursorHandler.setCursor(CURSOR_NORMAL);
            clientTickCursor = -2L;
        }
    }

    public static class CustomCursor {
        public final long id_long;
        public final int hotspotX;
        public final int hotspotY;
        @NotNull
        public final SimpleTexture texture;
        @NotNull
        public final String textureName;

        @Nullable
        public static CustomCursor create(@NotNull SimpleTexture texture, int hotspotX, int hotspotY, @NotNull String textureName) {
            ByteBuffer stbBuffer;
            ByteBuffer texResourceBuffer;
            MemoryStack memStack;
            InputStream in;
            CustomCursor customCursor;
            block11: {
                customCursor = null;
                in = null;
                memStack = null;
                texResourceBuffer = null;
                stbBuffer = null;
                try {
                    Objects.requireNonNull(texture);
                    texture.waitForReady(5000L);
                    if (!texture.isReady()) break block11;
                    in = Objects.requireNonNull(texture.open());
                    texResourceBuffer = TextureUtil.readResource((InputStream)in);
                    texResourceBuffer.rewind();
                    if (MemoryUtil.memAddress((ByteBuffer)texResourceBuffer) != 0L) {
                        IntBuffer components;
                        IntBuffer height;
                        memStack = MemoryStack.stackPush();
                        IntBuffer width = memStack.mallocInt(1);
                        stbBuffer = STBImage.stbi_load_from_memory((ByteBuffer)texResourceBuffer, (IntBuffer)width, (IntBuffer)(height = memStack.mallocInt(1)), (IntBuffer)(components = memStack.mallocInt(1)), (int)0);
                        if (stbBuffer != null) {
                            GLFWImage image = GLFWImage.create();
                            long lid = GLFW.glfwCreateCursor((GLFWImage)(image = image.set(texture.getWidth(), texture.getHeight(), stbBuffer)), (int)hotspotX, (int)hotspotY);
                            if (lid != 0L) {
                                customCursor = new CustomCursor(lid, hotspotX, hotspotY, texture, textureName);
                                break block11;
                            }
                            throw new IllegalArgumentException("Failed to create custom cursor! Cursor handle was NULL!");
                        }
                        throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                    }
                    throw new IllegalArgumentException("Invalid buffer! Memory address was NULL!");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (texResourceBuffer != null) {
                try {
                    MemoryUtil.memFree(texResourceBuffer);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (stbBuffer != null) {
                try {
                    STBImage.stbi_image_free(stbBuffer);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            CloseableUtils.closeQuietly(in);
            CloseableUtils.closeQuietly(memStack);
            return customCursor;
        }

        protected CustomCursor(long id_long, int hotspotX, int hotspotY, @NotNull SimpleTexture texture, @NotNull String textureName) {
            this.id_long = id_long;
            this.hotspotX = hotspotX;
            this.hotspotY = hotspotY;
            this.texture = texture;
            this.textureName = textureName;
        }

        public void destroy() {
        }
    }
}

