/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MathRoundPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_DECIMALS = -1;

    public MathRoundPlaceholder() {
        super("math_round");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String numberValue = dps.values.get("num");
        if (numberValue == null) {
            LOGGER.error("[FANCYMENU] Missing 'num' value for 'Round (Math)' placeholder: {}", (Object)dps.placeholderString);
            return null;
        }
        if (!MathUtils.isDouble((String)(numberValue = numberValue.trim()))) {
            LOGGER.error("[FANCYMENU] Invalid 'num' value for 'Round (Math)' placeholder: {}", (Object)dps.placeholderString);
            return null;
        }
        int decimals = this.parseDecimals(dps.values.get("decimals"), dps.placeholderString);
        try {
            if (decimals > 0) {
                BigDecimal rounded = new BigDecimal(numberValue).setScale(decimals, RoundingMode.HALF_UP);
                return rounded.stripTrailingZeros().toPlainString();
            }
            double parsedNumber = Double.parseDouble(numberValue);
            return Long.toString(Math.round(parsedNumber));
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to parse 'Round (Math)' placeholder: " + dps.placeholderString, (Throwable)ex);
            return null;
        }
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("num");
        l.add("decimals");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.math_round", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.math_round.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("num", "3.14");
        values.put("decimals", "-1");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

    private int parseDecimals(@Nullable String decimalsValue, @NotNull String placeholderString) {
        if (decimalsValue == null) {
            return -1;
        }
        String trimmed = decimalsValue.trim();
        if (trimmed.isEmpty()) {
            return -1;
        }
        if (MathUtils.isInteger((String)trimmed)) {
            return Integer.parseInt(trimmed);
        }
        LOGGER.error("[FANCYMENU] Invalid 'decimals' value for 'Round (Math)' placeholder: {} (value: {})", (Object)placeholderString, (Object)decimalsValue);
        return -1;
    }
}

