/*
 * Decompiled with CFR 0.152.
 */
package com.diamondvein;

import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.dataregistry.DataBlock;
import com.diamondvein.BlockDeposits;
import com.diamondvein.ItemBlockDeposits;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="diamondvein")
public class DiamondVein {
    private static DiamondVein instance;
    private final FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
    public static DeferredRegister<Item> ITEMS;
    public static DeferredRegister<Block> BLOCKS;
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private final DataBlock<BlockDeposits.Type, BlockDeposits, ItemBlockDeposits> blockdeposits;

    public DiamondVein() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        BLOCKS.register(this.context.getModEventBus());
        BLOCK_ENTITIES.register(this.context.getModEventBus());
        ITEMS.register(this.context.getModEventBus());
        this.context.getModEventBus().addListener(this::gatherData);
        this.blockdeposits = new DataBlock(BlockDeposits.Type.class, BlockDeposits.class, ItemBlockDeposits.class, BLOCKS, ITEMS, "diamondvein");
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagsProvider blockTags = new BlockTagsProvider(packOutput, lookupProvider, "diamondvein", existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"diamondvein");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"diamondvein");
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"diamondvein");
    }
}

