/*
 * Decompiled with CFR 0.152.
 */
package com.levshx.chibitools.screen;

import com.levshx.chibitools.packets.ATMStatus;
import com.levshx.chibitools.packets.ATMWithdrawPacket;
import com.levshx.chibitools.packets.PacketHandler;
import com.levshx.chibitools.screen.buttons.ATMMiniButton;
import com.levshx.chibitools.screen.buttons.ButtonType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ATMScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("chibitools", "textures/gui/atm.png");
    private final BlockPos blockPos;
    int guiWidth = 237;
    int guiHeight = 167;
    int count = 0;
    double balance = 0.0;
    int cash = 0;
    String lastMessage = Component.m_237110_((String)"screen.chibitools.atm.string.hello", (Object[])new Object[]{this.cash}).getString();

    public ATMScreen(BlockPos blockPos) {
        super((Component)Component.m_237115_((String)"screen.chibitools.atm"));
        this.blockPos = blockPos;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2 - this.guiWidth / 2 + 10;
        int y = this.f_96544_ / 2 - 65;
        this.m_142416_((GuiEventListener)new ATMMiniButton(x + 206, y - 13, ButtonType.CLOSE, button -> this.f_96541_.m_91152_(null)));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"screen.chibitools.atm.button.cash_out"), button -> {
            if (this.count > 0) {
                PacketHandler.INSTANCE.sendToServer((Object)new ATMWithdrawPacket(this.blockPos, this.count));
            }
        }).m_252987_(x, y + 70, 100, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"screen.chibitools.atm.button.credit_to_account"), button -> {
            if (this.count > 0) {
                // empty if block
            }
        }).m_252987_(x + 115, y + 70, 100, 18).m_253136_());
        this.m_142416_((GuiEventListener)new ATMMiniButton(x + 46, y + 47, ButtonType.PLUS_D, button -> this.count += 10));
        this.m_142416_((GuiEventListener)new ATMMiniButton(x + 62, y + 47, ButtonType.PLUS, button -> ++this.count));
        this.m_142416_((GuiEventListener)new ATMMiniButton(x + 138, y + 47, ButtonType.MINUS, button -> {
            if (this.count >= 1) {
                --this.count;
            }
        }));
        this.m_142416_((GuiEventListener)new ATMMiniButton(x + 154, y + 47, ButtonType.MINUS_D, button -> {
            if (this.count >= 10) {
                this.count -= 10;
            }
        }));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int x = (this.f_96543_ - this.guiWidth) / 2;
        int y = (this.f_96544_ - this.guiHeight) / 2;
        guiGraphics.m_280163_(BACKGROUND, x, y, 0.0f, 0.0f, this.guiWidth, this.guiHeight, 256, 256);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.f_96544_ / 2 - this.guiHeight / 2 + 4, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, String.valueOf(this.count), this.f_96543_ / 2 - this.f_96547_.m_92895_(String.valueOf(this.count)) / 2, this.f_96544_ / 2 - 13, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, Component.m_237110_((String)"screen.chibitools.atm.string.balance", (Object[])new Object[]{this.balance}).getString(), this.f_96543_ / 2 - 57, this.f_96544_ / 2 - 64, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, Component.m_237110_((String)"screen.chibitools.atm.string.cash", (Object[])new Object[]{this.cash}).getString(), this.f_96543_ / 2 - 57, this.f_96544_ / 2 - 52, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, this.lastMessage, this.f_96543_ / 2 - this.f_96547_.m_92895_(this.lastMessage) / 2 + 14, this.f_96544_ / 2 + 50, 0xFFFFFF);
        for (Renderable widget : this.f_169369_) {
            ATMMiniButton button;
            if (!(widget instanceof ATMMiniButton) || !(button = (ATMMiniButton)widget).m_5953_(mouseX, mouseY) || button.getButtonTooltip() == Component.m_237119_()) continue;
            guiGraphics.m_280557_(this.f_96547_, button.getButtonTooltip(), mouseX, mouseY);
            break;
        }
    }

    public void updateData(double balance, int cash, ATMStatus status) {
        this.balance = balance;
        this.cash = cash;
        switch (status) {
            case HELLO: {
                this.lastMessage = Component.m_237115_((String)"screen.chibitools.atm.string.hello").getString();
                break;
            }
            case SUCCESS_WITHDRAW: {
                this.lastMessage = Component.m_237115_((String)"screen.chibitools.atm.string.succes_withdraw").getString();
                break;
            }
            case SUCCESS_DEPOSIT: {
                this.lastMessage = Component.m_237115_((String)"screen.chibitools.atm.string.succes_deposit").getString();
                break;
            }
            case INSUFFICIENT_BALANCE: {
                this.lastMessage = Component.m_237115_((String)"screen.chibitools.atm.string.insufficient_balance").getString();
                break;
            }
            case INSUFFICIENT_INVENTORY_SPACE: {
                this.lastMessage = Component.m_237115_((String)"screen.chibitools.atm.string.inssufficient_inventory_space").getString();
                break;
            }
            case ERROR: {
                this.lastMessage = Component.m_237115_((String)"screen.chibitools.atm.string.error").getString();
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

