/*
 * Decompiled with CFR 0.152.
 */
package com.levshx.chibitools.packets;

import com.levshx.chibitools.ChibiToolsMod;
import com.levshx.chibitools.blocks.ATMBlock;
import com.levshx.chibitools.init.ModItems;
import com.levshx.chibitools.packets.ATMDataPacket;
import com.levshx.chibitools.packets.ATMStatus;
import com.levshx.chibitools.packets.PacketHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class ATMWithdrawPacket {
    private int amount;
    private BlockPos pos;

    public ATMWithdrawPacket(BlockPos pos, int amount) {
        this.pos = pos;
        this.amount = amount;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getAmount() {
        return this.amount;
    }

    public static void encode(ATMWithdrawPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.amount);
    }

    public static ATMWithdrawPacket decode(FriendlyByteBuf buffer) {
        return new ATMWithdrawPacket(buffer.m_130135_(), buffer.readInt());
    }

    public static void handle(ATMWithdrawPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Level level;
            ServerPlayer serverPlayer = ((NetworkEvent.Context)context.get()).getSender();
            if (serverPlayer != null && (level = serverPlayer.m_9236_()).m_8055_(packet.getPos()).m_60734_() instanceof ATMBlock && !level.m_5776_() && ChibiToolsMod.isBukkitAvailable) {
                try {
                    int availableSpace = 0;
                    Item moneyItem = (Item)ModItems.MONEY.get();
                    int maxStackSize = moneyItem.m_41459_();
                    for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = serverPlayer.m_150109_().m_8020_(i);
                        if (stack.m_41619_()) {
                            availableSpace += maxStackSize;
                            continue;
                        }
                        if (stack.m_41720_() != moneyItem || stack.m_41613_() >= maxStackSize) continue;
                        availableSpace += maxStackSize - stack.m_41613_();
                    }
                    String username = serverPlayer.m_36316_().getName();
                    Player player = Bukkit.getPlayer((String)username);
                    Plugin vaultPlugin = Bukkit.getPluginManager().getPlugin("Vault");
                    List providers = Bukkit.getServicesManager().getRegistrations(vaultPlugin);
                    Object economy = null;
                    for (RegisteredServiceProvider provider : providers) {
                        if (provider.getService().getName() != "net.milkbowl.vault.economy.Economy") continue;
                        economy = provider.getProvider();
                    }
                    Method getBalanceMethod = economy.getClass().getMethod("getBalance", OfflinePlayer.class);
                    double balance = (Double)getBalanceMethod.invoke(economy, player);
                    int cash = 0;
                    for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = serverPlayer.m_150109_().m_8020_(i);
                        if (stack.m_41720_() != ModItems.MONEY.get()) continue;
                        cash += stack.m_41613_();
                    }
                    if (availableSpace >= packet.getAmount()) {
                        Method withdrawMethod = economy.getClass().getMethod("withdrawPlayer", String.class, Double.TYPE);
                        Object response = withdrawMethod.invoke(economy, username, packet.getAmount());
                        Method successMethod = response.getClass().getMethod("transactionSuccess", new Class[0]);
                        boolean success = (Boolean)successMethod.invoke(response, new Object[0]);
                        balance = (Double)getBalanceMethod.invoke(economy, player);
                        if (success) {
                            ATMWithdrawPacket.addMoneyToPlayer(serverPlayer, packet.getAmount());
                            cash = 0;
                            for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                                ItemStack stack = serverPlayer.m_150109_().m_8020_(i);
                                if (stack.m_41720_() != ModItems.MONEY.get()) continue;
                                cash += stack.m_41613_();
                            }
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ATMDataPacket(balance, cash, ATMStatus.SUCCESS_WITHDRAW));
                            ChibiToolsMod.LOGGER.info("\u0418\u0433\u0440\u043e\u043a {} \u0441\u043d\u044f\u043b {} \u0434\u0435\u043d\u044f\u043a \u0432 \u0431\u0430\u043d\u043a\u043e\u043c\u0430\u0442\u0435", (Object)username, (Object)packet.getAmount());
                        } else {
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ATMDataPacket(balance, cash, ATMStatus.INSUFFICIENT_BALANCE));
                            ChibiToolsMod.LOGGER.info("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0431\u0430\u043d\u043a\u043e\u043c\u0430\u0442\u0435 {}", (Object)username);
                        }
                    } else {
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ATMDataPacket(balance, cash, ATMStatus.INSUFFICIENT_INVENTORY_SPACE));
                        ChibiToolsMod.LOGGER.info("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043c\u0435\u0441\u0442\u0430 \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435 \u0447\u0442\u043e\u0431\u044b \u0432\u044b\u0432\u0435\u0441\u0442\u0438 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 {}", (Object)username);
                    }
                }
                catch (Exception e) {
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ATMDataPacket(0.0, 0, ATMStatus.ERROR));
                    ChibiToolsMod.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u044e\u0442\u044b \u0438\u0433\u0440\u043e\u043a\u0430: {}", (Object)e.getMessage());
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    private static void addMoneyToPlayer(ServerPlayer player, int amount) {
        ItemStack stack;
        int i;
        Item moneyItem = (Item)ModItems.MONEY.get();
        int maxStackSize = 64;
        int remaining = amount;
        for (i = 0; i < player.m_150109_().m_6643_() && remaining > 0; ++i) {
            stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != moneyItem || stack.m_41613_() >= maxStackSize) continue;
            int spaceInStack = maxStackSize - stack.m_41613_();
            int toAdd = Math.min(spaceInStack, remaining);
            stack.m_41769_(toAdd);
            remaining -= toAdd;
        }
        for (i = 0; i < player.m_150109_().m_6643_() && remaining > 0; ++i) {
            stack = player.m_150109_().m_8020_(i);
            if (!stack.m_41619_()) continue;
            int toAdd = Math.min(maxStackSize, remaining);
            ItemStack newStack = new ItemStack((ItemLike)moneyItem, toAdd);
            player.m_150109_().m_6836_(i, newStack);
            remaining -= toAdd;
        }
        if (remaining > 0) {
            System.out.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c " + remaining + " \u0434\u0435\u043d\u0435\u0433 \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0438\u0433\u0440\u043e\u043a\u0430 " + player.m_7755_().getString());
        }
        player.f_36096_.m_38946_();
    }
}

