/*
 * Decompiled with CFR 0.152.
 */
package com.levshx.chibitools.packets;

import com.levshx.chibitools.packets.ATMStatus;
import com.levshx.chibitools.packets.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ATMDataPacket {
    private final double balance;
    private final int cash;
    private final ATMStatus status;

    public ATMDataPacket(double balance, int cash, ATMStatus status) {
        this.balance = balance;
        this.cash = cash;
        this.status = status;
    }

    public static void encode(ATMDataPacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.balance);
        buffer.writeInt(packet.cash);
        buffer.m_130068_((Enum)packet.status);
    }

    public static ATMDataPacket decode(FriendlyByteBuf buffer) {
        return new ATMDataPacket(buffer.readDouble(), buffer.readInt(), (ATMStatus)buffer.m_130066_(ATMStatus.class));
    }

    public static void handle(ATMDataPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientPacketHandler.handleATMData(packet));
        context.get().setPacketHandled(true);
    }

    public double getBalance() {
        return this.balance;
    }

    public int getCash() {
        return this.cash;
    }

    public ATMStatus getStatus() {
        return this.status;
    }
}

