/*
 * Decompiled with CFR 0.152.
 */
package com.levshx.chibitools.blocks;

import com.levshx.chibitools.ChibiToolsMod;
import com.levshx.chibitools.init.ModItems;
import com.levshx.chibitools.packets.ATMDataPacket;
import com.levshx.chibitools.packets.ATMStatus;
import com.levshx.chibitools.packets.PacketHandler;
import com.levshx.chibitools.screen.ATMScreen;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class ATMBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public ATMBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.chibitools.atm.description"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.chibitools.atm.howtouse"));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            direction = context.m_8125_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                double balance = this.getPlayerBalance(serverPlayer);
                int cash = this.getPlayerCash(serverPlayer);
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ATMDataPacket(balance, cash, ATMStatus.HELLO));
            }
            return InteractionResult.CONSUME;
        }
        this.openClientScreen(pos);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientScreen(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new ATMScreen(pos));
    }

    private double getPlayerBalance(ServerPlayer serverPlayer) {
        if (ChibiToolsMod.isBukkitAvailable) {
            try {
                String username = serverPlayer.m_36316_().getName();
                org.bukkit.entity.Player player = Bukkit.getPlayer((String)username);
                Plugin vaultPlugin = Bukkit.getPluginManager().getPlugin("Vault");
                List providers = Bukkit.getServicesManager().getRegistrations(vaultPlugin);
                Object economy = null;
                for (RegisteredServiceProvider provider : providers) {
                    if (provider.getService().getName() != "net.milkbowl.vault.economy.Economy") continue;
                    economy = provider.getProvider();
                }
                Method getBalanceMethod = economy.getClass().getMethod("getBalance", OfflinePlayer.class);
                double balance = (Double)getBalanceMethod.invoke(economy, player);
                return balance;
            }
            catch (Exception e) {
                ChibiToolsMod.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u044e\u0442\u044b \u0438\u0433\u0440\u043e\u043a\u0430: {}", (Object)e.getMessage());
                return 0.99;
            }
        }
        return 0.0;
    }

    private int getPlayerCash(ServerPlayer player) {
        int totalMoney = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != ModItems.MONEY.get()) continue;
            totalMoney += stack.m_41613_();
        }
        return totalMoney;
    }
}

