/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.utils;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.handlers.NetworkHandler;
import ru.chibicraft.chibiiscute.packets.PacketScreenshotBegin;
import ru.chibicraft.chibiiscute.packets.PacketScreenshotChunk;
import ru.chibicraft.chibiiscute.packets.PacketScreenshotEnd;

@OnlyIn(value=Dist.CLIENT)
public class ClientScreenshotHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int CHUNK_SIZE = 32000;

    public static void takeScreenshotAndSend(String requesterName) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            RenderTarget framebuffer = mc.m_91385_();
            NativeImage image = Screenshot.m_92279_((RenderTarget)framebuffer);
            BufferedImage bufferedImage = new BufferedImage(image.m_84982_(), image.m_85084_(), 1);
            int[] pixels = new int[image.m_84982_() * image.m_85084_()];
            for (int y = 0; y < image.m_85084_(); ++y) {
                for (int x = 0; x < image.m_84982_(); ++x) {
                    int pixel = image.m_84985_(x, y);
                    int b = pixel >> 16 & 0xFF;
                    int g = pixel >> 8 & 0xFF;
                    int r = pixel & 0xFF;
                    pixels[y * image.m_84982_() + x] = r << 16 | g << 8 | b;
                }
            }
            bufferedImage.setRGB(0, 0, image.m_84982_(), image.m_85084_(), pixels, 0, image.m_84982_());
            image.close();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean success = ImageIO.write((RenderedImage)bufferedImage, "jpeg", baos);
            if (!success) {
                return;
            }
            byte[] imageData = baos.toByteArray();
            if (imageData.length == 0) {
                return;
            }
            String transferId = UUID.randomUUID().toString();
            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketScreenshotBegin(requesterName, imageData.length, transferId));
            int totalChunks = (int)Math.ceil((double)imageData.length / 32000.0);
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * 32000;
                int end = Math.min(start + 32000, imageData.length);
                byte[] chunk = new byte[end - start];
                System.arraycopy(imageData, start, chunk, 0, chunk.length);
                NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketScreenshotChunk(transferId, i, chunk));
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketScreenshotEnd(transferId));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

