/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.render.font;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;
import ru.chibicraft.chibiiscute.render.font.ModernGlyphCache;

public class ModernStringCache {
    private static final int BASELINE_OFFSET = 7;
    static final int GLYPH_BORDER = 1;
    private final ModernGlyphCache glyphCache;
    private final int[] colorTable = new int[32];
    private final Map<String, CachedString> stringCache = new WeakHashMap<String, CachedString>();
    private final Map<String, CachedString> weakRefCache = new WeakHashMap<String, CachedString>();
    private Glyph[][] digitGlyphs = new Glyph[4][];
    private boolean digitGlyphsReady = false;
    private boolean antiAliasEnabled = false;
    private float fontHeight;

    public ModernStringCache() {
        this.glyphCache = new ModernGlyphCache();
        this.initializeColorTable();
        this.cacheDigitGlyphs();
    }

    private void initializeColorTable() {
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            this.colorTable[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }

    public void setDefaultFont(String fontName, int fontSize, boolean antiAlias) {
        this.glyphCache.setDefaultFont(fontName, fontSize, antiAlias);
        this.antiAliasEnabled = antiAlias;
        this.clearCache();
        this.cacheUnicodeGlyphs();
        this.cacheDigitGlyphs();
        this.updateHeight();
    }

    public void setCustomFont(InputStream stream, int fontSize, boolean antiAlias) throws Exception {
        this.glyphCache.setCustomFont(stream, fontSize, antiAlias);
        this.antiAliasEnabled = antiAlias;
        this.clearCache();
        this.cacheUnicodeGlyphs();
        this.cacheDigitGlyphs();
        this.updateHeight();
    }

    private void clearCache() {
        this.stringCache.clear();
        this.weakRefCache.clear();
    }

    private void cacheUnicodeGlyphs() {
        StringBuilder sb = new StringBuilder();
        for (char c = ' '; c < '\u0400'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        this.cacheString(sb.toString());
    }

    private void updateHeight() {
        CachedString sample = this.cacheString("AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890");
        float maxHeight = 0.0f;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (Glyph g : sample.glyphs) {
            if ((float)g.texture.height > maxHeight) {
                maxHeight = g.texture.height;
            }
            if (g.y < minY) {
                minY = g.y;
            }
            if (!(g.y > maxY)) continue;
            maxY = g.y;
        }
        this.fontHeight = (maxY + maxHeight) / 2.0f - minY / 2.0f;
    }

    private void cacheDigitGlyphs() {
        this.digitGlyphsReady = false;
        this.digitGlyphs[0] = this.cacheString((String)"0123456789").glyphs;
        this.digitGlyphs[1] = this.cacheString((String)"\u00a7l0123456789").glyphs;
        this.digitGlyphs[2] = this.cacheString((String)"\u00a7o0123456789").glyphs;
        this.digitGlyphs[3] = this.cacheString((String)"\u00a7l\u00a7o0123456789").glyphs;
        this.digitGlyphsReady = true;
    }

    public float renderString(PoseStack poseStack, String str, float x, float y, int color, boolean shadow) {
        if (str == null || str.isEmpty()) {
            return x;
        }
        CachedString cached = this.cacheString(str);
        y += 7.0f;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int currentColor = color;
        int fontStyle = 0;
        int colorIndex = 0;
        for (int i = 0; i < cached.glyphs.length; ++i) {
            Glyph digitGlyph;
            char c;
            Glyph glyph = cached.glyphs[i];
            while (colorIndex < cached.colorCodes.length && glyph.stringIndex >= cached.colorCodes[colorIndex].stringIndex) {
                currentColor = this.applyColorCode(cached.colorCodes[colorIndex].colorCode, color, shadow);
                fontStyle = cached.colorCodes[colorIndex].fontStyle;
                ++colorIndex;
            }
            if (this.digitGlyphsReady && (c = str.charAt(glyph.stringIndex)) >= '0' && c <= '9' && (digitGlyph = this.digitGlyphs[fontStyle][c - 48]) != null) {
                glyph = digitGlyph;
            }
            this.renderGlyph(matrix, bufferSource, glyph, x + glyph.x / 2.0f, y + glyph.y / 2.0f, currentColor, shadow);
        }
        bufferSource.m_109911_();
        if (cached.specialRender) {
            this.renderSpecialEffects(poseStack, str, cached, x, y, color, shadow);
        }
        return x + (float)cached.advance / 2.0f;
    }

    private void renderGlyph(Matrix4f matrix, MultiBufferSource.BufferSource bufferSource, Glyph glyph, float x, float y, int color, boolean shadow) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (shadow) {
            b = 0.0f;
            g = 0.0f;
            r = 0.0f;
            a *= 0.25f;
        }
        VertexConsumer buffer = bufferSource.m_6299_(glyph.texture.renderType);
        float x1 = x;
        float x2 = x + (float)glyph.texture.width / 2.0f;
        float y1 = y;
        float y2 = y + (float)glyph.texture.height / 2.0f;
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.texture.u1, glyph.texture.v1).m_5752_();
        buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.texture.u1, glyph.texture.v2).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.texture.u2, glyph.texture.v2).m_5752_();
        buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.texture.u2, glyph.texture.v1).m_5752_();
    }

    private void renderSpecialEffects(PoseStack poseStack, String str, CachedString cached, float x, float y, int color, boolean shadow) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int currentColor = color;
        byte renderStyle = 0;
        int colorIndex = 0;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < cached.glyphs.length; ++i) {
            float y2;
            float y1;
            Glyph glyph = cached.glyphs[i];
            while (colorIndex < cached.colorCodes.length && glyph.stringIndex >= cached.colorCodes[colorIndex].stringIndex) {
                currentColor = this.applyColorCode(cached.colorCodes[colorIndex].colorCode, color, shadow);
                renderStyle = cached.colorCodes[colorIndex].renderStyle;
                ++colorIndex;
            }
            float r = (float)(currentColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(currentColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(currentColor & 0xFF) / 255.0f;
            float a = (float)(currentColor >> 24 & 0xFF) / 255.0f;
            float glyphX = x + glyph.x / 2.0f;
            float advanceX = x + (glyph.x + glyph.advance) / 2.0f;
            if ((renderStyle & 1) != 0) {
                y1 = y + 0.5f;
                y2 = y + 1.5f;
                buffer.m_252986_(matrix, glyphX, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, glyphX, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, advanceX, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, advanceX, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
            }
            if ((renderStyle & 2) == 0) continue;
            y1 = y - 3.0f;
            y2 = y - 2.0f;
            buffer.m_252986_(matrix, glyphX, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, glyphX, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, advanceX, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, advanceX, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        tessellator.m_85914_();
    }

    public float getStringWidth(String str) {
        if (str == null || str.isEmpty()) {
            return 0.0f;
        }
        return (float)this.cacheString((String)str).advance / 2.0f;
    }

    private int applyColorCode(int colorCode, int baseColor, boolean shadow) {
        if (colorCode != -1) {
            colorCode = shadow ? colorCode + 16 : colorCode;
            return this.colorTable[colorCode] & 0xFFFFFF | baseColor & 0xFF000000;
        }
        return baseColor;
    }

    private CachedString cacheString(String str) {
        return this.stringCache.computeIfAbsent(str, this::createCachedString);
    }

    private CachedString createCachedString(String str) {
        CachedString cached = new CachedString();
        char[] text = str.toCharArray();
        ArrayList<ColorCode> colorCodes = new ArrayList<ColorCode>();
        int strippedLength = this.processColorCodes(str, text, colorCodes, cached);
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        cached.advance = this.layoutText(glyphs, text, 0, strippedLength, colorCodes);
        cached.glyphs = glyphs.toArray(new Glyph[0]);
        this.adjustColorCodePositions(colorCodes, glyphs);
        cached.colorCodes = colorCodes.toArray(new ColorCode[0]);
        return cached;
    }

    private int processColorCodes(String str, char[] text, List<ColorCode> colorCodes, CachedString cached) {
        int shift = 0;
        int fontStyle = 0;
        int renderStyle = 0;
        int colorCode = -1;
        for (int i = 0; i < text.length - 1; ++i) {
            if (text[i] != '\u00a7') continue;
            char codeChar = Character.toLowerCase(text[i + 1]);
            int code = "0123456789abcdefklmnor".indexOf(codeChar);
            switch (code) {
                case 16: {
                    break;
                }
                case 17: {
                    fontStyle = (byte)(fontStyle | 1);
                    break;
                }
                case 18: {
                    renderStyle = (byte)(renderStyle | 2);
                    cached.specialRender = true;
                    break;
                }
                case 19: {
                    renderStyle = (byte)(renderStyle | 1);
                    cached.specialRender = true;
                    break;
                }
                case 20: {
                    fontStyle = (byte)(fontStyle | 2);
                    break;
                }
                case 21: {
                    fontStyle = 0;
                    renderStyle = 0;
                    colorCode = -1;
                    break;
                }
                default: {
                    if (code < 0 || code > 15) break;
                    colorCode = (byte)code;
                    fontStyle = 0;
                    renderStyle = 0;
                }
            }
            ColorCode cc = new ColorCode();
            cc.stringIndex = i - shift;
            cc.colorCode = (byte)colorCode;
            cc.fontStyle = (byte)fontStyle;
            cc.renderStyle = (byte)renderStyle;
            colorCodes.add(cc);
            System.arraycopy(text, i + 2, text, i, text.length - i - 2);
            shift += 2;
            --i;
        }
        return text.length - shift;
    }

    private int layoutText(List<Glyph> glyphs, char[] text, int start, int limit, List<ColorCode> colorCodes) {
        int advance = 0;
        byte currentStyle = 0;
        int colorIndex = 0;
        while (start < limit) {
            while (colorIndex < colorCodes.size() && start >= colorCodes.get((int)colorIndex).stringIndex) {
                currentStyle = colorCodes.get((int)colorIndex).fontStyle;
                ++colorIndex;
            }
            int next = limit;
            if (colorIndex < colorCodes.size()) {
                next = Math.min(next, colorCodes.get((int)colorIndex).stringIndex);
            }
            advance = this.layoutTextSegment(glyphs, text, start, next, advance, currentStyle);
            start = next;
        }
        return advance;
    }

    private int layoutTextSegment(List<Glyph> glyphs, char[] text, int start, int limit, int advance, int style) {
        if (this.digitGlyphsReady) {
            for (int i = start; i < limit; ++i) {
                if (text[i] < '0' || text[i] > '9') continue;
                text[i] = 48;
            }
        }
        Font font = this.glyphCache.lookupFont(text, start, limit, style);
        this.glyphCache.cacheGlyphs(font, text, start, limit, 0);
        GlyphVector vector = this.glyphCache.layoutGlyphVector(font, text, start, limit, 0);
        int numGlyphs = vector.getNumGlyphs();
        Glyph prevGlyph = null;
        for (int i = 0; i < numGlyphs; ++i) {
            Glyph glyph = new Glyph();
            glyph.stringIndex = start + vector.getGlyphCharIndex(i);
            glyph.texture = this.glyphCache.lookupGlyph(font, vector.getGlyphCode(i));
            Rectangle bounds = vector.getGlyphPixelBounds(i, null, advance, 0.0f);
            glyph.x = bounds.x;
            glyph.y = bounds.y;
            if (prevGlyph != null) {
                prevGlyph.advance = glyph.x - prevGlyph.x;
            }
            glyphs.add(glyph);
            prevGlyph = glyph;
        }
        advance = (int)vector.getGlyphPosition(numGlyphs).getX();
        if (prevGlyph != null) {
            prevGlyph.advance = (float)advance - prevGlyph.x;
        }
        return advance;
    }

    private void adjustColorCodePositions(List<ColorCode> colorCodes, List<Glyph> glyphs) {
        int shift = 0;
        int colorIndex = 0;
        for (int i = 0; i < glyphs.size(); ++i) {
            Glyph glyph = glyphs.get(i);
            while (colorIndex < colorCodes.size() && glyph.stringIndex + shift >= colorCodes.get((int)colorIndex).stringIndex) {
                shift += 2;
                ++colorIndex;
            }
            glyph.stringIndex += shift;
        }
    }

    private static class Glyph {
        int stringIndex;
        ModernGlyphCache.GlyphInfo texture;
        float x;
        float y;
        float advance;

        private Glyph() {
        }
    }

    private static class CachedString {
        Glyph[] glyphs;
        ColorCode[] colorCodes;
        int advance;
        boolean specialRender;

        private CachedString() {
        }
    }

    private static class ColorCode {
        int stringIndex;
        byte colorCode;
        byte fontStyle;
        byte renderStyle;

        private ColorCode() {
        }
    }
}

