/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.render.font;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.render.font.ModernGlyphCache;

public class FontMagicObj {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ModernGlyphCache glyphCache;
    public boolean useCustomFont;

    public FontMagicObj(String fontType, int fontSize) {
        this(fontType, fontSize, null);
    }

    public FontMagicObj(String fontType, int fontSize, ResourceLocation resLoc) {
        block12: {
            this.useCustomFont = true;
            this.glyphCache = new ModernGlyphCache();
            LOGGER.info("Initializing font: {}, ResourceLocation: {}", (Object)fontType, (Object)resLoc);
            try {
                if (resLoc != null) {
                    try {
                        LOGGER.info("Attempting to load font from: {}", (Object)resLoc);
                        Optional resourceOpt = Minecraft.m_91087_().m_91098_().m_213713_(resLoc);
                        if (resourceOpt.isPresent()) {
                            try (InputStream stream = ((Resource)resourceOpt.get()).m_215507_();){
                                this.glyphCache.setCustomFont(stream, fontSize, true);
                                LOGGER.info("Successfully loaded font: {}, Size: {}", (Object)this.getName(), (Object)fontSize);
                                break block12;
                            }
                        }
                        LOGGER.warn("Resource not found: {}", (Object)resLoc);
                        this.fallbackToDefault(fontSize);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error loading font from " + String.valueOf(resLoc), (Throwable)e);
                        this.fallbackToDefault(fontSize);
                    }
                    break block12;
                }
                LOGGER.info("No ResourceLocation provided, using default font");
                this.fallbackToDefault(fontSize);
            }
            catch (Exception e) {
                LOGGER.error("Critical error loading font " + fontType, (Throwable)e);
                this.fallbackToDefault(fontSize);
            }
        }
    }

    private void fallbackToDefault(int fontSize) {
        try {
            this.glyphCache.setDefaultFont("Arial", fontSize, true);
            LOGGER.info("Falling back to Arial, size {}", (Object)fontSize);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load fallback font", (Throwable)ex);
            this.useCustomFont = false;
        }
    }

    public float height() {
        if (this.useCustomFont) {
            return this.glyphCache.getFontHeight();
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9.0f;
    }

    public float width(String text) {
        if (this.useCustomFont) {
            return this.glyphCache.getStringWidth(text);
        }
        return Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public TextFont getTextFont() {
        return new TextFont();
    }

    public float drawStringWithShadow(String text, float x, float y, int color) {
        if (this.useCustomFont) {
            PoseStack poseStack = new PoseStack();
            return this.glyphCache.renderString(poseStack, text, x, y, color, true);
        }
        PoseStack poseStack = new PoseStack();
        Minecraft.m_91087_().f_91062_.m_271703_(text, x, y, color, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        return x + (float)Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public float drawString(String text, float x, float y, int color) {
        if (this.useCustomFont) {
            PoseStack poseStack = new PoseStack();
            return this.glyphCache.renderString(poseStack, text, x, y, color, false);
        }
        PoseStack poseStack = new PoseStack();
        Minecraft.m_91087_().f_91062_.m_271703_(text, x, y, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        return x + (float)Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public String getName() {
        if (!this.useCustomFont) {
            return "Minecraft";
        }
        return this.glyphCache.getFontName();
    }

    public class TextFont {
        public String trimStringToWidth(String text, int width, boolean reverse) {
            if (FontMagicObj.this.useCustomFont) {
                while (text.length() > 0 && FontMagicObj.this.glyphCache.getStringWidth(text) > (float)width) {
                    text = text.substring(0, text.length() - 1);
                }
                return text;
            }
            return Minecraft.m_91087_().f_91062_.m_92834_(text, width);
        }

        public float width(String text) {
            return FontMagicObj.this.width(text);
        }
    }

    public static enum FontAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

