/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.render.elem;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix4f;

public class GifAnim {
    private List<DynamicTexture> frames;
    private int currentFrame = 0;
    private boolean isPlaying = true;
    private long lastFrameTime;
    private int frameDelay = 100;

    public GifAnim(ResourceLocation location) throws IOException {
        this(GifAnim.getResourceStream(location));
    }

    public GifAnim(InputStream stream) {
        this.frames = this.loadFrames(stream);
        this.lastFrameTime = System.currentTimeMillis();
    }

    public GifAnim(List<DynamicTexture> frames) {
        this.frames = frames;
        this.lastFrameTime = System.currentTimeMillis();
    }

    private static InputStream getResourceStream(ResourceLocation location) throws IOException {
        Optional resourceOpt = Minecraft.m_91087_().m_91098_().m_213713_(location);
        if (resourceOpt.isPresent()) {
            return ((Resource)resourceOpt.get()).m_215507_();
        }
        throw new IOException("Resource not found: " + String.valueOf(location));
    }

    private List<DynamicTexture> loadFrames(InputStream stream) {
        LinkedList<DynamicTexture> frameList = new LinkedList<DynamicTexture>();
        try {
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            ImageInputStream inputStream = ImageIO.createImageInputStream(stream);
            reader.setInput(inputStream);
            int frameCount = reader.getNumImages(true);
            for (int i = 0; i < frameCount; ++i) {
                BufferedImage frameImage = reader.read(i);
                NativeImage nativeImage = this.convertToNativeImage(frameImage);
                frameList.add(new DynamicTexture(nativeImage));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load GIF animation", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return frameList;
    }

    private NativeImage convertToNativeImage(BufferedImage image) {
        NativeImage nativeImage = new NativeImage(image.getWidth(), image.getHeight(), false);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                nativeImage.m_84988_(x, y, rgb);
            }
        }
        return nativeImage;
    }

    public void render(PoseStack poseStack, float x, float y, float width, float height) {
        if (!this.isPlaying || this.frames.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFrameTime > (long)this.frameDelay) {
            this.currentFrame = (this.currentFrame + 1) % this.frames.size();
            this.lastFrameTime = currentTime;
        }
        DynamicTexture texture = this.frames.get(this.currentFrame);
        this.renderTexture(poseStack, texture, x, y, width, height);
    }

    private void renderTexture(PoseStack poseStack, DynamicTexture texture, float x, float y, float width, float height) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)texture.m_117963_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, x, y + height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, x + width, y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, x, y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    public void setFrameDelay(int delayMs) {
        this.frameDelay = delayMs;
    }

    public void play() {
        this.isPlaying = true;
    }

    public void pause() {
        this.isPlaying = false;
    }

    public void stop() {
        this.isPlaying = false;
        this.currentFrame = 0;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void dispose() {
        for (DynamicTexture texture : this.frames) {
            texture.close();
        }
        this.frames.clear();
    }
}

