/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import ru.chibicraft.chibiiscute.gui.GuiCustomTab;
import ru.chibicraft.chibiiscute.utils.PlayerInfoObj;

public class PacketSyncPlayerData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, PlayerInfoObj> playerData;
    private final double tps5s;

    public PacketSyncPlayerData(Map<String, PlayerInfoObj> playerData, double tps5s) {
        this.playerData = playerData;
        this.tps5s = tps5s;
    }

    public static void encode(PacketSyncPlayerData msg, FriendlyByteBuf buf) {
        try {
            if (msg == null || msg.playerData == null) {
                LOGGER.error("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c null \u043f\u0430\u043a\u0435\u0442 \u0438\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0435");
                buf.writeDouble(0.0);
                buf.writeInt(0);
                return;
            }
            buf.writeDouble(msg.tps5s);
            buf.writeInt(msg.playerData.size());
            for (Map.Entry<String, PlayerInfoObj> entry : msg.playerData.entrySet()) {
                String username = entry.getKey();
                PlayerInfoObj info = entry.getValue();
                if (username == null || info == null) {
                    LOGGER.warn("\u041f\u0440\u043e\u043f\u0443\u0441\u043a null \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438");
                    continue;
                }
                buf.m_130070_(username != null ? username : "");
                buf.m_130070_(info.getRole() != null ? info.getRole() : "");
                buf.m_130070_(info.getRoleDisplayName() != null ? info.getRoleDisplayName() : "");
                buf.writeInt(info.getWeight());
            }
            LOGGER.debug("\u0417\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0430\u043a\u0435\u0442 \u0441 {} \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438", (Object)msg.playerData.size());
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u043a\u0435\u0442\u0430: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0430\u043a\u0435\u0442\u0430", e);
        }
    }

    public static PacketSyncPlayerData decode(FriendlyByteBuf buf) {
        double tps5s = 0.0;
        HashMap<String, PlayerInfoObj> playerData = new HashMap<String, PlayerInfoObj>();
        try {
            if (buf == null) {
                LOGGER.error("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437 null \u0431\u0443\u0444\u0435\u0440\u0430");
                return new PacketSyncPlayerData(playerData, tps5s);
            }
            tps5s = buf.readDouble();
            int size = buf.readInt();
            if (size < 0 || size > 1000) {
                LOGGER.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432: {}", (Object)size);
                size = 0;
            }
            for (int i = 0; i < size; ++i) {
                try {
                    String username = buf.m_130277_();
                    String role = buf.m_130277_();
                    String roleDisplayName = buf.m_130277_();
                    int weight = buf.readInt();
                    if (username == null || username.isEmpty()) {
                        LOGGER.warn("\u041f\u0440\u043e\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u043e\u043a\u0430 \u0441 \u043f\u0443\u0441\u0442\u044b\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {}", (Object)i);
                        continue;
                    }
                    if (roleDisplayName == null || roleDisplayName.isEmpty()) {
                        roleDisplayName = PacketSyncPlayerData.formatGroupName(role);
                    }
                    if (role == null) {
                        role = "default";
                    }
                    PlayerInfoObj playerInfo = new PlayerInfoObj(role, roleDisplayName, username, weight);
                    playerData.put(username, playerInfo);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u0430 \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {}: {}", (Object)i, (Object)e.getMessage());
                }
            }
            LOGGER.debug("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0430\u043a\u0435\u0442 \u0441 {} \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438", (Object)playerData.size());
        }
        catch (Exception e) {
            LOGGER.error("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0430\u043a\u0435\u0442\u0430: {}", (Object)e.getMessage(), (Object)e);
        }
        return new PacketSyncPlayerData(playerData, tps5s);
    }

    public static void handle(PacketSyncPlayerData msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context == null) {
            LOGGER.error("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0441\u0435\u0442\u0435\u0432\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f null");
            return;
        }
        context.enqueueWork(() -> {
            try {
                if (msg == null || msg.playerData == null) {
                    LOGGER.warn("\u041f\u043e\u043b\u0443\u0447\u0435\u043d null \u043f\u0430\u043a\u0435\u0442 \u0438\u043b\u0438 null \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0433\u0440\u043e\u043a\u043e\u0432");
                    return;
                }
                double tps = msg.tps5s;
                GuiCustomTab.updatePlayerData(msg.playerData);
                GuiCustomTab.updateServerMetrics(tps);
            }
            catch (Exception e) {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }

    public static double getTPS5s() {
        try {
            if (Bukkit.getServer() == null) {
                LOGGER.debug("Bukkit \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430 TPS");
                return 0.0;
            }
            Object minecraftServer = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            if (minecraftServer == null) {
                LOGGER.debug("Minecraft \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430 TPS");
                return 0.0;
            }
            double[] recentTps = (double[])minecraftServer.getClass().getField("recentTps").get(minecraftServer);
            if (recentTps == null || recentTps.length == 0) {
                LOGGER.debug("\u041c\u0430\u0441\u0441\u0438\u0432 recentTps \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
                return 0.0;
            }
            double tps = recentTps[0];
            if (tps < 0.0) {
                tps = 0.0;
            } else if (tps > 25.0) {
                tps = 25.0;
            }
            return tps;
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            LOGGER.debug("\u041c\u0435\u0442\u043e\u0434 \u0438\u043b\u0438 \u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430 TPS \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e: {}", (Object)e.getMessage());
            return 0.0;
        }
        catch (Exception e) {
            LOGGER.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 TPS: {}", (Object)e.getMessage());
            return 0.0;
        }
    }

    private static String formatGroupName(String group) {
        if (group == null || group.isEmpty()) {
            return "\u0418\u0433\u0440\u043e\u043a";
        }
        switch (group.toLowerCase()) {
            case "admin": 
            case "administrator": {
                return "\u0410\u0434\u043c\u0438\u043d";
            }
            case "moderator": 
            case "mod": {
                return "\u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440";
            }
            case "helper": {
                return "\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a";
            }
            case "vip": 
            case "premium": 
            case "donator": {
                return "VIP";
            }
            case "builder": {
                return "\u0421\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c";
            }
            case "media": {
                return "\u041c\u0435\u0434\u0438\u0430";
            }
        }
        return "\u0418\u0433\u0440\u043e\u043a";
    }

    public Map<String, PlayerInfoObj> getPlayerData() {
        return this.playerData;
    }
}

