/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.handlers.NetworkHandler;
import ru.chibicraft.chibiiscute.packets.PacketScreenshotReply;

public class ServerPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, byte[]> transferBuffers = new HashMap<String, byte[]>();
    private static final Map<String, Integer> transferSizes = new HashMap<String, Integer>();
    private static final Map<String, String> transferRequesters = new HashMap<String, String>();

    public static void startReceiving(String transferId, int totalSize, String requesterName) {
        transferSizes.put(transferId, totalSize);
        transferBuffers.put(transferId, new byte[totalSize]);
        transferRequesters.put(transferId, requesterName);
    }

    public static void addChunk(String transferId, int chunkIndex, byte[] chunkData) {
        byte[] buffer = transferBuffers.get(transferId);
        if (buffer == null) {
            LOGGER.warn("\u0411\u0443\u0444\u0435\u0440 \u0434\u043b\u044f ID {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object)transferId);
            return;
        }
        int start = chunkIndex * 32000;
        System.arraycopy(chunkData, 0, buffer, start, chunkData.length);
    }

    public static void finishReceiving(String transferId, ServerPlayer sender) {
        byte[] imageData = transferBuffers.remove(transferId);
        Integer size = transferSizes.remove(transferId);
        String requesterName = transferRequesters.remove(transferId);
        if (imageData == null || size == null || requesterName == null) {
            LOGGER.warn("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f ID {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", (Object)transferId);
            return;
        }
        int receivedSize = imageData.length;
        if (receivedSize != size) {
            LOGGER.warn("\u0420\u0430\u0437\u043c\u0435\u0440 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ({}) \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u043c ({})", (Object)receivedSize, (Object)size);
            return;
        }
        try {
            String senderName;
            File playerDir;
            File baseDir = new File("screenshots");
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            }
            if (!(playerDir = new File(baseDir, senderName = sender.m_7755_().getString())).exists()) {
                playerDir.mkdirs();
            }
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            File outputFile = new File(playerDir, timestamp + ".jpeg");
            Files.write(outputFile.toPath(), imageData, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435: ", (Throwable)e);
        }
        ServerPlayer targetRequester = sender.f_8924_.m_6846_().m_11255_(requesterName);
        if (targetRequester != null) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> targetRequester), (Object)new PacketScreenshotReply(imageData, sender.m_7755_().getString()));
        } else {
            LOGGER.warn("Requester \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: {}", (Object)requesterName);
        }
    }
}

