/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.bukkit.FileLuckPermsHelper;
import ru.chibicraft.chibiiscute.handlers.ConfigHandler;
import ru.chibicraft.chibiiscute.handlers.NetworkHandler;
import ru.chibicraft.chibiiscute.packets.PacketSyncPlayerData;
import ru.chibicraft.chibiiscute.packets.PacketUpdateConfig;
import ru.chibicraft.chibiiscute.utils.PlayerInfoObj;

@Mod.EventBusSubscriber(modid="chibiiscute", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerDataHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastSyncTime = 0L;
    private static final long SYNC_INTERVAL = 10000L;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, r -> {
        Thread t = new Thread(r, "ChibiIsCute-SyncScheduler");
        t.setDaemon(true);
        return t;
    });

    public static void syncPlayerDataToClient(ServerPlayer player) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            Map<String, PlayerInfoObj> playerData = FileLuckPermsHelper.getPlayers();
            double tps5s = PacketSyncPlayerData.getTPS5s();
            LOGGER.debug("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u0443 {}: {} \u0438\u0433\u0440\u043e\u043a\u043e\u0432, TPS: {}", (Object)player.m_36316_().getName(), (Object)playerData.size(), (Object)String.format("%.2f", tps5s));
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketSyncPlayerData(playerData, tps5s));
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketUpdateConfig(ConfigHandler.tabHeader, ConfigHandler.avatarUrl, ConfigHandler.skinUrl, ConfigHandler.useGroupName, ConfigHandler.useColouredBg, ConfigHandler.useColorCodes, ConfigHandler.drawTPS, ConfigHandler.drawRoles, new ArrayList<String>((Collection)ConfigHandler.COMMON.roleColorsList.get())));
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430 {}: {}", (Object)player.m_36316_().getName(), (Object)e.getMessage(), (Object)e);
        }
    }

    public static void syncPlayerDataToAll() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                LOGGER.warn("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445");
                return;
            }
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ServerDataHandler.syncPlayerDataToClient(player);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043c\u0430\u0441\u0441\u043e\u0432\u043e\u0439 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String playerName = serverPlayer.m_36316_().getName();
            SCHEDULER.schedule(() -> {
                try {
                    MinecraftServer server = serverPlayer.m_20194_();
                    if (server != null && server.m_130010_()) {
                        server.execute(() -> {
                            try {
                                ConfigHandler.reloadConfig();
                                ServerDataHandler.syncPlayerDataToClient(serverPlayer);
                                ServerDataHandler.syncPlayerDataToAll();
                            }
                            catch (Exception e) {
                                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430 {}: {}", (Object)playerName, (Object)e.getMessage(), (Object)e);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0432\u0445\u043e\u0434\u0430 \u0438\u0433\u0440\u043e\u043a\u0430 {}: {}", (Object)playerName, (Object)e.getMessage(), (Object)e);
                }
            }, 2L, TimeUnit.SECONDS);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerDataHandler.syncPlayerDataToAll();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long currentTime;
        if (event.phase == TickEvent.Phase.END && (currentTime = System.currentTimeMillis()) - lastSyncTime > 10000L) {
            ConfigHandler.reloadConfig();
            ServerDataHandler.syncPlayerDataToAll();
            lastSyncTime = currentTime;
        }
    }

    public static void forceSync() {
        LOGGER.info("\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445");
        ServerDataHandler.syncPlayerDataToAll();
    }
}

