/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.gui.blur;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;

public class BlurRenderer {
    private static RenderTarget tempTarget;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            tempTarget = new TextureTarget(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_(), true, Minecraft.f_91002_);
            tempTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            initialized = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize blur renderer", e);
        }
    }

    public static void renderBlur(float progress) {
        if (!initialized) {
            BlurRenderer.init();
            if (!initialized) {
                return;
            }
        }
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget mainTarget = mc.m_91385_();
        if (BlurRenderer.tempTarget.f_83915_ != mainTarget.f_83915_ || BlurRenderer.tempTarget.f_83916_ != mainTarget.f_83916_) {
            tempTarget.m_83941_(mainTarget.f_83915_, mainTarget.f_83916_, Minecraft.f_91002_);
        }
        BlurRenderer.applySimpleBlur(progress);
    }

    private static void applySimpleBlur(float progress) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget mainTarget = mc.m_91385_();
        tempTarget.m_83945_(mainTarget);
        tempTarget.m_83947_(false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)progress);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)mainTarget.m_83975_());
        BlurRenderer.drawFullScreenQuad();
        mainTarget.m_83947_(false);
        RenderSystem.setShaderTexture((int)0, (int)tempTarget.m_83975_());
        BlurRenderer.drawFullScreenQuad();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void drawFullScreenQuad() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_(1.0, 0.0, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_(1.0, 1.0, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 1.0, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void cleanup() {
        if (tempTarget != null) {
            tempTarget.m_83930_();
            tempTarget = null;
        }
        initialized = false;
    }

    static {
        initialized = false;
    }
}

