/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.google.gson.JsonObject;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class TurtleToolSerialiser
implements TurtleUpgradeSerialiser<TurtleTool> {
    public static final TurtleToolSerialiser INSTANCE = new TurtleToolSerialiser();

    private TurtleToolSerialiser() {
    }

    @Override
    public TurtleTool fromJson(ResourceLocation id, JsonObject object) {
        String adjective = GsonHelper.m_13851_((JsonObject)object, (String)"adjective", (String)UpgradeBase.getDefaultAdjective(id));
        Item toolItem = GsonHelper.m_13909_((JsonObject)object, (String)"item");
        Item craftingItem = GsonHelper.m_144746_((JsonObject)object, (String)"craftingItem", (Item)toolItem);
        float damageMultiplier = GsonHelper.m_13820_((JsonObject)object, (String)"damageMultiplier", (float)3.0f);
        boolean allowEnchantments = GsonHelper.m_13855_((JsonObject)object, (String)"allowEnchantments", (boolean)false);
        TurtleToolDurability consumeDurability = (TurtleToolDurability)TurtleToolDurability.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)object, (String)"consumeDurability", null), (Enum)TurtleToolDurability.NEVER);
        TagKey breakable = null;
        if (object.has("breakable")) {
            ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"breakable"));
            breakable = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tag);
        }
        return new TurtleTool(id, adjective, craftingItem, new ItemStack((ItemLike)toolItem), damageMultiplier, allowEnchantments, consumeDurability, (TagKey<Block>)breakable);
    }

    @Override
    public TurtleTool fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String adjective = buffer.m_130277_();
        Item craftingItem = (Item)buffer.m_236816_(RegistryWrappers.ITEMS);
        Objects.requireNonNull(craftingItem, "Unknown crafting item");
        ItemStack toolItem = buffer.m_130267_();
        float damageMultiplier = buffer.readFloat();
        boolean allowsEnchantments = buffer.readBoolean();
        TurtleToolDurability consumesDurability = (TurtleToolDurability)buffer.m_130066_(TurtleToolDurability.class);
        TagKey breakable = (TagKey)buffer.m_236868_(b -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)b.m_130281_()));
        return new TurtleTool(id, adjective, craftingItem, toolItem, damageMultiplier, allowsEnchantments, consumesDurability, (TagKey<Block>)breakable);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, TurtleTool upgrade) {
        buffer.m_130070_(upgrade.getUnlocalisedAdjective());
        buffer.m_236818_(RegistryWrappers.ITEMS, (Object)upgrade.getCraftingItem().m_41720_());
        buffer.m_130055_(upgrade.item);
        buffer.writeFloat(upgrade.damageMulitiplier);
        buffer.writeBoolean(upgrade.allowEnchantments);
        buffer.m_130068_((Enum)upgrade.consumeDurability);
        buffer.m_236821_(upgrade.breakable, (b, x) -> b.m_130085_(x.f_203868_()));
    }
}

