/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TurtleMoveCommand
implements TurtleCommand {
    private final MoveDirection direction;

    public TurtleMoveCommand(MoveDirection direction) {
        this.direction = direction;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        Direction direction = this.direction.toWorldDir(turtle);
        ServerLevel level = (ServerLevel)turtle.getLevel();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.m_121945_(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, oldPosition, direction);
        TurtleCommandResult canEnterResult = TurtleMoveCommand.canEnter(turtlePlayer, level, newPosition);
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        BlockState existingState = level.m_8055_(newPosition);
        if (!WorldUtil.isEmptyBlock(existingState) && !existingState.m_247087_()) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        VoxelShape turtleShape = level.m_8055_(oldPosition).m_60812_((BlockGetter)level, oldPosition).m_83216_((double)newPosition.m_123341_(), (double)newPosition.m_123342_(), (double)newPosition.m_123343_());
        if (!level.m_5450_(null, turtleShape) && !this.canPushEntities((Level)level, turtleShape.m_83215_())) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (!turtle.teleportTo((Level)level, newPosition)) {
            return TurtleCommandResult.failure("Movement failed");
        }
        turtle.consumeFuel(1);
        switch (this.direction) {
            case FORWARD: {
                turtle.playAnimation(TurtleAnimation.MOVE_FORWARD);
                break;
            }
            case BACK: {
                turtle.playAnimation(TurtleAnimation.MOVE_BACK);
                break;
            }
            case UP: {
                turtle.playAnimation(TurtleAnimation.MOVE_UP);
                break;
            }
            case DOWN: {
                turtle.playAnimation(TurtleAnimation.MOVE_DOWN);
            }
        }
        return TurtleCommandResult.success();
    }

    private static TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, ServerLevel world, BlockPos position) {
        if (world.m_151570_(position)) {
            return TurtleCommandResult.failure(position.m_123342_() < 0 ? "Too low to move" : "Too high to move");
        }
        if (!world.m_46739_(position)) {
            return TurtleCommandResult.failure("Cannot leave the world");
        }
        if (turtlePlayer.isBlockProtected(world, position)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.m_46749_(position)) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        if (!world.m_6857_().m_61937_(position)) {
            return TurtleCommandResult.failure("Cannot pass the world border");
        }
        return TurtleCommandResult.success();
    }

    private boolean canPushEntities(Level level, AABB bounds) {
        if (!Config.turtlesCanPush) {
            return false;
        }
        return level.m_6249_((Entity)null, bounds, e -> e.m_6084_() && !e.m_5833_() && e.f_19850_ && e.m_7752_() == PushReaction.IGNORE).isEmpty();
    }
}

