/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.upgrades.TurtleInventoryCrafting;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class TurtleCraftCommand
implements TurtleCommand {
    private final int limit;

    public TurtleCraftCommand(int limit) {
        this.limit = limit;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        TurtleInventoryCrafting crafting = new TurtleInventoryCrafting(turtle);
        List<ItemStack> results = crafting.doCrafting(turtle.getLevel(), this.limit);
        if (results == null) {
            return TurtleCommandResult.failure("No matching recipes");
        }
        for (ItemStack stack : results) {
            TurtleUtil.storeItemOrDrop(turtle, stack);
        }
        if (!results.isEmpty()) {
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

