/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class KeyEventServerMessage
extends ComputerServerMessage {
    private final Action type;
    private final int key;

    public KeyEventServerMessage(AbstractContainerMenu menu, Action type, int key) {
        super(menu);
        this.type = type;
        this.key = key;
    }

    public KeyEventServerMessage(FriendlyByteBuf buf) {
        super(buf);
        this.type = (Action)buf.m_130066_(Action.class);
        this.key = buf.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130068_((Enum)this.type);
        buf.m_130130_(this.key);
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ServerInputHandler input = container.getInput();
        switch (this.type.ordinal()) {
            case 2: {
                input.keyUp(this.key);
                break;
            }
            case 0: {
                input.keyDown(this.key, false);
                break;
            }
            case 1: {
                input.keyDown(this.key, true);
                break;
            }
            case 3: {
                input.charTyped((byte)this.key);
            }
        }
    }

    @Override
    public MessageType<KeyEventServerMessage> type() {
        return NetworkMessages.KEY_EVENT;
    }

    public static enum Action {
        DOWN,
        REPEAT,
        UP,
        CHAR;

    }
}

