/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SpeakerPlayClientMessage
implements NetworkMessage<ClientNetworkContext> {
    private final UUID source;
    private final SpeakerPosition.Message pos;
    private final ResourceLocation sound;
    private final float volume;
    private final float pitch;

    public SpeakerPlayClientMessage(UUID source, SpeakerPosition pos, ResourceLocation sound, float volume, float pitch) {
        this.source = source;
        this.pos = pos.asMessage();
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SpeakerPlayClientMessage(FriendlyByteBuf buf) {
        this.source = buf.m_130259_();
        this.pos = SpeakerPosition.Message.read(buf);
        this.sound = buf.m_130281_();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.source);
        this.pos.write(buf);
        buf.m_130085_(this.sound);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleSpeakerPlay(this.source, this.pos, this.sound, this.volume, this.pitch);
    }

    @Override
    public MessageType<SpeakerPlayClientMessage> type() {
        return NetworkMessages.SPEAKER_PLAY;
    }
}

