/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.media.items.DiskItem;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class MountMedia
implements IMedia {
    public static final IMedia COMPUTER = new MountMedia("computer", s -> ((IComputerItem)s.m_41720_()).getComputerID((ItemStack)s), null, ConfigSpec.computerSpaceLimit);
    public static final IMedia DISK = new MountMedia("disk", DiskItem::getDiskID, DiskItem::setDiskID, ConfigSpec.floppySpaceLimit);
    private final String subPath;
    private final ToIntFunction<ItemStack> getId;
    private final @Nullable IdSetter setId;
    private final Supplier<Integer> defaultCapacity;

    public MountMedia(String subPath, ToIntFunction<ItemStack> getId, @Nullable IdSetter setId, Supplier<Integer> defaultCapacity) {
        this.subPath = subPath;
        this.getId = getId;
        this.setId = setId;
        this.defaultCapacity = defaultCapacity;
    }

    @Override
    public @Nullable String getLabel(ItemStack stack) {
        return stack.m_41788_() ? stack.m_41786_().getString() : null;
    }

    @Override
    public boolean setLabel(ItemStack stack, @Nullable String label) {
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Override
    public @Nullable Mount createDataMount(ItemStack stack, ServerLevel level) {
        int id = this.getId.applyAsInt(stack);
        if (id < 0) {
            if (this.setId == null) {
                return null;
            }
            id = ComputerCraftAPI.createUniqueNumberedSaveDir(level.m_7654_(), this.subPath);
            this.setId.set(stack, id);
        }
        return ComputerCraftAPI.createSaveDirMount(level.m_7654_(), this.subPath + "/" + id, this.defaultCapacity.get().intValue());
    }

    public static interface IdSetter {
        public void set(ItemStack var1, int var2);
    }
}

