/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStorageWorldData;
import appeng.spatial.TransitionInfo;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class SpatialStoragePlotManager {
    public static final SpatialStoragePlotManager INSTANCE = new SpatialStoragePlotManager();

    private SpatialStoragePlotManager() {
    }

    public ServerLevel getLevel() {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server == null) {
            throw new IllegalStateException("No server is currently running.");
        }
        ServerLevel level = server.m_129880_(SpatialStorageDimensionIds.WORLD_ID);
        if (level == null) {
            throw new IllegalStateException("The storage cell level is missing.");
        }
        return level;
    }

    private SpatialStorageWorldData getWorldData() {
        return (SpatialStorageWorldData)this.getLevel().m_7726_().m_8483_().m_164861_(SpatialStorageWorldData::load, SpatialStorageWorldData::new, "ae2_spatial_storage");
    }

    @Nullable
    public SpatialStoragePlot getPlot(int plotId) {
        if (plotId == -1) {
            return null;
        }
        return this.getWorldData().getPlotById(plotId);
    }

    public SpatialStoragePlot allocatePlot(BlockPos size, int ownerId) {
        SpatialStoragePlot plot = this.getWorldData().allocatePlot(size, ownerId);
        AELog.info("Allocating storage cell plot %d with size %s for %d", plot.getId(), size, ownerId);
        return plot;
    }

    public void setLastTransition(int plotId, TransitionInfo info) {
        this.getWorldData().setLastTransition(plotId, info);
    }

    public List<SpatialStoragePlot> getPlots() {
        return this.getWorldData().getPlots();
    }

    public void freePlot(int plotId, boolean resetBlocks) {
        SpatialStoragePlot plot = this.getPlot(plotId);
        if (plot == null) {
            return;
        }
        if (resetBlocks) {
            BlockPos from = plot.getOrigin();
            BlockPos to = from.m_121955_((Vec3i)plot.getSize()).m_7918_(-1, -1, -1);
            AELog.info("Clearing spatial storage plot %s (%s -> %s)", plotId, from, to);
            ServerLevel level = this.getLevel();
            BlockState matrixFrame = AEBlocks.MATRIX_FRAME.block().m_49966_();
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)from, (BlockPos)to)) {
                level.m_46597_(blockPos, matrixFrame);
            }
        }
        this.getWorldData().removePlot(plotId);
    }
}

