/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class TransformLogic {
    static Map<Fluid, Set<Item>> fluidCache = new IdentityHashMap<Fluid, Set<Item>>();
    static Set<Item> explosionCache = null;
    static Set<Item> anyFluidCache = null;

    public static boolean canTransformInFluid(ItemEntity entity, FluidState fluid) {
        return TransformLogic.getTransformableItems(entity.m_9236_(), fluid.m_76152_()).contains(entity.m_32055_().m_41720_());
    }

    public static boolean canTransformInAnyFluid(ItemEntity entity) {
        return TransformLogic.getTransformableItemsAnyFluid(entity.m_9236_()).contains(entity.m_32055_().m_41720_());
    }

    public static boolean canTransformInExplosion(ItemEntity entity) {
        return TransformLogic.getTransformableItemsExplosion(entity.m_9236_()).contains(entity.m_32055_().m_41720_());
    }

    public static boolean tryTransform(ItemEntity entity, Predicate<TransformCircumstance> circumstancePredicate) {
        Level level = entity.m_9236_();
        AABB region = new AABB(entity.m_20185_() - 1.0, entity.m_20186_() - 1.0, entity.m_20189_() - 1.0, entity.m_20185_() + 1.0, entity.m_20186_() + 1.0, entity.m_20189_() + 1.0);
        List<ItemEntity> itemEntities = level.m_45933_(null, region).stream().filter(e -> e instanceof ItemEntity && !e.m_213877_()).map(e -> (ItemEntity)e).toList();
        for (TransformRecipe recipe : level.m_7465_().m_44054_(TransformRecipe.TYPE).values()) {
            if (!circumstancePredicate.test(recipe.circumstance) || recipe.ingredients.size() == 0) continue;
            ArrayList missingIngredients = Lists.newArrayList(recipe.ingredients);
            ReferenceOpenHashSet selectedEntities = new ReferenceOpenHashSet(missingIngredients.size());
            if (recipe.circumstance.isExplosion() ? missingIngredients.stream().noneMatch(i -> i.test(entity.m_32055_())) : !((Ingredient)missingIngredients.get(0)).test(entity.m_32055_())) continue;
            block1: for (ItemEntity itemEntity : itemEntities) {
                ItemStack other = itemEntity.m_32055_();
                if (other.m_41619_()) continue;
                Iterator it = missingIngredients.iterator();
                while (it.hasNext()) {
                    Ingredient ing = (Ingredient)it.next();
                    if (!ing.test(other)) continue;
                    selectedEntities.add(itemEntity);
                    it.remove();
                    continue block1;
                }
            }
            if (!missingIngredients.isEmpty()) continue;
            SimpleContainer recipeContainer = new SimpleContainer(selectedEntities.size());
            int i2 = 0;
            for (ItemEntity e2 : selectedEntities) {
                recipeContainer.m_6836_(i2++, e2.m_32055_().m_41620_(1));
                if (e2.m_32055_().m_41613_() > 0) continue;
                e2.m_146870_();
            }
            RandomSource random = level.m_213780_();
            double x = Math.floor(entity.m_20185_()) + 0.25 + random.m_188500_() * 0.5;
            double y = Math.floor(entity.m_20186_()) + 0.25 + random.m_188500_() * 0.5;
            double z = Math.floor(entity.m_20189_()) + 0.25 + random.m_188500_() * 0.5;
            double xSpeed = random.m_188500_() * 0.25 - 0.125;
            double ySpeed = random.m_188500_() * 0.25 - 0.125;
            double zSpeed = random.m_188500_() * 0.25 - 0.125;
            ItemEntity newEntity = new ItemEntity(level, x, y, z, recipe.m_5874_((Container)recipeContainer, level.m_9598_()));
            newEntity.m_20334_(xSpeed, ySpeed, zSpeed);
            level.m_7967_((Entity)newEntity);
            return true;
        }
        return false;
    }

    private static void clearCache() {
        fluidCache.clear();
        explosionCache = null;
        anyFluidCache = null;
    }

    private static Set<Item> getTransformableItems(Level level, Fluid fluid) {
        return fluidCache.computeIfAbsent(fluid, f -> {
            Set ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.m_7465_().m_44013_(TransformRecipe.TYPE)) {
                Iterator iterator;
                if (!recipe.circumstance.isFluid(fluid) || !(iterator = recipe.ingredients.iterator()).hasNext()) continue;
                Ingredient ingredient = (Ingredient)iterator.next();
                for (ItemStack stack : ingredient.m_43908_()) {
                    ret.add(stack.m_41720_());
                }
            }
            return ret;
        });
    }

    private static Set<Item> getTransformableItemsAnyFluid(Level level) {
        Set<Object> ret = anyFluidCache;
        if (ret == null) {
            ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.m_7465_().m_44013_(TransformRecipe.TYPE)) {
                Iterator iterator;
                if (!recipe.circumstance.isFluid() || !(iterator = recipe.ingredients.iterator()).hasNext()) continue;
                Ingredient ingredient = (Ingredient)iterator.next();
                for (ItemStack stack : ingredient.m_43908_()) {
                    ret.add(stack.m_41720_());
                }
            }
            anyFluidCache = ret;
        }
        return ret;
    }

    private static Set<Item> getTransformableItemsExplosion(Level level) {
        Set<Object> ret = explosionCache;
        if (ret == null) {
            ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.m_7465_().m_44013_(TransformRecipe.TYPE)) {
                if (!recipe.circumstance.isExplosion()) continue;
                for (Ingredient ingredient : recipe.ingredients) {
                    for (ItemStack stack : ingredient.m_43908_()) {
                        ret.add(stack.m_41720_());
                    }
                }
            }
            explosionCache = ret;
        }
        return ret;
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent e) {
        TransformLogic.clearCache();
    }

    @SubscribeEvent
    public static void onReloadServerResources(AddReloadListenerEvent e) {
        TransformLogic.clearCache();
    }

    @SubscribeEvent
    public static void onClientRecipesUpdated(RecipesUpdatedEvent e) {
        TransformLogic.clearCache();
    }

    private TransformLogic() {
    }
}

