/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.AppEng;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CubeGeneratorBlockEntity
extends AEBaseBlockEntity
implements ServerTickingBlockEntity {
    private int size = 3;
    private ItemStack is = ItemStack.f_41583_;
    private int countdown = 200;
    private Player who = null;

    public CubeGeneratorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void serverTick() {
        if (!this.is.m_41619_()) {
            --this.countdown;
            if (this.countdown % 20 == 0) {
                AppEng.instance().getPlayers().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)("Spawning in... " + this.countdown / 20))));
            }
            if (this.countdown <= 0) {
                this.spawn();
            }
        }
    }

    private void spawn() {
        this.f_58857_.m_7471_(this.f_58858_, false);
        Item i = this.is.m_41720_();
        Direction side = Direction.UP;
        int half = (int)Math.floor(this.size / 2);
        for (int y = 0; y < this.size; ++y) {
            for (int x = -half; x < half; ++x) {
                for (int z = -half; z < half; ++z) {
                    BlockPos p = this.f_58858_.m_7918_(x, y - 1, z);
                    DirectionalPlaceContext useContext = new DirectionalPlaceContext(this.f_58857_, p, side, this.is, side.m_122424_());
                    i.m_6225_((UseOnContext)useContext);
                }
            }
        }
    }

    void click(Player player) {
        if (!this.isClientSide()) {
            ItemStack hand = player.m_150109_().m_36056_();
            this.who = player;
            if (hand.m_41619_()) {
                this.is = ItemStack.f_41583_;
                this.size = InteractionUtil.isInAlternateUseMode(player) ? --this.size : ++this.size;
                if (this.size < 3) {
                    this.size = 3;
                }
                if (this.size > 64) {
                    this.size = 64;
                }
                player.m_213846_((Component)Component.m_237113_((String)("Size: " + this.size)));
            } else {
                this.countdown = 200;
                this.is = hand;
            }
        }
    }
}

