/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEPatternHelper;
import appeng.crafting.pattern.ProcessingPatternEncoding;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AEProcessingPattern
implements IPatternDetails {
    public static final int MAX_INPUT_SLOTS = 81;
    public static final int MAX_OUTPUT_SLOTS = 27;
    private final AEItemKey definition;
    private final GenericStack[] sparseInputs;
    private final GenericStack[] sparseOutputs;
    private final Input[] inputs;
    private final GenericStack[] condensedOutputs;

    public AEProcessingPattern(AEItemKey definition) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.sparseInputs = ProcessingPatternEncoding.getProcessingInputs(tag);
        this.sparseOutputs = ProcessingPatternEncoding.getProcessingOutputs(tag);
        GenericStack[] condensedInputs = AEPatternHelper.condenseStacks(this.sparseInputs);
        this.inputs = new Input[condensedInputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new Input(condensedInputs[i]);
        }
        this.condensedOutputs = AEPatternHelper.condenseStacks(this.sparseOutputs);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AEProcessingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.condensedOutputs;
    }

    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    public GenericStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    @Override
    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink inputSink) {
        if (this.sparseInputs.length == this.inputs.length) {
            IPatternDetails.super.pushInputsToExternalInventory(inputHolder, inputSink);
            return;
        }
        KeyCounter allInputs = new KeyCounter();
        for (KeyCounter counter : inputHolder) {
            allInputs.addAll(counter);
        }
        for (GenericStack sparseInput : this.sparseInputs) {
            if (sparseInput == null) continue;
            AEKey key = sparseInput.what();
            long amount = sparseInput.amount();
            long available = allInputs.get(key);
            if (available < amount) {
                throw new RuntimeException("Expected at least %d of %s when pushing pattern, but only %d available".formatted(amount, key, available));
            }
            inputSink.pushInput(key, amount);
            allInputs.remove(key, amount);
        }
    }

    private static class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        private Input(GenericStack stack) {
            this.template = new GenericStack[]{new GenericStack(stack.what(), 1L)};
            this.multiplier = stack.amount();
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        @Override
        public long getMultiplier() {
            return this.multiplier;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

