/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2insertexportcard.item;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.util.ConfigInventory;
import appeng.util.ConfigManager;
import com.ultramega.ae2insertexportcard.registry.ModItems;
import com.ultramega.ae2insertexportcard.util.UpgradeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeHost
implements IConfigurableObject {
    public static final String NBT_SELECTED_INVENTORY_SLOTS = "SelectedInventorySlots";
    public final ConfigInventory filterConfig = ConfigInventory.configTypes((int)18, this::updateFilter);
    private IConfigManager configManager;
    private IUpgradeInventory upgrades;
    private final UpgradeType type;
    private final ItemStack itemStack;
    private final WirelessTerminalMenuHost host;

    public UpgradeHost(UpgradeType type, int id, Inventory inventory, WirelessTerminalMenuHost host) {
        this.type = type;
        this.itemStack = host.getItemStack();
        this.host = host;
        for (int i = 0; i < host.getUpgrades().size(); ++i) {
            FuzzyMode fzMode;
            ItemStack upgrade = host.getUpgrades().getStackInSlot(i);
            if (upgrade.m_41720_() != (type == UpgradeType.INSERT ? (Item)ModItems.INSERT_CARD.get() : (Item)ModItems.EXPORT_CARD.get())) continue;
            this.configManager = new ConfigManager((manager, settingName) -> manager.writeToNBT(upgrade.m_41784_()));
            this.upgrades = UpgradeInventories.forItem((ItemStack)upgrade, (int)(type == UpgradeType.EXPORT ? 3 : 2), null);
            String fz = upgrade.m_41784_().m_128461_("fuzzy_mode");
            try {
                fzMode = FuzzyMode.valueOf((String)fz);
            }
            catch (Throwable t) {
                fzMode = FuzzyMode.IGNORE_ALL;
            }
            this.configManager.registerSetting(Settings.FUZZY_MODE, (Enum)fzMode);
        }
        if (this.upgrades == null) {
            this.upgrades = UpgradeInventories.empty();
        }
        ListTag tagList = this.itemStack.m_41783_().m_128437_("upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            if (!this.isInsertOrExportCard(type, tagList, i)) continue;
            CompoundTag tag = (CompoundTag)tagList.m_128728_(i).m_128423_("tag");
            if (tag == null) {
                tag = new CompoundTag();
            }
            this.filterConfig.readFromChildTag(tag, "filterConfig");
            tagList.m_128728_(i).m_128365_("tag", (Tag)tag);
        }
    }

    private void updateFilter() {
        ListTag tagList = this.itemStack.m_41783_().m_128437_("upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            if (!this.isInsertOrExportCard(this.type, tagList, i)) continue;
            CompoundTag tag = (CompoundTag)tagList.m_128728_(i).m_128423_("tag");
            if (tag == null) {
                tag = new CompoundTag();
            }
            this.filterConfig.writeToChildTag(tag, "filterConfig");
            tagList.m_128728_(i).m_128365_("tag", (Tag)tag);
        }
    }

    public void setSelectedInventorySlots(int[] selectedInventorySlots) {
        ListTag tagList = this.itemStack.m_41783_().m_128437_("upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            if (!this.isInsertOrExportCard(this.type, tagList, i)) continue;
            CompoundTag tag = (CompoundTag)tagList.m_128728_(i).m_128423_("tag");
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.m_128385_(NBT_SELECTED_INVENTORY_SLOTS, selectedInventorySlots);
            tagList.m_128728_(i).m_128365_("tag", (Tag)tag);
        }
    }

    public int[] getSelectedInventorySlots() {
        ListTag tagList = this.itemStack.m_41783_().m_128437_("upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag;
            if (!this.isInsertOrExportCard(this.type, tagList, i) || (tag = (CompoundTag)tagList.m_128728_(i).m_128423_("tag")) == null || !tag.m_128441_(NBT_SELECTED_INVENTORY_SLOTS)) continue;
            return tag.m_128465_(NBT_SELECTED_INVENTORY_SLOTS);
        }
        return new int[36];
    }

    public boolean isInsertOrExportCard(UpgradeType type, ListTag tagList, int index) {
        String tagId = tagList.m_128728_(index).m_128461_("id");
        return tagId.equals(new ResourceLocation("ae2insertexportcard", type.getName() + "_card").toString());
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }
}

