/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.event.listeners;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.PipelineProvider;
import org.enginehub.worldeditcui.render.RenderSink;
import org.enginehub.worldeditcui.util.Vector3;

public class CUIListenerWorldRender {
    private final WorldEditCUI controller;
    private final Minecraft minecraft;
    private final CUIRenderContext ctx = new CUIRenderContext();
    private final List<PipelineProvider> pipelines;
    private int currentPipelineIdx;
    private RenderSink sink;

    public CUIListenerWorldRender(WorldEditCUI controller, Minecraft minecraft, List<PipelineProvider> pipelines) {
        this.controller = controller;
        this.minecraft = minecraft;
        this.pipelines = List.copyOf(pipelines);
    }

    private RenderSink providePipeline() {
        if (this.sink != null) {
            return this.sink;
        }
        for (int i = this.currentPipelineIdx; i < this.pipelines.size(); ++i) {
            PipelineProvider pipeline = this.pipelines.get(i);
            if (!pipeline.available()) continue;
            try {
                RenderSink sink = pipeline.provide();
                this.currentPipelineIdx = i;
                this.sink = sink;
                return this.sink;
            }
            catch (Exception ex) {
                this.controller.getDebugger().info("Failed to render with pipeline " + pipeline.id() + ", which declared itself as available... trying next");
            }
        }
        throw new IllegalStateException("No pipeline available to render with!");
    }

    private void invalidatePipeline() {
        if (this.currentPipelineIdx < this.pipelines.size() - 1) {
            ++this.currentPipelineIdx;
            this.sink = null;
        }
    }

    public void onRender(float partialTicks) {
        try {
            RenderSink sink = this.providePipeline();
            if (!this.pipelines.get(this.currentPipelineIdx).shouldRender()) {
                return;
            }
            Minecraft.m_91087_().m_91307_().m_6180_("worldeditcui");
            this.ctx.init(new Vector3(this.minecraft.f_91063_.m_109153_().m_90583_()), partialTicks, sink);
            float fogStart = RenderSystem.getShaderFogStart();
            FogRenderer.m_109017_();
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.m_85836_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.lineWidth((float)3.0f);
            ShaderInstance oldShader = RenderSystem.getShader();
            try {
                this.controller.renderSelections(this.ctx);
                this.sink.flush();
            }
            catch (Exception e) {
                this.controller.getDebugger().error("Error while attempting to render WorldEdit CUI", e);
                this.invalidatePipeline();
            }
            RenderSystem.depthFunc((int)515);
            RenderSystem.setShader(() -> oldShader);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            poseStack.m_85849_();
            RenderSystem.setShaderFogStart((float)fogStart);
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
        catch (Exception ex) {
            this.controller.getDebugger().error("Failed while preparing state for WorldEdit CUI", ex);
            this.invalidatePipeline();
        }
    }
}

