/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.common.block.BECreativePictureFrame;
import team.creative.littleframes.common.block.BlockCreativePictureFrame;

@OnlyIn(value=Dist.CLIENT)
public class CreativePictureFrameRenderer
implements BlockEntityRenderer<BECreativePictureFrame> {
    public boolean shouldRenderOffScreen(BECreativePictureFrame frame) {
        return frame.getSizeX() > 16.0f || frame.getSizeY() > 16.0f;
    }

    public boolean shouldRender(BECreativePictureFrame frame, Vec3 vec) {
        return Vec3.m_82512_((Vec3i)frame.m_58899_()).m_82509_((Position)vec, (double)frame.data.renderDistance);
    }

    public void render(BECreativePictureFrame frame, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (frame.isURLEmpty() || frame.data.alpha == 0.0f) {
            if (frame.display != null) {
                frame.display.release();
            }
            return;
        }
        FrameDisplay display = frame.requestDisplay();
        if (display == null) {
            return;
        }
        display.prepare(frame.data, frame.playing);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)frame.data.brightness, (float)frame.data.brightness, (float)frame.data.brightness, (float)frame.data.alpha);
        int texture = display.texture();
        if (texture == -1) {
            return;
        }
        RenderSystem.bindTexture((int)texture);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        Facing facing = Facing.get((Direction)((Direction)frame.m_58900_().m_61143_((Property)BlockCreativePictureFrame.FACING)));
        AlignedBox box = frame.getBox();
        box.grow(facing.axis, 0.01f);
        BoxFace face = BoxFace.get((Facing)facing);
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_252781_(facing.rotation().m_252961_((float)Math.toRadians(-frame.rotation)));
        pose.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f mat = pose.m_85850_().m_252922_();
        for (BoxCorner corner : face.corners) {
            builder.m_252986_(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacing(face.getTexU()) != frame.flipX ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) != frame.flipY ? 1.0f : 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        }
        tesselator.m_85914_();
        if (frame.bothSides) {
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            for (int i = face.corners.length - 1; i >= 0; --i) {
                BoxCorner corner = face.corners[i];
                builder.m_252986_(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacing(face.getTexU()) != frame.flipX ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) != frame.flipY ? 1.0f : 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            }
            tesselator.m_85914_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85849_();
    }
}

