/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein.noise;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

class Center {
    double x;
    double y;

    public Center(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static ArrayList<Center> generateCenters(int maxCenters, double minDist, int width, int height) {
        Random rnd = new Random();
        double cell = minDist;
        int gridW = (int)Math.ceil((double)width / cell) + 1;
        int gridH = (int)Math.ceil((double)height / cell) + 1;
        LinkedList<Center> centers = new LinkedList<Center>();
        LinkedList[][] grid = new LinkedList[gridW][gridH];
        for (int i = 0; i < gridW; ++i) {
            for (int j = 0; j < gridH; ++j) {
                grid[i][j] = new LinkedList();
            }
        }
        double minDistSq = minDist * minDist;
        for (int attempts = 0; centers.size() < maxCenters && attempts < maxCenters * 20; ++attempts) {
            double cx = rnd.nextDouble() * (double)width;
            double cy = rnd.nextDouble() * (double)height;
            int gx = (int)(cx / cell);
            int gy = (int)(cy / cell);
            boolean ok = true;
            for (int ix = gx - 1; ix <= gx + 1; ++ix) {
                for (int iy = gy - 1; iy <= gy + 1; ++iy) {
                    if (ix < 0 || iy < 0 || ix >= gridW || iy >= gridH) continue;
                    for (Center c : grid[ix][iy]) {
                        double dx = cx - c.x;
                        double dy = cy - c.y;
                        if (!(dx * dx + dy * dy < minDistSq)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) break;
                }
                if (!ok) break;
            }
            if (!ok) continue;
            Center nc = new Center(cx, cy);
            centers.add(nc);
            grid[gx][gy].add(nc);
        }
        return new ArrayList<Center>(centers);
    }
}

