/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.IUCore;
import com.denfop.network.packet.PacketKeys;
import com.denfop.utils.KeyboardIU;
import java.util.EnumSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;

@OnlyIn(value=Dist.CLIENT)
public class KeyboardClient
extends KeyboardIU {
    public static final KeyMapping changemode = new KeyMapping("Change mode key", 71, "IndustrialUpgrade");
    public static final KeyMapping flymode = new KeyMapping("Fly Key", 70, "IndustrialUpgrade");
    public static final KeyMapping blacklistviewmode = new KeyMapping("BlackList View Key", 88, "IndustrialUpgrade");
    public static final KeyMapping verticalmode = new KeyMapping("Vertical Key", 75, "IndustrialUpgrade");
    public static final KeyMapping savemode = new KeyMapping("Save move Key", 76, "IndustrialUpgrade");
    public static final KeyMapping blackmode = new KeyMapping("BlackList Key", 74, "IndustrialUpgrade");
    public static final KeyMapping streakmode = new KeyMapping("Streak Key", 86, "IndustrialUpgrade");
    public static final KeyMapping armormode = new KeyMapping("Armor Key", 77, "IndustrialUpgrade");
    public static final KeyMapping bootsmode = new KeyMapping("Boots Key", 66, "IndustrialUpgrade");
    public static final KeyMapping leggingsmode = new KeyMapping("Leggings Key", 78, "IndustrialUpgrade");
    public static final KeyMapping altmode = new KeyMapping("ALT Key", 342, "IndustrialUpgrade");
    private final Minecraft mc = Minecraft.m_91087_();
    private int lastKeyState = 0;

    public KeyboardClient() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void register(RegisterKeyMappingsEvent ClientRegistry) {
        ClientRegistry.register(changemode);
        ClientRegistry.register(flymode);
        ClientRegistry.register(blacklistviewmode);
        ClientRegistry.register(verticalmode);
        ClientRegistry.register(savemode);
        ClientRegistry.register(blackmode);
        ClientRegistry.register(streakmode);
        ClientRegistry.register(armormode);
        ClientRegistry.register(bootsmode);
        ClientRegistry.register(leggingsmode);
        ClientRegistry.register(altmode);
    }

    @Override
    public void sendKeyUpdate() {
        int currentKeyState;
        EnumSet<KeyboardIU.Key> keys = EnumSet.noneOf(KeyboardIU.Key.class);
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen == null) {
            if (KeyboardClient.keyDown(changemode)) {
                keys.add(KeyboardIU.Key.CHANGE);
            }
            if (KeyboardClient.keyDown(flymode)) {
                keys.add(KeyboardIU.Key.FLYMODE);
            }
            if (KeyboardClient.keyDown(altmode)) {
                keys.add(KeyboardIU.Key.ALT);
            }
            if (KeyboardClient.keyDown(armormode)) {
                keys.add(KeyboardIU.Key.ARMOR);
            }
            if (KeyboardClient.keyDown(this.mc.f_91066_.f_92091_)) {
                keys.add(KeyboardIU.Key.FORWARD);
            }
            if (KeyboardClient.keyDown(this.mc.f_91066_.f_92089_)) {
                keys.add(KeyboardIU.Key.JUMP);
            }
            if (KeyboardClient.keyDown(verticalmode)) {
                keys.add(KeyboardIU.Key.VERTICALMODE);
            }
            if (KeyboardClient.keyDown(blacklistviewmode)) {
                keys.add(KeyboardIU.Key.BLACKLISTVIEWMODE);
            }
            if (KeyboardClient.keyDown(savemode)) {
                keys.add(KeyboardIU.Key.SAVEMODE);
            }
            if (KeyboardClient.keyDown(blackmode)) {
                keys.add(KeyboardIU.Key.BLACKMODE);
            }
            if (KeyboardClient.keyDown(streakmode)) {
                keys.add(KeyboardIU.Key.STREAK);
            }
            if (KeyboardClient.keyDown(bootsmode)) {
                keys.add(KeyboardIU.Key.BOOTS);
            }
            if (KeyboardClient.keyDown(leggingsmode)) {
                keys.add(KeyboardIU.Key.LEGGINGS);
            }
        }
        if ((currentKeyState = KeyboardIU.Key.toInt(keys)) != this.lastKeyState) {
            new PacketKeys(currentKeyState);
            super.processKeyUpdate(IUCore.proxy.getPlayerInstance(), currentKeyState);
            this.lastKeyState = currentKeyState;
        }
    }
}

