/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.space.BaseSpaceSystem;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumRing;
import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.IStar;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.MiniAsteroid;
import com.denfop.api.space.Planet;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.rovers.enums.EnumRoversLevel;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.SpaceMainBlueInterfaceWidget;
import com.denfop.api.widget.SpaceMainGreenInterfaceWidget;
import com.denfop.api.widget.SpaceMainInterfaceWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.mechanism.BlockEntityResearchTableSpace;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuResearchTableSpace;
import com.denfop.network.packet.PacketAddBuildingToColony;
import com.denfop.network.packet.PacketUpdateBody;
import com.denfop.screen.FuelAllocation;
import com.denfop.screen.Result;
import com.denfop.screen.ScreenColony;
import com.denfop.screen.ScreenDefaultResearchTable;
import com.denfop.screen.ScreenExpeditionTableSpace;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMain;
import com.denfop.screen.ScreenResourceBody;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class ScreenResearchTableSpace<T extends ContainerMenuResearchTableSpace>
extends ScreenMain<ContainerMenuResearchTableSpace> {
    public final List<float[]> cachedStars = new ArrayList<float[]>();
    private final float ANIMATION_DURATION = 900.0f;
    public int mode = 0;
    public IStar star;
    public IBody focusedPlanet = null;
    public boolean starsGenerated1 = false;
    public boolean hoverColonies = false;
    public boolean hoverResource = false;
    public boolean hoverExpedition = false;
    public int textIndex = 0;
    public boolean starsGenerated = false;
    public float scale = 1.0f;
    public int offsetX = 0;
    public int offsetY = 0;
    public boolean isDragging = false;
    public int lastMouseX;
    public int lastMouseY;
    public Result minimumLimit;
    public List<ScreenDefaultResearchTable> defaultResearchGuis = new ArrayList<ScreenDefaultResearchTable>();
    boolean hoverUp = false;
    boolean hoverOpen = false;
    boolean hoverDown = false;
    int systemId = 0;
    List<ISystem> systems;
    double scaleWindow = -1.0;
    boolean hoverBack = false;
    int valuePage = 0;
    int maxValuePage = 9;
    boolean hoverNextStar = false;
    boolean hoverBackStar = false;
    Map<Integer, Integer> rocketPlanetRequirements = Map.of(1, 1, 2, 1, 3, 3, 4, 5);
    Map<Integer, Integer> fuelPlanetRequirements = Map.of(1, 1, 2, 1, 3, 5, 4, 6);
    private int addPoint;
    private int valueBody = 0;
    private float scaleBackStar = 1.0f;
    private float scaleNextStar = 1.0f;
    private boolean growingBack = true;
    private boolean growingNext = true;
    private float animationProgress = 1.0f;
    private boolean animating = false;
    private boolean animatingForward = true;
    private long animationStartTime;

    public ScreenResearchTableSpace(ContainerMenuResearchTableSpace guiContainer) {
        super(guiContainer, EnumTypeStyle.PERFECT);
        this.f_97727_ = 255;
        this.f_97726_ = 255;
        this.componentList.clear();
    }

    public static void enableScissor(int p_239261_, int p_239262_, int p_239263_, int p_239264_) {
        Window window = Minecraft.m_91087_().m_91268_();
        int i = window.m_85442_();
        double d0 = window.m_85449_();
        double d1 = (double)p_239261_ * d0;
        double d2 = (double)i - (double)p_239264_ * d0;
        double d3 = (double)(p_239263_ - p_239261_) * d0;
        double d4 = (double)(p_239264_ - p_239262_) * d0;
        RenderSystem.enableScissor((int)((int)d1), (int)((int)d2), (int)Math.max(0, (int)d3), (int)Math.max(0, (int)d4));
    }

    @Override
    public void m_88315_(GuiGraphics p_97795_, int p_97796_, int p_97797_, float p_97798_) {
        this.f_97727_ = 255;
        this.f_97726_ = 255;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        super.m_88315_(p_97795_, p_97796_, p_97797_, p_97798_);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
    }

    private void renderRings(GuiGraphics poseStack, IPlanet planet) {
        if (planet.getRing() == null) {
            return;
        }
        boolean isSaturn = planet.getRing() == EnumRing.HORIZONTAL;
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
        double angle = Math.PI * 2 * (time * planet.getOrbitPeriod()) / 400.0;
        float planetX = (float)(planet.getDistance() * Math.cos(angle));
        float planetY = (float)(planet.getDistance() * Math.sin(angle));
        double size = planet.getSize() * 2.0;
        pose.m_85837_(1.8, -0.2125, 0.0);
        pose.m_252880_(planetX, planetY, 0.0f);
        if (!isSaturn) {
            pose.m_252781_(Axis.f_252403_.m_252977_(270.0f));
        }
        pose.m_85841_((float)(0.00390625 * size), (float)(0.00390625 * size / 32.0), 1.0f);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        ScreenResearchTableSpace.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/common2.png"));
        this.drawTexturedModalRect(poseStack, -128, -128, 0, 0, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85849_();
    }

    public void renderStars(GuiGraphics poseStack, int x, int y, int width, int height, int starCount) {
        if (!this.starsGenerated) {
            this.generateStars(poseStack.m_280168_(), x, y, width, height, starCount);
            this.starsGenerated = true;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.m_280168_().m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        for (float[] star : this.cachedStars) {
            buffer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85814_);
            buffer.m_252986_(matrix, star[0], star[1], 0.0f).m_5752_();
            buffer.m_252986_(matrix, star[0] * 1.001f, star[1] * 1.001f, 0.0f).m_5752_();
            tessellator.m_85914_();
        }
        RenderSystem.disableBlend();
    }

    private void generateStars(PoseStack poseStack, int x, int y, int width, int height, int starCount) {
        Random random = new Random();
        this.cachedStars.clear();
        for (int i = 0; i < starCount; ++i) {
            float starX = (float)x + random.nextFloat() * (float)width;
            float starY = (float)y + random.nextFloat() * (float)height;
            this.cachedStars.add(new float[]{starX, starY});
        }
    }

    private void drawLine(PoseStack poseStack, BufferBuilder buffer, double x1, double y1, double x2, double y2) {
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)x1, (float)y1, 0.0f).m_6122_(0, 255, 1, 255).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)x2, (float)y2, 0.0f).m_6122_(0, 255, 1, 255).m_5752_();
    }

    @Override
    protected void drawBackground(GuiGraphics poseStack) {
        this.componentList.forEach(guiComponent -> guiComponent.drawBackground(poseStack, this.guiLeft(), this.guiTop()));
    }

    @Override
    public void changeParams() {
        super.changeParams();
        this.f_97727_ = 4000;
        this.f_97726_ = 9000;
    }

    private void drawScaledTexture(GuiGraphics graphics, float x, float y, int u, int v, int w, int h, float scale) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x + (float)w / 2.0f, y + (float)h / 2.0f, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_((float)(-w) / 2.0f, (float)(-h) / 2.0f, 0.0f);
        this.drawTexturedModalRect(graphics, 0, 0, u, v, w, h);
        poseStack.m_85849_();
    }

    @Override
    public boolean needRenderForeground() {
        return false;
    }

    public void drawRect(GuiGraphics poseStack, ResourceLocation texture, float x, float y, float z, float scaleX, float scaleY, int u, int v, int w, int h) {
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        RenderSystem.enableBlend();
        ScreenResearchTableSpace.bindTexture(texture);
        pose.m_252880_(x, y, z);
        pose.m_85841_(scaleX, scaleY, 1.0f);
        this.drawTexturedModalRect(poseStack, 0, 0, u, v, w, h);
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    public void drawCenteredText(GuiGraphics poseStack, String text, float x, float y, float z, float scale, int color) {
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x - (float)this.getStringWidth(text) / 2.0f * scale, y, z);
        pose.m_85841_(scale, scale, 1.0f);
        poseStack.m_280056_(this.f_96547_, text, 0, 0, color, false);
        pose.m_85849_();
    }

    public void drawAvailability(GuiGraphics poseStack, boolean available, String label, float x, float y, float z) {
        this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), x, y, z, 0.7f, 0.7f, 0, available ? 125 : 145, 103, 20);
        this.drawCenteredText(poseStack, available ? Localization.translate("iu.space.planet.available") + " " + label : Localization.translate("iu.space.planet.unavailable") + " " + label, x + 35.7f, y + 5.0f, z + 5.0f, 0.6f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
    }

    public void drawLevelIcon(GuiGraphics poseStack, int level, float x, float y, float z, float scale) {
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        RenderSystem.enableBlend();
        pose.m_252880_(x, y, z);
        pose.m_85841_(scale, scale, 1.0f);
        switch (level) {
            case 1: {
                this.drawTexturedModalRect(poseStack, 0, 0, 90, 0, 7, 12);
                break;
            }
            case 2: {
                this.drawTexturedModalRect(poseStack, 0, 0, 98, 0, 14, 12);
                break;
            }
            case 3: {
                this.drawTexturedModalRect(poseStack, 0, 0, 113, 0, 18, 12);
                break;
            }
            case 4: {
                this.drawTexturedModalRect(poseStack, 0, 0, 131, 0, 19, 12);
                break;
            }
            case 5: {
                this.drawTexturedModalRect(poseStack, 0, 0, 149, 0, 12, 12);
                break;
            }
            case 6: {
                this.drawTexturedModalRect(poseStack, 0, 0, 162, 0, 18, 12);
            }
        }
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        int i;
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        PoseStack pose = poseStack.m_280168_();
        this.addPoint = 0;
        this.valueBody = 0;
        for (i = 0; i < 9; ++i) {
            this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 6 + 18 + i * 18, this.guiTop + 231, 0.0f, 1.0f, 1.0f, 222, 1, 20, 20);
        }
        for (i = 10; i < 11; ++i) {
            RenderSystem.enableBlend();
            this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 6 + 18 + i * 18, this.guiTop + 231, 0.0f, 1.0f, 1.0f, 201, 1, 20, 20);
            RenderSystem.disableBlend();
        }
        if (this.mode == 0) {
            this.renderMainMenu(poseStack, pose, partialTicks, mouseX, mouseY);
        } else if (this.mode == 1) {
            this.renderStarSystem(poseStack, pose, partialTicks, mouseX, mouseY);
        } else if (this.mode == 2) {
            boolean isScissor;
            boolean bl = isScissor = !this.defaultResearchGuis.isEmpty();
            if (!isScissor) {
                ISatellite s;
                IPlanet p;
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 9, this.guiTop + 28, 20.0f, 0.5f, 0.5f, !this.hoverBack ? 139 : 170, 1, 30, 30);
                RenderSystem.enableBlend();
                new SpaceMainBlueInterfaceWidget(this, 25, 25, 200, 200).drawBackground(poseStack, this.guiLeft, this.guiTop);
                RenderSystem.disableBlend();
                this.drawRect(poseStack, this.focusedPlanet.getLocation(), this.guiLeft + 47, this.guiTop + 35, 20.0f, 0.125f, 0.125f, 0, 0, 256, 256);
                RenderSystem.enableBlend();
                new SpaceMainGreenInterfaceWidget(this, 45, 33, 37, 36).drawBackground(poseStack, this.guiLeft, this.guiTop);
                RenderSystem.disableBlend();
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 30, this.guiTop + 70, 0.0f, 0.63f, 0.63f, 0, 105, 103, 20);
                this.drawCenteredText(poseStack, Localization.translate("iu.body." + this.focusedPlanet.getName()), (float)(this.guiLeft + 30) + 32.13f, this.guiTop + 70 + 3, 20.0f, 0.63f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 30, this.guiTop + 70 + 17, 20.0f, 0.5f, 0.5f, 0, 182, 127, 49);
                Data data = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).dataMap.get(this.focusedPlanet);
                int percent = (int)(data.getPercent() * 122.0 / 100.0);
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 33, this.guiTop + 70 + 17, 20.0f, 0.5f, 0.5f, 5, 165, percent, 17);
                if (data.getPercent() >= 0.0) {
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 30, (float)(this.guiTop + 70 + 26) - 0.5f, 20.0f, 0.5f, 0.5f, 142, 63, 26, 46);
                }
                if (data.getPercent() >= 20.0) {
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 45, (float)(this.guiTop + 70) + 25.5f, 20.0f, 0.5f, 0.5f, 169, 63, 21, 46);
                }
                if (data.getPercent() >= 50.0) {
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), (float)this.guiLeft + 57.5f, this.guiTop + 70 + 26, 20.0f, 0.5f, 0.5f, 190, 64, 26, 42);
                }
                if (data.getPercent() >= 80.0) {
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), (float)this.guiLeft + 71.5f, (float)(this.guiTop + 70) + 25.5f, 20.0f, 0.5f, 0.5f, 216, 63, 20, 42);
                }
                if (data.getPercent() >= 100.0) {
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 83, (float)(this.guiTop + 70) + 25.5f, 20.0f, 0.5f, 0.5f, 236, 63, 20, 42);
                }
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 30, this.guiTop + 115, 0.0f, 0.63f, 0.63f, 0, 105, 103, 20);
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 30, this.guiTop + 135, 0.0f, 0.63f, 0.63f, 0, 105, 103, 20);
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"), this.guiLeft + 30, this.guiTop + 155, 0.0f, 0.63f, 0.63f, 0, data.getPercent() >= 100.0 ? 105 : 145, 103, 20);
                this.drawCenteredText(poseStack, Localization.translate("iu.space.planet.resource"), (float)(this.guiLeft + 30) + 32.13f, this.guiTop + 115 + 3, 20.0f, 0.63f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
                this.drawCenteredText(poseStack, Localization.translate("iu.space.planet.expedition"), (float)(this.guiLeft + 30) + 32.13f, this.guiTop + 135 + 3, 20.0f, 0.63f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
                this.drawCenteredText(poseStack, Localization.translate("iu.space.planet.colony"), (float)(this.guiLeft + 30) + 32.13f, this.guiTop + 155 + 3, 20.0f, 0.63f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
                RenderSystem.enableBlend();
                new SpaceMainBlueInterfaceWidget(this, 30, 170, 66, 40).drawBackground(poseStack, this.guiLeft, this.guiTop);
                RenderSystem.disableBlend();
                ScreenResearchTableSpace.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"));
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 35, this.guiTop + 175, 0.0f, 0.63f, 0.63f, 0, 0, 21, 21);
                Result result = this.minimumLimit;
                this.drawLevelIcon(poseStack, result.allocations.fuelLevel, this.guiLeft + 43, this.guiTop + 182, 0.0f, 0.63f);
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 58, this.guiTop + 175, 0.0f, 0.63f, 0.63f, 168, 21, 24, 23);
                this.drawLevelIcon(poseStack, result.allocations.rocketLevel, this.guiLeft + 66, this.guiTop + 182, 0.0f, 0.63f);
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 80, this.guiTop + 175, 0.0f, 0.63f, 0.63f, 22, 23, 13, 20);
                this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 78, this.guiTop + 192, 0.0f, 0.63f, 0.63f, 192, 22, 21, 21);
                int temperature = this.focusedPlanet.getTemperature();
                if (temperature > 150) {
                    count = (int)Math.ceil((double)(temperature - 150) / 350.0);
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 35, this.guiTop + 192, 0.0f, 0.63f, 0.63f, 44, 0, 21, 21);
                    this.drawLevelIcon(poseStack, count, this.guiLeft + 45, this.guiTop + 200, 0.0f, 0.63f);
                } else if (temperature < -125) {
                    count = (int)Math.ceil((double)(Math.abs(temperature) - 125) / 37.0);
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 35, this.guiTop + 192, 0.0f, 0.63f, 0.63f, 22, 0, 21, 21);
                    this.drawLevelIcon(poseStack, count, this.guiLeft + 45, this.guiTop + 200, 0.0f, 0.63f);
                }
                IBody iBody = this.focusedPlanet;
                if (iBody instanceof IPlanet && (p = (IPlanet)iBody).getPressure() || (iBody = this.focusedPlanet) instanceof ISatellite && (s = (ISatellite)iBody).getPressure()) {
                    this.drawRect(poseStack, new ResourceLocation("industrialupgrade", "textures/gui/gui_space_icons.png"), this.guiLeft + 58, this.guiTop + 192, 0.0f, 0.63f, 0.63f, 66, 0, 21, 21);
                }
                RenderSystem.enableBlend();
                new SpaceMainBlueInterfaceWidget(this, 110, 33, 100, 100).drawBackground(poseStack, this.guiLeft, this.guiTop);
                RenderSystem.disableBlend();
                String text = this.getInformationFromBody(this.focusedPlanet, data.getPercent());
                this.drawTextInCanvas(poseStack, text, 115, 40, 100, 100, 0.5f);
                this.drawAvailability(poseStack, true, Localization.translate("iu.rover").toLowerCase(), this.guiLeft + 123, this.guiTop + 142, 0.0f);
                this.drawAvailability(poseStack, data.getPercent() >= 20.0, Localization.translate("iu.probe").toLowerCase(), this.guiLeft + 123, this.guiTop + 162, 0.0f);
                this.drawAvailability(poseStack, data.getPercent() >= 50.0, Localization.translate("iu.satellite").toLowerCase(), this.guiLeft + 123, this.guiTop + 182, 0.0f);
                this.drawAvailability(poseStack, data.getPercent() >= 80.0, Localization.translate("iu.rocket").toLowerCase(), this.guiLeft + 123, this.guiTop + 202, 0.0f);
            }
            pose.m_85836_();
            RenderSystem.defaultBlendFunc();
            for (int i2 = 0; i2 < this.defaultResearchGuis.size(); ++i2) {
                ScreenDefaultResearchTable defaultResearchTable = this.defaultResearchGuis.get(i2);
                pose.m_252880_(0.0f, 0.0f, 200.0f);
                defaultResearchTable.drawGuiContainerBackgroundLayer(poseStack, partialTicks, this.guiLeft, this.guiTop);
            }
            pose.m_85849_();
        }
    }

    @Override
    public void drawTextInCanvas(GuiGraphics graphics, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale) {
        int maxWidth = (int)((float)canvasWidth / scale);
        int x = canvasX;
        int y = canvasY;
        PoseStack poseStack = graphics.m_280168_();
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)(this.guiLeft + x), (float)(this.guiTop + y), 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280056_(this.f_96547_, line, 0, 0, 0xFFFFFF, false);
            poseStack.m_85849_();
            y += 11;
        }
    }

    private void renderStarSystem(GuiGraphics poseStack, PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)0.2f, (float)1.0f, (float)1.0f);
        ScreenResearchTableSpace.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/common2.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 30, this.guiTop + 30, 2, 2, 175, 175);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85836_();
        pose.m_252880_((float)(this.guiLeft + 9), (float)(this.guiTop + 28), 20.0f);
        ScreenResearchTableSpace.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png"));
        pose.m_85841_(0.5f, 0.5f, 1.0f);
        if (!this.hoverBack) {
            this.drawTexturedModalRect(poseStack, 0, 0, 139, 1, 30, 30);
        } else {
            this.drawTexturedModalRect(poseStack, 0, 0, 170, 1, 30, 30);
        }
        pose.m_85849_();
        ScreenResearchTableSpace.enableScissor(this.guiLeft + 30, this.guiTop + 30, this.guiLeft + 30 + 175, this.guiTop + 30 + 175);
        ScreenResearchTableSpace.bindTexture(this.star.getLocation());
        if (this.scaleWindow != Minecraft.m_91087_().m_91268_().m_85449_()) {
            this.starsGenerated = false;
            this.scaleWindow = Minecraft.m_91087_().m_91268_().m_85449_();
        }
        this.renderStars(poseStack, this.guiLeft + 30, this.guiTop + 30, 175, 175, 800);
        pose.m_85836_();
        float planetX = 0.0f;
        float planetY = 0.0f;
        if (this.focusedPlanet != null) {
            this.offsetX = 0;
            this.offsetY = 0;
            if (this.focusedPlanet instanceof IPlanet) {
                time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                angle = Math.PI * 2 * (time * this.focusedPlanet.getOrbitPeriod()) / 400.0;
                planetX = (float)(this.focusedPlanet.getDistance() * Math.cos(angle)) * this.scale * 16.0f;
                planetY = (float)(this.focusedPlanet.getDistance() * Math.sin(angle)) * this.scale * 16.0f;
            } else if (this.focusedPlanet instanceof ISatellite) {
                ISatellite satellite1 = (ISatellite)this.focusedPlanet;
                double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                double angle = Math.PI * 2 * (time * satellite1.getPlanet().getOrbitPeriod()) / 400.0;
                double angle1 = Math.PI * 2 * (time * satellite1.getOrbitPeriod()) / 400.0;
                planetX = (float)((double)((float)(satellite1.getPlanet().getDistance() * Math.cos(angle))) + satellite1.getDistance() * 0.8 * Math.cos(angle1)) * this.scale * 16.0f;
                planetY = (float)((double)((float)(satellite1.getPlanet().getDistance() * Math.sin(angle))) + satellite1.getDistance() * 0.8 * Math.sin(angle1)) * this.scale * 16.0f;
            } else if (this.focusedPlanet instanceof IAsteroid) {
                time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                angle = Math.PI * 2 * (time * this.focusedPlanet.getOrbitPeriod()) / 400.0;
                planetX = (float)(this.focusedPlanet.getDistance() * Math.cos(angle)) * this.scale * 16.0f;
                planetY = (float)(this.focusedPlanet.getDistance() * Math.sin(angle)) * this.scale * 16.0f;
            }
            double centerX = (double)(this.guiLeft + 7) + 81.0;
            double centerY = (double)(this.guiTop + 80) + 41.0;
            double planetSize = this.focusedPlanet.getSize() * 2.0 * (double)this.scale * 16.0;
            if ((double)this.scale > 2.0 / (this.focusedPlanet.getSize() * (double)this.scale)) {
                pose.m_85849_();
            }
            pose.m_85836_();
            pose.m_85837_(centerX - (double)planetX + (double)this.offsetX, centerY - (double)planetY + (double)this.offsetY - 3.5 * (double)this.scale, 0.0);
            int squareSize = (int)(planetSize * 1.2);
            pose.m_252880_(planetX, planetY, 0.0f);
            pose.m_85841_(this.scale, this.scale, this.scale);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            this.drawLine(pose, buffer, -squareSize / 2, -squareSize / 2, (double)(-squareSize) / 4.0, -squareSize / 2);
            this.drawLine(pose, buffer, squareSize / 2, -squareSize / 2, (double)squareSize / 4.0, -squareSize / 2);
            this.drawLine(pose, buffer, squareSize / 2, -squareSize / 2, squareSize / 2, -squareSize / 4);
            this.drawLine(pose, buffer, squareSize / 2, squareSize / 2, squareSize / 2, squareSize / 4);
            this.drawLine(pose, buffer, -squareSize / 2, squareSize / 2, (double)(-squareSize) / 4.0, squareSize / 2);
            this.drawLine(pose, buffer, squareSize / 2, squareSize / 2, (double)squareSize / 4.0, squareSize / 2);
            this.drawLine(pose, buffer, -squareSize / 2, -squareSize / 2, -squareSize / 2, -squareSize / 4);
            this.drawLine(pose, buffer, -squareSize / 2, squareSize / 2, -squareSize / 2, squareSize / 4);
            tessellator.m_85914_();
            pose.m_85849_();
            pose.m_85837_((double)(this.guiLeft + 7) + 81.0 + (double)this.offsetX - (double)planetX - 28.75 * (double)this.scale, (double)(this.guiTop + 80) + 41.0 + (double)this.offsetY - (double)planetY, 0.0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.lineWidth((float)2.0f);
        } else {
            pose.m_85837_((double)(this.guiLeft + 7) + 81.0 + (double)this.offsetX - (double)planetX, (double)(this.guiTop + 80) + 41.0 + (double)this.offsetY - (double)planetY, 0.0);
        }
        pose.m_85841_(this.scale * 16.0f, this.scale * 16.0f, 1.0f);
        ScreenResearchTableSpace.bindTexture(this.star.getLocation());
        double size = this.star.getSize();
        pose.m_85836_();
        pose.m_85837_(1.8, -0.2125, 0.0);
        pose.m_85841_((float)(0.001953125 * size), (float)(0.001953125 * size), 1.0f);
        this.drawTexturedModalRect(poseStack, -128, -128, 0, 0, 256, 256);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(1.8, -0.2125, 0.0);
        for (IPlanet planet : this.star.getPlanetList()) {
            if (planet == SpaceInit.ceres) continue;
            this.renderOrbit(pose, planet.getDistance(), planet.getPressure(), planet.hasOxygen());
        }
        pose.m_85849_();
        for (IPlanet planet : this.star.getPlanetList()) {
            this.renderPlanet(poseStack, planet);
            this.renderRings(poseStack, planet);
            planet.getSatelliteList().forEach(satellite -> this.renderSatellite(poseStack, planet, (IBody)satellite));
        }
        this.star.getAsteroidList().forEach(iAsteroid -> iAsteroid.getMiniAsteroid().forEach(asteroid -> this.renderAsteroid(poseStack, (MiniAsteroid)asteroid, (IAsteroid)iAsteroid)));
        pose.m_85849_();
        RenderSystem.disableScissor();
        new SpaceMainInterfaceWidget(this, 28, 28, 179, 179).drawBackground(poseStack, this.guiLeft, this.guiTop);
        List<IPlanet> list = new ArrayList<IPlanet>(this.star.getPlanetList());
        list.addAll(this.star.getAsteroidList());
        list = list.stream().sorted(Comparator.comparingDouble(IBody::getDistance)).collect(Collectors.toList());
        this.maxValuePage = list.size();
        int tempMaxValuePage = Math.min(9, this.maxValuePage - this.valuePage);
        int j = 0;
        ResourceLocation back1 = new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png");
        ScreenResearchTableSpace.bindTexture(back1);
        float scaleSpeed = 0.02f;
        float maxScale = 1.2f;
        float minScale = 1.0f;
        if (this.hoverUp) {
            if (this.growingBack) {
                this.scaleBackStar += scaleSpeed;
                if (this.scaleBackStar >= maxScale) {
                    this.scaleBackStar = maxScale;
                    this.growingBack = false;
                }
            } else {
                this.scaleBackStar -= scaleSpeed;
                if (this.scaleBackStar <= minScale) {
                    this.scaleBackStar = minScale;
                    this.growingBack = true;
                }
            }
        } else {
            this.scaleBackStar = 1.0f;
        }
        if (this.hoverDown) {
            if (this.growingNext) {
                this.scaleNextStar += scaleSpeed;
                if (this.scaleNextStar >= maxScale) {
                    this.scaleNextStar = maxScale;
                    this.growingNext = false;
                }
            } else {
                this.scaleNextStar -= scaleSpeed;
                if (this.scaleNextStar <= minScale) {
                    this.scaleNextStar = minScale;
                    this.growingNext = true;
                }
            }
        } else {
            this.scaleNextStar = 1.0f;
        }
        if (this.valuePage > 0) {
            pose.m_85836_();
            pose.m_252880_((float)(this.guiLeft + 229), (float)(this.guiTop + 30), 20.0f);
            pose.m_85841_(this.scaleBackStar * 0.5f, this.scaleBackStar * 0.5f, 1.0f);
            if (!this.hoverUp) {
                this.drawTexturedModalRect(poseStack, 0, 0, 74, 0, 32, 18);
            } else {
                this.drawTexturedModalRect(poseStack, 0, 0, 107, 0, 32, 18);
            }
            pose.m_85849_();
        }
        if (this.focusedPlanet != null) {
            EnumLevels level1 = EnumLevels.NONE;
            if (this.focusedPlanet instanceof IPlanet) {
                level1 = ((IPlanet)this.focusedPlanet).getLevels();
            }
            if (this.focusedPlanet instanceof ISatellite) {
                level1 = ((ISatellite)this.focusedPlanet).getLevels();
            }
            if (this.focusedPlanet instanceof IAsteroid) {
                level1 = ((IAsteroid)this.focusedPlanet).getLevels();
            }
            pose.m_85836_();
            RenderSystem.enableBlend();
            pose.m_252880_((float)(this.guiLeft + 63 + 10), (float)(this.guiTop + 3), 20.0f);
            pose.m_85841_(0.75f, 0.75f, 1.0f);
            if (((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != null && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != EnumLevels.NONE && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level.ordinal() >= level1.ordinal()) {
                this.drawTexturedModalRect(poseStack, 0, 0, 0, 37, 103, 34);
            } else {
                this.drawTexturedModalRect(poseStack, 0, 0, 0, 71, 103, 34);
            }
            RenderSystem.disableBlend();
            pose.m_85849_();
            pose.m_85836_();
            String name = Localization.translate("iu.body." + this.focusedPlanet.getName());
            pose.m_85837_((double)(this.guiLeft + 63 + 10) + 38.25 - (double)(this.getStringWidth(name) / 2) * 0.75, (double)(this.guiTop + 7), 20.0);
            pose.m_85841_(0.75f, 0.75f, 1.0f);
            poseStack.m_280056_(this.f_96547_, name, 0, 0, ModUtils.convertRGBAcolorToInt(255, 255, 255), false);
            pose.m_85849_();
            pose.m_85836_();
            name = level1.name();
            pose.m_85837_((double)(this.guiLeft + 63 + 10) + 38.25 - (double)(this.getStringWidth(name) / 2) * 0.75, (double)(this.guiTop + 19), 20.0);
            pose.m_85841_(0.75f, 0.75f, 1.0f);
            poseStack.m_280056_(this.f_96547_, name, 0, 0, ModUtils.convertRGBAcolorToInt(255, 255, 255), false);
            pose.m_85849_();
        }
        int addedPoint = 0;
        for (int i = this.valuePage; i < tempMaxValuePage + this.valuePage; ++i) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            ScreenResearchTableSpace.bindTexture(back1);
            pose.m_85836_();
            IBody body = list.get(i);
            int dop = 0;
            if (this.focusedPlanet == body) {
                dop = 15;
            }
            if (this.focusedPlanet instanceof ISatellite && ((ISatellite)this.focusedPlanet).getPlanet() == body) {
                dop = 15;
            }
            if (dop != 0) {
                this.valueBody = i;
            }
            pose.m_85837_((double)(this.guiLeft + 207 + dop), (double)(this.guiTop + 28 + 12) + (double)(j * 19) * 0.65 + (double)addedPoint, 20.0);
            pose.m_85841_(0.65f, 0.65f, 1.0f);
            EnumLevels level = EnumLevels.NONE;
            if (body instanceof IPlanet) {
                level = ((IPlanet)body).getLevels();
            }
            if (body instanceof ISatellite) {
                level = ((ISatellite)body).getLevels();
            }
            if (body instanceof IAsteroid) {
                level = ((IAsteroid)body).getLevels();
            }
            if (this.focusedPlanet != body) {
                if (((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != null && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level.ordinal() >= level.ordinal() && level != EnumLevels.NONE && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != EnumLevels.NONE) {
                    this.drawTexturedModalRect(poseStack, 0, 0, 152, 160, 103, 19);
                } else {
                    this.drawTexturedModalRect(poseStack, 0, 0, 152, 180, 103, 19);
                }
            } else {
                this.drawTexturedModalRect(poseStack, 0, 0, 152, 200, 103, 19);
            }
            pose.m_85841_(1.5384616f, 1.5384616f, 1.0f);
            ScreenResearchTableSpace.bindTexture(body.getLocation());
            pose.m_85837_(4.0, 2.5, 20.0);
            pose.m_85841_(0.03125f, 0.03125f, 1.0f);
            this.drawTexturedModalRect(poseStack, 0, 0, 0, 0, 256, 256);
            pose.m_85849_();
            RenderSystem.disableBlend();
            pose.m_85836_();
            pose.m_85837_((double)(this.guiLeft + 207 + 7 + dop + 8), (double)(this.guiTop + 28 + 16) + (double)(j * 19) * 0.65 + (double)addedPoint, 20.0);
            pose.m_85841_(0.65f, 0.65f, 1.0f);
            String name = Localization.translate("iu.body." + ((IBody)list.get(i)).getName());
            poseStack.m_280056_(this.f_96547_, name, 0, 0, ModUtils.convertRGBAcolorToInt(255, 255, 255), false);
            pose.m_85849_();
            ++j;
            if (dop == 0) continue;
            int size1 = 0;
            List<Object> satelliteList = Collections.emptyList();
            if (this.focusedPlanet instanceof Planet) {
                satelliteList = ((Planet)this.focusedPlanet).getSatelliteList();
            }
            if (this.focusedPlanet instanceof ISatellite && ((ISatellite)this.focusedPlanet).getPlanet() == body) {
                satelliteList = ((ISatellite)this.focusedPlanet).getPlanet().getSatelliteList();
            }
            size1 = satelliteList.size();
            for (int ii = 0; ii < size1; ++ii) {
                ScreenResearchTableSpace.bindTexture(back1);
                ISatellite satellite1 = (ISatellite)satelliteList.get(ii);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                pose.m_85836_();
                pose.m_85837_((double)(this.guiLeft + 207 + dop * 2), (double)(this.guiTop + 28 + 12) + (double)(j * 19) * 0.65 + (double)addedPoint + (double)(ii * 19) * 0.65, 20.0);
                pose.m_85841_(0.65f, 0.65f, 1.0f);
                level = EnumLevels.NONE;
                level = satellite1.getLevels();
                if (this.focusedPlanet != satellite1) {
                    if (((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != null && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level.ordinal() >= level.ordinal() && level != EnumLevels.NONE && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != EnumLevels.NONE) {
                        this.drawTexturedModalRect(poseStack, 0, 0, 152, 161, 103, 19);
                    } else {
                        this.drawTexturedModalRect(poseStack, 0, 0, 152, 180, 103, 19);
                    }
                } else {
                    this.drawTexturedModalRect(poseStack, 0, 0, 152, 200, 103, 19);
                }
                pose.m_85841_(1.5384616f, 1.5384616f, 1.0f);
                ScreenResearchTableSpace.bindTexture(satellite1.getLocation());
                pose.m_85837_(4.0, 1.75, 20.0);
                pose.m_85841_(0.03125f, 0.03125f, 1.0f);
                this.drawTexturedModalRect(poseStack, 0, 0, 0, 0, 256, 256);
                pose.m_85849_();
                pose.m_85836_();
                pose.m_85837_((double)(this.guiLeft + 207 + 7 + dop * 2 + 8), (double)(this.guiTop + 28 + 16) + (double)(j * 19) * 0.65 + (double)addedPoint + (double)(ii * 19) * 0.65, 20.0);
                pose.m_85841_(0.65f, 0.65f, 1.0f);
                name = Localization.translate("iu.body." + satellite1.getName());
                poseStack.m_280056_(this.f_96547_, name, 0, 0, ModUtils.convertRGBAcolorToInt(255, 255, 255), false);
                pose.m_85849_();
            }
            addedPoint = (int)((double)addedPoint + (double)(size1 * 19) * 0.65);
        }
        this.addPoint = addedPoint;
        ScreenResearchTableSpace.bindTexture(back1);
        if (tempMaxValuePage > 0 && this.maxValuePage - this.valuePage > 9) {
            pose.m_85836_();
            pose.m_252880_((float)(this.guiLeft + 230), (float)(this.guiTop + (tempMaxValuePage - 1) * 19 + addedPoint), 20.0f);
            pose.m_85841_(this.scaleNextStar * 0.5f, this.scaleNextStar * 0.5f, 1.0f);
            if (!this.hoverDown) {
                this.drawTexturedModalRect(poseStack, 0, 0, 74, 18, 32, 18);
            } else {
                this.drawTexturedModalRect(poseStack, 0, 0, 107, 18, 32, 18);
            }
            pose.m_85849_();
        }
        if (this.focusedPlanet != null) {
            EnumLevels level = EnumLevels.NONE;
            if (this.focusedPlanet instanceof IPlanet) {
                level = ((IPlanet)this.focusedPlanet).getLevels();
            }
            if (this.focusedPlanet instanceof ISatellite) {
                level = ((ISatellite)this.focusedPlanet).getLevels();
            }
            if (this.focusedPlanet instanceof IAsteroid) {
                level = ((IAsteroid)this.focusedPlanet).getLevels();
            }
            if (((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != null && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level.ordinal() >= level.ordinal() && level != EnumLevels.NONE && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != EnumLevels.NONE) {
                RenderSystem.enableBlend();
                ScreenResearchTableSpace.bindTexture(back1);
                this.drawTexturedModalRect(poseStack, this.guiLeft + 30 + 87 - 51, this.guiTop + 210, 0, 105, 102, 20);
                RenderSystem.disableBlend();
            }
        }
    }

    private void startAnimation(boolean forward) {
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.animatingForward = forward;
        this.animationStartTime = System.currentTimeMillis();
        this.animationProgress = 0.0f;
    }

    private void renderMainMenu(GuiGraphics poseStack, PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        float y;
        float x;
        List<ISystem> systems1 = SpaceNet.instance.getSystem();
        this.systems = systems1.stream().filter(iSystem -> !iSystem.getStarList().isEmpty()).collect(Collectors.toList());
        new SpaceMainInterfaceWidget(this, this.f_97726_ / 2 - 80 + 30, 60, 90, 90).drawBackground(poseStack, this.guiLeft, this.guiTop);
        ScreenIndustrialUpgrade.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/gui_space_main.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85836_();
        int width1 = 90;
        int height1 = 90;
        float centerX = this.guiLeft + this.f_97726_ / 2 - 80 + 94 + 30;
        float centerY = this.guiTop + 30 + 30;
        pose.m_252880_(centerX, centerY, 30.0f);
        pose.m_252781_(Axis.f_252403_.m_252977_(0.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        this.drawTexturedModalRect(poseStack, -2, 0, 0, 0, width1 - 3, height1 + 2);
        this.drawTexturedModalRect(poseStack, width1 - 6, 0, 251, 0, 5, height1 + 2);
        this.drawTexturedModalRect(poseStack, -2, height1 + 2, 0, 250, width1 - 1, 6);
        this.drawTexturedModalRect(poseStack, width1 - 7, height1 + 2, 250, 250, 6, 5);
        pose.m_85849_();
        ScreenIndustrialUpgrade.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/gui_space_main.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85836_();
        width1 = 90;
        height1 = 90;
        centerX = this.guiLeft + this.f_97726_ / 2 - 80 - 94 + 27 + 30;
        centerY = this.guiTop + 30 - 25 + 30;
        pose.m_252880_(centerX, centerY, 80.0f);
        pose.m_252781_(Axis.f_252403_.m_252977_(0.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        this.drawTexturedModalRect(poseStack, -2, 0, 0, 0, width1 - 3, height1 + 2);
        this.drawTexturedModalRect(poseStack, width1 - 6, 0, 251, 0, 5, height1 + 2);
        this.drawTexturedModalRect(poseStack, -2, height1 + 2, 0, 250, width1 - 1, 6);
        this.drawTexturedModalRect(poseStack, width1 - 7, height1 + 2, 250, 250, 6, 5);
        pose.m_85849_();
        this.bindTexture();
        if (this.animating) {
            long elapsed = System.currentTimeMillis() - this.animationStartTime;
            this.animationProgress = Math.min((float)elapsed / 900.0f, 1.0f);
            if (this.animationProgress >= 1.0f) {
                this.animating = false;
            }
        }
        float offset = 50.0f * (1.0f - this.animationProgress);
        if (!this.animatingForward) {
            offset *= -1.0f;
        }
        int nextIndex = (this.systemId + 1) % this.systems.size();
        int prevIndex = this.systemId - 1;
        if (prevIndex < 0) {
            prevIndex = this.systems.size() - 1;
        }
        IStar centerStar = this.systems.get(this.systemId).getStarList().get(0);
        IStar nextStar = this.systems.get(nextIndex).getStarList().get(0);
        IStar prevStar = this.systems.get(prevIndex).getStarList().get(0);
        ScreenResearchTableSpace.enableScissor(this.guiLeft + this.f_97726_ / 2 - 80 + 4 + 30, this.guiTop + 30 + 4 + 30, this.guiLeft + this.f_97726_ / 2 - 80 + 90 - 4 + 30, this.guiTop + 30 + 90 - 4 + 30);
        centerX = this.guiLeft + this.f_97726_ / 2 - 80 + 94 + 30;
        centerY = this.guiTop + 30 + 30;
        this.renderPlanet1(poseStack.m_280168_(), 52.0f, centerStar.getLocation(), (float)this.guiLeft + (float)(this.f_97726_ / 2) - 35.0f + offset + 30.0f, (float)this.guiTop + 75.0f + 30.0f, 0.0f, (float)centerStar.getRotation(((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_()), centerStar.getRotationAngle(), 0.0f);
        RenderSystem.disableScissor();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 40.0f);
        ScreenResearchTableSpace.enableScissor(this.guiLeft + this.f_97726_ / 2 - 80 + 94 + 1 + 30, this.guiTop + 10 + 4 + 30, this.guiLeft + this.f_97726_ / 2 - 80 + 94 + 60 + 1 + 30, this.guiTop + 30 + 70 + 30);
        this.renderPlanet1(poseStack.m_280168_(), 34.0f, nextStar.getLocation(), centerX + 30.0f + offset, centerY + 32.0f, 0.0f, -45.0f, -10.0f, -10.0f);
        RenderSystem.disableScissor();
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 40.0f);
        centerX = this.guiLeft + this.f_97726_ / 2 - 80 - 94 + 27 + 30;
        centerY = this.guiTop + 30 - 25 + 30;
        ScreenResearchTableSpace.enableScissor((int)(centerX + 1.0f), this.guiTop + 10 + 4 + 30, (int)(centerX + 60.0f), this.guiTop + 30 + 70 + 30);
        this.renderPlanet1(poseStack.m_280168_(), 34.0f, prevStar.getLocation(), centerX + 30.0f + offset, centerY + 32.0f + 25.0f, 0.0f, -45.0f, 10.0f, -10.0f);
        RenderSystem.disableScissor();
        pose.m_85849_();
        ResourceLocation background1 = new ResourceLocation("industrialupgrade", "textures/gui/gui_space_other.png");
        ScreenResearchTableSpace.bindTexture(background1);
        float scaleSpeed = 0.02f;
        float maxScale = 1.2f;
        float minScale = 1.0f;
        if (this.hoverBackStar) {
            if (this.growingBack) {
                this.scaleBackStar += scaleSpeed;
                if (this.scaleBackStar >= maxScale) {
                    this.scaleBackStar = maxScale;
                    this.growingBack = false;
                }
            } else {
                this.scaleBackStar -= scaleSpeed;
                if (this.scaleBackStar <= minScale) {
                    this.scaleBackStar = minScale;
                    this.growingBack = true;
                }
            }
        } else {
            this.scaleBackStar = 1.0f;
        }
        if (this.hoverNextStar) {
            if (this.growingNext) {
                this.scaleNextStar += scaleSpeed;
                if (this.scaleNextStar >= maxScale) {
                    this.scaleNextStar = maxScale;
                    this.growingNext = false;
                }
            } else {
                this.scaleNextStar -= scaleSpeed;
                if (this.scaleNextStar <= minScale) {
                    this.scaleNextStar = minScale;
                    this.growingNext = true;
                }
            }
        } else {
            this.scaleNextStar = 1.0f;
        }
        if (this.hoverBackStar) {
            x = this.guiLeft + this.f_97726_ / 2 - 110 + 30;
            y = this.guiTop + 75 - 20 + 75 + 30;
            this.drawScaledTexture(poseStack, x, y, 37, 0, 17, 32, this.scaleBackStar);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + this.f_97726_ / 2 - 110 + 30, this.guiTop + 75 - 20 + 75 + 30, 0, 0, 17, 32);
        }
        if (this.hoverNextStar) {
            x = this.guiLeft + this.f_97726_ / 2 + 20 + 30;
            y = this.guiTop + 75 - 20 + 75 + 30;
            this.drawScaledTexture(poseStack, x, y, 56, 0, 17, 32, this.scaleNextStar);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + this.f_97726_ / 2 + 20 + 30, this.guiTop + 75 - 20 + 75 + 30, 19, 0, 17, 32);
        }
    }

    private void renderAsteroid(GuiGraphics poseStack, MiniAsteroid miniAsteroid, IAsteroid asteroid) {
        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
        double angle = Math.PI * 2 * (time * (double)miniAsteroid.getRotationSpeed()) / 800.0;
        float planetX = (float)((double)miniAsteroid.getX() * Math.cos(angle));
        float planetY = (float)((double)miniAsteroid.getX() * Math.sin(angle));
        double size = miniAsteroid.getSize() * 2.0f;
        ScreenResearchTableSpace.bindTexture(asteroid.getLocation());
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85837_(1.8, -0.2125, 0.0);
        pose.m_252880_(planetX, planetY, 0.0f);
        pose.m_85841_((float)(0.001953125 * size), (float)(0.001953125 * size), 1.0f);
        this.drawTexturedModalRect(poseStack, -128, -128, 0, 0, 256, 256);
        pose.m_85849_();
    }

    private void renderOrbit(PoseStack poseStack, double radius, boolean hasPressure, boolean hasOxygen) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        int segments = (int)(32.0 * Math.max(1.0, radius / 2.0));
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments);
            float x = (float)(radius * Math.cos(angle));
            float y = (float)(radius * Math.sin(angle));
            if (hasPressure) {
                buffer.m_252986_(matrix, x, y, 0.0f).m_6122_(255, 0, 0, 255).m_5752_();
                continue;
            }
            if (hasOxygen) {
                buffer.m_252986_(matrix, x, y, 0.0f).m_6122_(0, 255, 0, 255).m_5752_();
                continue;
            }
            buffer.m_252986_(matrix, x, y, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        mouseX -= (double)this.f_97735_;
        mouseY -= (double)this.f_97736_;
        if (this.mode == 1 && mouseX >= 30.0 && mouseY >= 30.0 && mouseX <= 205.0 && mouseY <= 205.0) {
            if (button == 0) {
                int dx = (int)dragX;
                int dy = (int)dragY;
                this.offsetX += dx;
                this.offsetY += dy;
                this.isDragging = true;
            } else {
                this.isDragging = false;
            }
        } else if (this.mode == 2) {
            for (int ii = 0; ii < this.defaultResearchGuis.size(); ++ii) {
                ScreenDefaultResearchTable defaultResearchTable = this.defaultResearchGuis.get(ii);
                if (!defaultResearchTable.mouseDragged(mouseX, mouseY, dragX, dragY)) continue;
                return true;
            }
        }
        return this.isDragging;
    }

    @Override
    public boolean m_6050_(double d, double d2, double d3) {
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (this.mode == 1 && mouseX >= 30 && mouseY >= 30 && mouseX <= 205 && mouseY <= 205) {
            ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
            int dWheel = (int)(d3 * 10.0);
            if (dWheel != 0) {
                this.scale += dWheel > 0 ? 0.1f : -0.1f;
                this.scale = Mth.m_14036_((float)this.scale, (float)0.2f, (float)10.0f);
            }
            if (scrollDirection == ScrollDirection.stopped) {
                if (!this.isDragging) {
                    this.isDragging = true;
                } else {
                    int dx = (int)(d - (double)this.lastMouseX);
                    int dy = (int)(d2 - (double)this.lastMouseY);
                    this.offsetX += dx / 8;
                    this.offsetY -= dy / 8;
                }
                this.lastMouseX = (int)d;
                this.lastMouseY = (int)d2;
            } else {
                this.isDragging = false;
            }
            return true;
        }
        if (this.mode == 1 && mouseX >= 207 && mouseX <= 267 && mouseY >= 40 && (double)mouseY <= 151.15) {
            ScrollDirection scrollDirection;
            ScrollDirection scrollDirection2 = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : (scrollDirection = ScrollDirection.stopped);
            if (scrollDirection != ScrollDirection.stopped) {
                int prevValue = this.valuePage;
                this.valuePage += scrollDirection == ScrollDirection.down ? 1 : -1;
                if (this.valuePage < 0) {
                    this.valuePage = 0;
                }
                if (this.maxValuePage - this.valuePage < 9) {
                    this.valuePage = this.maxValuePage - 9;
                }
                if (prevValue != this.valuePage) {
                    ((ContainerMenuResearchTableSpace)this.container).player.m_5496_(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
                }
                return true;
            }
        } else if (this.mode == 2) {
            for (int ii = 0; ii < this.defaultResearchGuis.size(); ++ii) {
                ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
                ScreenDefaultResearchTable defaultResearchTable = this.defaultResearchGuis.get(ii);
                if (!defaultResearchTable.mouseScrolled(mouseX, mouseY, scrollDirection)) continue;
                return true;
            }
        }
        return super.m_6050_(d, d2, d3);
    }

    private void renderPlanet(GuiGraphics poseStack, IBody planet) {
        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
        double angle = Math.PI * 2 * (time * planet.getOrbitPeriod()) / 400.0;
        float planetX = (float)(planet.getDistance() * Math.cos(angle));
        float planetY = (float)(planet.getDistance() * Math.sin(angle));
        double size = planet.getSize() * 2.0;
        ScreenResearchTableSpace.bindTexture(planet.getLocation());
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85837_(1.8, -0.2125, 0.0);
        pose.m_252880_(planetX, planetY, 0.0f);
        pose.m_85841_((float)(0.001953125 * size), (float)(0.001953125 * size), 1.0f);
        this.drawTexturedModalRect(poseStack, -128, -128, 0, 0, 256, 256);
        pose.m_85849_();
    }

    private void renderSatellite(GuiGraphics poseStack, IBody planet, IBody satellite) {
        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
        double angle = Math.PI * 2 * (time * planet.getOrbitPeriod()) / 400.0;
        double angle1 = Math.PI * 2 * (time * satellite.getOrbitPeriod()) / 400.0;
        float planetX = (float)((double)((float)(planet.getDistance() * Math.cos(angle))) + satellite.getDistance() * 0.8 * Math.cos(angle1));
        float planetY = (float)((double)((float)(planet.getDistance() * Math.sin(angle))) + satellite.getDistance() * 0.8 * Math.sin(angle1));
        double size = satellite.getSize() * 2.0;
        ScreenResearchTableSpace.bindTexture(satellite.getLocation());
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85837_(1.8, -0.2125, 0.0);
        pose.m_252880_(planetX, planetY, 0.0f);
        pose.m_85841_((float)(0.001953125 * size), (float)(0.001953125 * size), 1.0f);
        this.drawTexturedModalRect(poseStack, -128, -128, 0, 0, 256, 256);
        pose.m_85849_();
    }

    public void m_280273_(GuiGraphics pGuiGraphics) {
        if (this.f_96541_.f_91073_ != null) {
            pGuiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            this.m_280039_(pGuiGraphics);
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        this.f_97727_ = 255;
        this.f_97726_ = 255;
        boolean isClickedButton = false;
        super.mouseClicked(i, j, k);
        int xMin = this.guiLeft;
        int yMin = this.guiTop;
        int x = i - xMin;
        int y = j - yMin;
        if (this.mode == 0) {
            if (x >= 47 && x <= 137 && y >= 60 && y <= 150) {
                this.mode = 1;
                this.star = this.systems.get(this.systemId).getStarList().get(0);
                this.valuePage = 0;
                this.maxValuePage = 0;
                ((ContainerMenuResearchTableSpace)this.container).player.m_5496_(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
                return;
            }
            if (!this.animating) {
                if (this.hoverNextStar) {
                    isClickedButton = true;
                    this.startAnimation(true);
                    ++this.systemId;
                    if (this.systemId >= this.systems.size()) {
                        this.systemId = 0;
                    }
                }
                if (this.hoverBackStar) {
                    isClickedButton = true;
                    this.startAnimation(false);
                    --this.systemId;
                    if (this.systemId < 0) {
                        this.systemId = this.systems.size() - 1;
                    }
                }
            }
        } else if (this.mode == 1) {
            if (this.hoverBack) {
                this.mode = 0;
                this.star = null;
                this.systems = Collections.emptyList();
                this.focusedPlanet = null;
                ((ContainerMenuResearchTableSpace)this.container).player.m_5496_(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
                this.defaultResearchGuis.clear();
                return;
            }
            if (this.hoverOpen && this.focusedPlanet != null) {
                IBody planet;
                this.mode = 2;
                int seconds = 0;
                EnumLevels levels = EnumLevels.FIRST;
                if (this.focusedPlanet instanceof IPlanet) {
                    seconds = (int)(Math.abs(this.focusedPlanet.getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 360.0);
                    levels = ((IPlanet)this.focusedPlanet).getLevels();
                    seconds += this.focusedPlanet.getSystem().getDistanceFromSolar() * 60 * 60;
                }
                if (this.focusedPlanet instanceof ISatellite) {
                    planet = (ISatellite)this.focusedPlanet;
                    levels = planet.getLevels();
                    double distancePlanetToPlanet = (planet.getPlanet().getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance());
                    double distanceSatellite = Math.abs(SpaceInit.moon.getDistanceFromPlanet() - planet.getDistanceFromPlanet()) / SpaceInit.moon.getDistanceFromPlanet();
                    if (planet.getPlanet() == SpaceInit.earth) {
                        distanceSatellite = 1.0;
                    }
                    seconds = (int)Math.abs(distanceSatellite * 2.5 * 60.0 * 0.5 + distancePlanetToPlanet * 360.0);
                    seconds += planet.getSystem().getDistanceFromSolar() * 60 * 60;
                }
                if (this.focusedPlanet instanceof IAsteroid) {
                    planet = (IAsteroid)this.focusedPlanet;
                    seconds = (int)(Math.abs((planet.getMaxDistance() - planet.getMinDistance()) / 2.0 + planet.getMinDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 360.0);
                    seconds += planet.getSystem().getDistanceFromSolar() * 60 * 60;
                    levels = planet.getLevels();
                }
                this.minimumLimit = this.findOptimalUpgradeDistribution(seconds * 2, levels.ordinal() + 1);
                new PacketUpdateBody((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base, this.focusedPlanet);
                ((ContainerMenuResearchTableSpace)this.container).player.m_5496_(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
                return;
            }
            int dopX = 0;
            int dopY = 0;
            int jj = 0;
            List<IPlanet> list = new ArrayList<IPlanet>(this.star.getPlanetList());
            list.addAll(this.star.getAsteroidList());
            list = list.stream().sorted(Comparator.comparingDouble(IBody::getDistance)).collect(Collectors.toList());
            if (this.hoverUp || this.hoverDown) {
                isClickedButton = true;
                this.valuePage += this.hoverDown ? 1 : -1;
                if (this.valuePage < 0) {
                    this.valuePage = 0;
                }
                if (this.maxValuePage - this.valuePage < 9) {
                    this.valuePage = this.maxValuePage - 9;
                }
            }
            int tempMaxValuePage = Math.min(9, this.maxValuePage - this.valuePage);
            for (int ii = this.valuePage; ii < tempMaxValuePage + this.valuePage; ++ii) {
                IBody body = list.get(ii);
                int dop = 0;
                if (this.focusedPlanet == body) {
                    dop = 15;
                }
                if (this.focusedPlanet instanceof ISatellite && ((ISatellite)this.focusedPlanet).getPlanet() == body) {
                    dop = 15;
                }
                int temp = this.addPoint;
                if (ii <= this.valueBody) {
                    temp = 0;
                }
                if (x > 207 + dop && (double)x <= 273.95 + (double)dop && (double)y > 28.0 + (double)((jj + 1) * 19) * 0.65 + (double)temp && (double)y < (double)(temp + 28) + (double)((jj + 1) * 19) * 0.65 + 12.35) {
                    this.focusedPlanet = this.focusedPlanet != body ? body : null;
                    isClickedButton = true;
                    break;
                }
                if (dop != 0) {
                    List<Object> satelliteList = new ArrayList();
                    if (this.focusedPlanet instanceof IPlanet) {
                        satelliteList = ((IPlanet)this.focusedPlanet).getSatelliteList();
                    }
                    if (this.focusedPlanet instanceof ISatellite) {
                        satelliteList = ((ISatellite)this.focusedPlanet).getPlanet().getSatelliteList();
                    }
                    for (int iii = 0; iii < satelliteList.size(); ++iii) {
                        if (x <= 207 + dop * 2 || !((double)x <= 273.95 + (double)(dop * 2)) || !((double)y > 40.0 + (double)(jj * 19) * 0.65 + (double)temp + (double)((iii + 1) * 19) * 0.65) || !((double)y < 40.0 + (double)(jj * 19) * 0.65 + (double)temp + (double)((iii + 2) * 19) * 0.65)) continue;
                        this.focusedPlanet = this.focusedPlanet != satelliteList.get(iii) ? (IBody)satelliteList.get(iii) : null;
                        isClickedButton = true;
                        break;
                    }
                }
                ++jj;
            }
            if (x >= 30 && x <= 205 && y >= 30 && y <= 205) {
                if (this.focusedPlanet != null) {
                    if (this.focusedPlanet instanceof IPlanet) {
                        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                        double angle = Math.PI * 2 * (time * this.focusedPlanet.getOrbitPeriod()) / 400.0;
                        dopX = (int)(this.focusedPlanet.getDistance() * Math.cos(angle) * (double)this.scale * 16.0);
                        dopY = (int)(this.focusedPlanet.getDistance() * Math.sin(angle) * (double)this.scale * 16.0);
                        this.focusedPlanet = null;
                        isClickedButton = true;
                    } else if (this.focusedPlanet instanceof IAsteroid) {
                        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                        double angle = Math.PI * 2 * (time * this.focusedPlanet.getOrbitPeriod()) / 400.0;
                        dopX = (int)(this.focusedPlanet.getDistance() * Math.cos(angle) * (double)this.scale * 16.0);
                        dopY = (int)(this.focusedPlanet.getDistance() * Math.sin(angle) * (double)this.scale * 16.0);
                        this.focusedPlanet = null;
                        isClickedButton = true;
                    } else {
                        ISatellite satellite1 = (ISatellite)this.focusedPlanet;
                        double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                        double angle = Math.PI * 2 * (time * satellite1.getPlanet().getOrbitPeriod()) / 400.0;
                        double angle1 = Math.PI * 2 * (time * satellite1.getOrbitPeriod()) / 400.0;
                        dopX = (int)((float)((double)((float)(satellite1.getPlanet().getDistance() * Math.cos(angle))) + satellite1.getDistance() * 0.8 * Math.cos(angle1)) * this.scale * 16.0f);
                        dopY = (int)(((double)((float)(satellite1.getPlanet().getDistance() * Math.sin(angle))) + satellite1.getDistance() * 0.8 * Math.sin(angle1)) * (double)this.scale * 16.0);
                        this.focusedPlanet = null;
                        isClickedButton = true;
                    }
                }
                block2: for (IPlanet planet : this.star.getPlanetList()) {
                    double time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                    double angle = Math.PI * 2 * (time * planet.getOrbitPeriod()) / 400.0;
                    float planetX = (float)(planet.getDistance() * Math.cos(angle)) * this.scale * 16.0f;
                    float planetY = (float)(planet.getDistance() * Math.sin(angle)) * this.scale * 16.0f;
                    double size = planet.getSize() * 2.0 * (double)this.scale * 16.0;
                    if ((double)x >= (double)planetX - size / 4.0 + 7.0 + 81.0 + (double)this.offsetX - (double)dopX + (double)(29.0f * this.scale) && (double)x <= (double)planetX + size / 4.0 + 7.0 + 81.0 + (double)this.offsetX - (double)dopX + (double)(29.0f * this.scale) && (double)y >= (double)planetY - size / 4.0 + 80.0 + 41.0 + (double)this.offsetY - (double)dopY - (double)(4.0f * this.scale) && (double)y <= (double)planetY + size / 4.0 + 80.0 + 41.0 + (double)this.offsetY - (double)dopY - (double)(4.0f * this.scale)) {
                        this.focusedPlanet = planet;
                        isClickedButton = true;
                        this.textIndex = 0;
                        break;
                    }
                    if (planet.getLevels() != EnumLevels.NONE && !(((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).dataMap.get(planet).getPercent() >= 2.0)) continue;
                    for (ISatellite satellite1 : planet.getSatelliteList()) {
                        if (satellite1.getLevels() != EnumLevels.NONE && satellite1.getLevels().ordinal() > ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level.ordinal()) continue;
                        time = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).getWorld().m_46467_();
                        angle = Math.PI * 2 * (time * planet.getOrbitPeriod()) / 400.0;
                        double angle1 = Math.PI * 2 * (time * satellite1.getOrbitPeriod()) / 400.0;
                        planetX = (float)((double)((float)(planet.getDistance() * Math.cos(angle))) + satellite1.getDistance() * 0.8 * Math.cos(angle1)) * this.scale * 16.0f;
                        planetY = (float)((double)((float)(planet.getDistance() * Math.sin(angle))) + satellite1.getDistance() * 0.8 * Math.sin(angle1)) * this.scale * 16.0f;
                        size = satellite1.getSize() * 2.0 * (double)this.scale * 16.0;
                        if (!((double)x >= (double)planetX - size / 4.0 + 7.0 + 81.0 + (double)this.offsetX - (double)dopX + (double)(29.0f * this.scale)) || !((double)x <= (double)planetX + size / 4.0 + 7.0 + 81.0 + (double)this.offsetX - (double)dopX + (double)(29.0f * this.scale)) || !((double)y >= (double)planetY - size / 4.0 + 80.0 + 41.0 + (double)this.offsetY - (double)dopY - (double)(4.0f * this.scale)) || !((double)y <= (double)planetY + size / 4.0 + 80.0 + 41.0 + (double)this.offsetY - (double)dopY - (double)(4.0f * this.scale))) continue;
                        this.focusedPlanet = satellite1;
                        this.textIndex = 0;
                        isClickedButton = true;
                        continue block2;
                    }
                }
            }
        } else if (this.mode == 2) {
            boolean find;
            ScreenDefaultResearchTable defaultResearchTable;
            int ii;
            for (ii = 0; ii < this.defaultResearchGuis.size(); ++ii) {
                defaultResearchTable = this.defaultResearchGuis.get(ii);
                if (!defaultResearchTable.mouseClicked(x, y)) continue;
                return;
            }
            for (ii = 0; ii < this.defaultResearchGuis.size(); ++ii) {
                defaultResearchTable = this.defaultResearchGuis.get(ii);
                if (!defaultResearchTable.is(x, y)) continue;
                return;
            }
            if (this.hoverResource && this.defaultResearchGuis.isEmpty()) {
                find = false;
                for (ScreenDefaultResearchTable defaultResearchTable2 : this.defaultResearchGuis) {
                    if (!(defaultResearchTable2 instanceof ScreenResourceBody)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    this.defaultResearchGuis.add(new ScreenResourceBody(this));
                }
            }
            if (this.hoverColonies && this.defaultResearchGuis.isEmpty() && (this.focusedPlanet instanceof IPlanet && ((IPlanet)this.focusedPlanet).canHaveColonies() || this.focusedPlanet instanceof ISatellite && ((ISatellite)this.focusedPlanet).canHaveColonies() || !(this.focusedPlanet instanceof IAsteroid))) {
                find = false;
                for (ScreenDefaultResearchTable defaultResearchTable2 : this.defaultResearchGuis) {
                    if (!(defaultResearchTable2 instanceof ScreenColony)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    this.defaultResearchGuis.add(new ScreenColony(this));
                }
            }
            if (this.hoverExpedition && this.defaultResearchGuis.isEmpty()) {
                find = false;
                for (ScreenDefaultResearchTable defaultResearchTable2 : this.defaultResearchGuis) {
                    if (!(defaultResearchTable2 instanceof ScreenExpeditionTableSpace)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    this.defaultResearchGuis.add(new ScreenExpeditionTableSpace(this));
                }
            }
            if (this.hoverBack) {
                this.mode = 1;
                this.defaultResearchGuis.clear();
                new PacketUpdateBody((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base, null);
                ((ContainerMenuResearchTableSpace)this.container).player.m_5496_(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
                return;
            }
        } else if (this.mode == 5 && x > 130 && x <= 146 && y > 16 && y < 32) {
            new PacketAddBuildingToColony(((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).colony);
        }
        if (isClickedButton) {
            ((ContainerMenuResearchTableSpace)this.container).player.m_5496_(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
        }
    }

    private void renderPlanet1(PoseStack poseStack, float radius, ResourceLocation texture, float x, float y, float z, float rotation, float rotationAngle, float rotationAngleX) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationAngle));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotationAngleX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        this.renderCube(poseStack, radius);
        poseStack.m_85849_();
    }

    private void renderCube(PoseStack poseStack, float radius) {
        float halfSize = radius / 2.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix, -halfSize, -halfSize, -halfSize).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, -halfSize, -halfSize).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, halfSize, -halfSize).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, halfSize, -halfSize).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, -halfSize, halfSize).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, -halfSize, halfSize).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, halfSize, halfSize).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, halfSize, halfSize).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, -halfSize, halfSize).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, -halfSize, -halfSize).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, halfSize, -halfSize).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, halfSize, halfSize).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, -halfSize, halfSize).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, -halfSize, -halfSize).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, halfSize, -halfSize).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, halfSize, halfSize).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, halfSize, -halfSize).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, halfSize, -halfSize).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, halfSize, halfSize).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, halfSize, halfSize).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, -halfSize, -halfSize).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, -halfSize, -halfSize).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, halfSize, -halfSize, halfSize).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -halfSize, -halfSize, halfSize).m_7421_(0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }

    @Override
    public void handleUpgradeTooltip(int mouseX, int mouseY) {
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        if (this.mode == 0) {
            if (this.star == null) {
                this.foregroundMainMenu(poseStack, par1, par2);
            }
        } else if (this.mode == 1) {
            this.hoverUp = false;
            this.hoverDown = false;
            this.hoverBack = false;
            this.hoverOpen = false;
            int tempMaxValuePage = Math.min(9, this.maxValuePage - this.valuePage);
            if (this.valuePage > 0 && par1 >= 230 && par1 <= 246 && par2 >= 30 && (double)par2 <= 42.35) {
                this.hoverUp = true;
            }
            if (tempMaxValuePage > 0 && this.maxValuePage - this.valuePage > 9 && par1 >= 230 && par1 <= 246 && par2 >= (tempMaxValuePage - 1) * 19 + this.addPoint && (double)par2 < (double)((tempMaxValuePage - 1) * 19) + 12.35 + (double)this.addPoint) {
                this.hoverDown = true;
            }
            if (par1 >= 9 && par1 <= 24 && par2 >= 28 && par2 <= 45) {
                this.hoverBack = true;
            }
            if (this.focusedPlanet != null && par1 >= 66 && par1 <= 168 && par2 >= 210 && par2 <= 232) {
                this.hoverOpen = true;
            }
            if (this.focusedPlanet != null) {
                EnumLevels level = EnumLevels.NONE;
                if (this.focusedPlanet instanceof IPlanet) {
                    level = ((IPlanet)this.focusedPlanet).getLevels();
                }
                if (this.focusedPlanet instanceof ISatellite) {
                    level = ((ISatellite)this.focusedPlanet).getLevels();
                }
                if (this.focusedPlanet instanceof IAsteroid) {
                    level = ((IAsteroid)this.focusedPlanet).getLevels();
                }
                if (((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != null && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level.ordinal() >= level.ordinal() && level != EnumLevels.NONE && ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).level != EnumLevels.NONE) {
                    this.drawCenteredText(poseStack, Localization.translate("iu.space.open"), 117.0f, 215.0f, 0.0f, 1.0f, -1);
                }
            }
        } else if (this.mode == 2) {
            if (this.defaultResearchGuis.isEmpty()) {
                Data data;
                this.hoverBack = false;
                this.hoverResource = false;
                this.hoverColonies = false;
                this.hoverExpedition = false;
                if (par1 >= 9 && par1 <= 24 && par2 >= 28 && par2 <= 45) {
                    this.hoverBack = true;
                }
                if (par1 >= 30 && (float)par1 <= 94.89f && par2 >= 115 && (float)par2 <= 127.6f) {
                    this.hoverResource = true;
                }
                if ((data = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.container).base).dataMap.get(this.focusedPlanet)).getPercent() >= 100.0 && par1 >= 30 && (float)par1 <= 94.89f && par2 >= 155 && (float)par2 <= 167.6f) {
                    this.hoverColonies = true;
                }
                if (par1 >= 30 && (float)par1 <= 94.89f && par2 >= 135 && (float)par2 <= 147.6f) {
                    this.hoverExpedition = true;
                }
            }
            for (int i = 0; i < this.defaultResearchGuis.size(); ++i) {
                ScreenDefaultResearchTable defaultResearchTable = this.defaultResearchGuis.get(i);
                defaultResearchTable.drawForegroundLayer(poseStack, par1, par2);
            }
            if (this.defaultResearchGuis.isEmpty()) {
                ISatellite s;
                IPlanet p;
                Result result = this.minimumLimit;
                new TooltipWidget(this, 34, 173, 16, 16).withTooltip(Localization.translate("iu.space.fuel_level") + " " + result.allocations.fuelLevel).drawForeground(poseStack, par1, par2);
                new TooltipWidget(this, 54, 175, 16, 16).withTooltip(Localization.translate("iu.space.rocket_level") + " " + result.allocations.rocketLevel).drawForeground(poseStack, par1, par2);
                new TooltipWidget(this, 74, 175, 16, 16).withTooltip(Localization.translate("iu.space.fuel_used") + " " + result.allocations.fuelUsed + " mb").drawForeground(poseStack, par1, par2);
                new TooltipWidget(this, 74, 191, 16, 16).withTooltip(Localization.translate("iu.space.time_remaining") + " " + new Timer(result.allocations.remaining).getDisplay()).drawForeground(poseStack, par1, par2);
                int temperature = this.focusedPlanet.getTemperature();
                if (temperature > 150) {
                    count = (int)Math.ceil((double)(temperature - 150) / 350.0);
                    new TooltipWidget(this, 34, 191, 16, 16).withTooltip(Localization.translate("iu.space.heat_module") + " " + count).drawForeground(poseStack, par1, par2);
                } else if (temperature < -125) {
                    count = (int)Math.ceil((double)(Math.abs(temperature) - 125) / 37.0);
                    new TooltipWidget(this, 34, 191, 16, 16).withTooltip(Localization.translate("iu.space.cold_module") + " " + count).drawForeground(poseStack, par1, par2);
                }
                IBody iBody = this.focusedPlanet;
                if (iBody instanceof IPlanet && (p = (IPlanet)iBody).getPressure() || (iBody = this.focusedPlanet) instanceof ISatellite && (s = (ISatellite)iBody).getPressure()) {
                    new TooltipWidget(this, 54, 191, 16, 16).withTooltip(Localization.translate("iu.space.pressure_module") + " ").drawForeground(poseStack, par1, par2);
                }
            }
        }
    }

    private void foregroundMainMenu(GuiGraphics poseStack, int par1, int par2) {
        String result;
        String starName;
        Object systemName;
        IStar star;
        if (this.systems != null) {
            star = this.systems.get(this.systemId).getStarList().get(0);
            systemName = this.systems.get(this.systemId).getName();
            starName = star.getName();
            systemName = ((String)systemName).substring(0, 1).toUpperCase() + ((String)systemName).substring(1).toLowerCase().replace("system", "");
            starName = Localization.translate("iu.body." + starName);
            result = Localization.translate("iu.space_solar_system") + " " + (String)systemName + "\n" + Localization.translate("iu.space_solar") + " " + starName + "\n" + Localization.translate("iu.space_solar_planets") + " " + star.getPlanetList().size() + "\n" + Localization.translate("iu.space_solar_asteroid") + " " + (star.getAsteroidList().isEmpty() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes"));
            new TooltipWidget(this, this.f_97726_ / 2 - 80 + 30, 60, 90, 90).withTooltip(result).drawForeground(poseStack, par1, par2);
        }
        this.hoverNextStar = false;
        this.hoverBackStar = false;
        if (par1 >= this.f_97726_ / 2 - 110 + 30 && par1 <= this.f_97726_ / 2 - 110 + 32 + 30 && par2 >= 160 && par2 <= 192) {
            int tempid = this.systemId - 1;
            if (tempid < 0) {
                tempid = this.systems.size() - 1;
            }
            IStar star2 = this.systems.get(tempid).getStarList().get(0);
            Object systemName2 = this.systems.get(tempid).getName();
            String starName2 = star2.getName();
            systemName2 = ((String)systemName2).substring(0, 1).toUpperCase() + ((String)systemName2).substring(1).toLowerCase().replace("system", "");
            starName2 = Localization.translate("iu.body." + starName2);
            String result2 = Localization.translate("iu.space_solar_system") + " " + (String)systemName2 + "\n" + Localization.translate("iu.space_solar") + " " + starName2 + "\n" + Localization.translate("iu.space_solar_planets") + " " + star2.getPlanetList().size() + "\n" + Localization.translate("iu.space_solar_asteroid") + " " + (star2.getAsteroidList().isEmpty() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes"));
            new TooltipWidget(this, this.f_97726_ / 2 - 110 + 30, 160, 32, 32).withTooltip(result2).drawForeground(poseStack, par1, par2);
            this.hoverBackStar = true;
        }
        if (par1 >= this.f_97726_ / 2 + 20 + 30 && par1 <= this.f_97726_ / 2 + 20 + 32 + 30 && par2 >= 160 && par2 <= 192) {
            star = this.systems.get((this.systemId + 1) % this.systems.size()).getStarList().get(0);
            systemName = this.systems.get((this.systemId + 1) % this.systems.size()).getName();
            starName = star.getName();
            systemName = ((String)systemName).substring(0, 1).toUpperCase() + ((String)systemName).substring(1).toLowerCase().replace("system", "");
            starName = Localization.translate("iu.body." + starName);
            result = Localization.translate("iu.space_solar_system") + " " + (String)systemName + "\n" + Localization.translate("iu.space_solar") + " " + starName + "\n" + Localization.translate("iu.space_solar_planets") + " " + star.getPlanetList().size() + "\n" + Localization.translate("iu.space_solar_asteroid") + " " + (star.getAsteroidList().isEmpty() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes"));
            new TooltipWidget(this, this.f_97726_ / 2 + 20 + 30, 160, 32, 32).withTooltip(result).drawForeground(poseStack, par1, par2);
            this.hoverNextStar = true;
        }
    }

    public String getInformationFromBody(IBody body, double data) {
        if (body instanceof IPlanet) {
            IPlanet focusedPlanet = (IPlanet)body;
            return Localization.translate("iu.space_size") + " " + ModUtils.getString(focusedPlanet.getSize() * 12756.0 / SpaceInit.earth.getSize()) + "\n" + Localization.translate("iu.space_has_pressure") + " " + (!focusedPlanet.getPressure() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_distance") + " " + ModUtils.getString(focusedPlanet.getDistance() * 1.492E8 / SpaceInit.earth.getDistance()) + "\n" + Localization.translate("iu.space_orbit_time") + " " + ModUtils.getString(focusedPlanet.getOrbitPeriod() * 365.0 / SpaceInit.earth.getOrbitPeriod()) + "\n" + Localization.translate("iu.space_temperature") + " " + focusedPlanet.getTemperature() + "C\u00b0\n" + Localization.translate("iu.space_has_oxygen") + " " + (!focusedPlanet.hasOxygen() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_colonies") + " " + (!focusedPlanet.canHaveColonies() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_research") + " " + ModUtils.getString(data) + "%";
        }
        if (body instanceof ISatellite) {
            ISatellite focusedPlanet = (ISatellite)body;
            return Localization.translate("iu.space_size") + " " + ModUtils.getString(focusedPlanet.getSize() * 3474.0 / SpaceInit.moon.getSize()) + "\n" + Localization.translate("iu.space_has_pressure") + " " + (!focusedPlanet.getPressure() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_distance_from_planet") + " " + ModUtils.getString(focusedPlanet.getDistance() * 384400.0 / SpaceInit.moon.getDistance()) + "\n" + Localization.translate("iu.space_orbit_time") + " " + ModUtils.getString(focusedPlanet.getOrbitPeriod() * 27.0 / SpaceInit.moon.getOrbitPeriod()) + "\n" + Localization.translate("iu.space_temperature") + " " + focusedPlanet.getTemperature() + "C\u00b0\n" + Localization.translate("iu.space_has_oxygen") + " " + (!focusedPlanet.hasOxygen() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_colonies") + " " + (!focusedPlanet.canHaveColonies() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_research") + " " + ModUtils.getString(data) + "%";
        }
        if (body instanceof IAsteroid) {
            IAsteroid focusedPlanet = (IAsteroid)body;
            return Localization.translate("iu.space_size") + " " + ModUtils.getString(focusedPlanet.getSize() * 3474.0 / SpaceInit.moon.getSize()) + "\n" + Localization.translate("iu.space_minimum_distance") + " " + ModUtils.getString(focusedPlanet.getMinDistance() * 1.492E8 / SpaceInit.earth.getDistance()) + "\n" + Localization.translate("iu.space_maximum_distance") + " " + ModUtils.getString(focusedPlanet.getMinDistance() * 1.492E8 / SpaceInit.earth.getDistance()) + "\n" + Localization.translate("iu.space_temperature") + " " + focusedPlanet.getTemperature() + "C\u00b0\n" + Localization.translate("iu.space_has_oxygen") + " " + Localization.translate("iu.space_no") + "\n" + Localization.translate("iu.space_colonies") + " " + (!focusedPlanet.canHaveColonies() ? Localization.translate("iu.space_no") : Localization.translate("iu.space_yes")) + "\n" + Localization.translate("iu.space_research") + " " + ModUtils.getString(data) + "%";
        }
        return "";
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiresearch_table.png");
    }

    private Result computeUncoveredSeconds(List<FuelAllocation> allocations, Map<Integer, Double> fuelEfficiency, int fuelPerSecond, int totalSeconds) {
        for (FuelAllocation fa : allocations) {
            double rocketCoef;
            double seconds = 0.0;
            double fuelCoef = fuelEfficiency.get(fa.fuelLevel);
            if (!((double)totalSeconds - (seconds += (double)fa.fuelUsed / (double)fuelPerSecond * fuelCoef * (rocketCoef = 1.0 + (double)fa.upgrades * 0.125)) <= 0.0)) continue;
            fa.remaining = fa.fuelUsed / fuelPerSecond;
            return new Result(fa, fa.upgrades);
        }
        return new Result(null, -1);
    }

    private List<FuelAllocation> allocateFuel(int totalSeconds, Map<Integer, Double> fuelEfficiency, Map<Integer, Integer> tankCapacities, Map<Integer, Integer> rocketUpgrades, int fuelPerSecond, int planetTier) {
        ArrayList<FuelAllocation> result = new ArrayList<FuelAllocation>();
        ArrayList<Integer> rocketLevels = new ArrayList<Integer>(tankCapacities.keySet());
        rocketLevels.sort(Comparator.reverseOrder());
        ArrayList<Map.Entry<Integer, Double>> sortedFuel = new ArrayList<Map.Entry<Integer, Double>>(fuelEfficiency.entrySet());
        sortedFuel.sort((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue()));
        block0: for (int rocketLevel = 1; rocketLevel < 7; ++rocketLevel) {
            int capacity = tankCapacities.getOrDefault(rocketLevel, 0);
            int upgrades = rocketUpgrades.getOrDefault(rocketLevel, 0);
            EnumRoversLevel canLevel = EnumRoversLevel.values()[Math.min(rocketLevel - 1, EnumRoversLevel.values().length - 1)];
            double rocketMultiplier = 1.0 + (double)upgrades * 0.125;
            for (Map.Entry entry : sortedFuel) {
                double totalMultiplier;
                double maxSeconds;
                double remaining = totalSeconds;
                int fuelLevel = (Integer)entry.getKey();
                int requiredLevel = this.fuelPlanetRequirements.getOrDefault(fuelLevel, Integer.MAX_VALUE);
                if (planetTier < requiredLevel || !canLevel.getLevelsList().contains((Object)EnumLevels.values()[planetTier - 1])) continue;
                double fuelMultiplier = (Double)entry.getValue();
                if (fuelLevel > rocketLevel || (maxSeconds = (double)capacity / (double)fuelPerSecond * (totalMultiplier = fuelMultiplier * rocketMultiplier)) <= 0.0 || remaining > maxSeconds) continue;
                double secondsToCover = remaining;
                int fuelNeeded = (int)Math.ceil(secondsToCover / totalMultiplier * (double)fuelPerSecond);
                if ((fuelNeeded = Math.min(fuelNeeded, capacity)) * 2 > capacity) continue;
                result.add(new FuelAllocation(rocketLevel, fuelLevel, fuelNeeded, upgrades, remaining));
                if (!((remaining -= (double)fuelNeeded / (double)fuelPerSecond * totalMultiplier) <= 0.0)) continue;
                continue block0;
            }
        }
        return result;
    }

    public Result findOptimalUpgradeDistribution(int totalSeconds, int planetLevel) {
        HashMap<Integer, Integer> usableTanks = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : BaseSpaceSystem.rocketFuel.entrySet()) {
            int rocketLevel = entry.getKey();
            int requiredPlanet = this.rocketPlanetRequirements.getOrDefault(rocketLevel, Integer.MAX_VALUE);
            if (planetLevel < requiredPlanet) continue;
            usableTanks.put(rocketLevel, entry.getValue());
        }
        ArrayList<Result> results = new ArrayList<Result>();
        for (int upgrades = 0; upgrades <= 4; ++upgrades) {
            HashMap<Integer, Integer> upgradeMap = new HashMap<Integer, Integer>();
            if (upgrades > 0 && planetLevel < 4) continue;
            Iterator requiredPlanet = usableTanks.keySet().iterator();
            while (requiredPlanet.hasNext()) {
                int level = (Integer)requiredPlanet.next();
                upgradeMap.put(level, upgrades);
            }
            HashMap<Integer, Integer> capacityCopy = new HashMap<Integer, Integer>(usableTanks);
            List<FuelAllocation> allocations = this.allocateFuel(totalSeconds, BaseSpaceSystem.rocketFuelCoef, capacityCopy, upgradeMap, 2, planetLevel);
            Result result = this.computeUncoveredSeconds(allocations, BaseSpaceSystem.rocketFuelCoef, 2, totalSeconds);
            if (result.allocations == null) continue;
            results.add(result);
        }
        return results.isEmpty() ? new Result(null, -1) : (Result)results.get(0);
    }
}

