/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.EmptyWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityBaseHeatMachine;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.containermenu.ContainerMenuHeatMachine;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class ScreenHeatMachine<T extends ContainerMenuHeatMachine>
extends ScreenMain<ContainerMenuHeatMachine> {
    public ContainerMenuHeatMachine container;
    public String name;

    public ScreenHeatMachine(ContainerMenuHeatMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((BlockEntityBaseHeatMachine)guiContainer.base).getName());
        if (((BlockEntityBaseHeatMachine)this.container.base).hasFluid) {
            this.componentList.add(new ScreenWidget(this, 117, 41, EnumTypeComponent.FLUID_PART, new WidgetDefault<EmptyWidget>(new EmptyWidget())));
            this.addWidget(TankWidget.createNormal(this, 96, 22, (IFluidTank)((BlockEntityBaseHeatMachine)this.container.base).fluidTank));
        } else {
            this.componentList.add(new ScreenWidget(this, 113, 21, EnumTypeComponent.ENERGY_HEIGHT, new WidgetDefault<Energy>(((BlockEntityBaseHeatMachine)this.container.base).energy)));
        }
        this.componentList.add(new ScreenWidget(this, 51, 41, EnumTypeComponent.HEAT, new WidgetDefault<HeatComponent>(((BlockEntityBaseHeatMachine)this.container.base).heat)));
        this.componentList.add(new ScreenWidget(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new WidgetDefault<1>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((BlockEntityBaseHeatMachine)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((BlockEntityBaseHeatMachine)this.getEntityBlock()).work;
            }
        })));
        this.componentList.add(new ScreenWidget(this, 53, 60, EnumTypeComponent.PLUS_BUTTON, new WidgetDefault<2>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return "+1000";
            }
        })));
        this.componentList.add(new ScreenWidget(this, 78, 60, EnumTypeComponent.MINUS_BUTTON, new WidgetDefault<3>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 1, ""){

            @Override
            public String getText() {
                return "-1000";
            }
        })));
    }

    @Override
    public void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.heat_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.heating;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenHeatMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 3, this.guiTop + 3, 0, 0, 10, 10);
        ScreenHeatMachine.bindTexture(this.getTexture());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

