/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.QuantumQuarryRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class QuantumQuarrySerializer
implements RecipeSerializer<QuantumQuarryRecipe> {
    public static final QuantumQuarrySerializer INSTANCE = new QuantumQuarrySerializer();

    public QuantumQuarryRecipe fromJson(ResourceLocation id, JsonObject json) {
        String recipeType = GsonHelper.m_13906_((JsonObject)json, (String)"recipe_type");
        String recipeOperation = GsonHelper.m_13906_((JsonObject)json, (String)"recipeOperation");
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs")) {
            JsonArray inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            block52: for (JsonElement el : inArray) {
                JsonObject obj = el.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
                String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                switch (type) {
                    case "item": {
                        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(stack);
                        continue block52;
                    }
                    case "tag": {
                        input.add(new InputOreDict(itemId, amount).getInputs().get(0));
                        continue block52;
                    }
                }
                throw new IllegalArgumentException("Unknown input type: " + type);
            }
        }
        block14 : switch (recipeOperation) {
            case "default": {
                switch (recipeOperation) {
                    case "addAll": {
                        IUCore.list_adding.addAll(input);
                        break;
                    }
                    case "remove": {
                        IUCore.list_removing.addAll(input);
                    }
                }
                break;
            }
            case "furnace": {
                switch (recipeOperation) {
                    case "addAll": {
                        IUCore.list_furnace_adding.addAll(input);
                        break;
                    }
                    case "remove": {
                        IUCore.list_furnace_removing.addAll(input);
                    }
                }
                break;
            }
            case "macerator": {
                switch (recipeOperation) {
                    case "addAll": {
                        IUCore.list_crushed_adding.addAll(input);
                        break;
                    }
                    case "remove": {
                        IUCore.list_crushed_removing.addAll(input);
                    }
                }
                break;
            }
            case "comb_macerator": {
                switch (recipeOperation) {
                    case "addAll": {
                        IUCore.list_comb_crushed_adding.addAll(input);
                        break block14;
                    }
                    case "remove": {
                        IUCore.list_comb_crushed_removing.addAll(input);
                    }
                }
            }
        }
        return new QuantumQuarryRecipe(id, recipeType, recipeOperation, input);
    }

    public void toNetwork(FriendlyByteBuf buf, QuantumQuarryRecipe recipe) {
        buf.m_130070_(recipe.getRecipeType());
        buf.m_130070_(recipe.getTypeOperation());
        List<ItemStack> inputs = recipe.getInputs();
        buf.m_130130_(inputs.size());
        for (ItemStack stack : inputs) {
            buf.m_130055_(stack);
        }
    }

    public QuantumQuarryRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String recipeType = buf.m_130277_();
        String recipeOperation = buf.m_130277_();
        int size = buf.m_130242_();
        ArrayList<ItemStack> input = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            input.add(buf.m_130267_());
        }
        if (!IUCore.updateRecipe) {
            block6 : switch (recipeOperation) {
                case "default": {
                    switch (recipeOperation) {
                        case "addAll": {
                            IUCore.list_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "furnace": {
                    switch (recipeOperation) {
                        case "addAll": {
                            IUCore.list_furnace_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_furnace_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "macerator": {
                    switch (recipeOperation) {
                        case "addAll": {
                            IUCore.list_crushed_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_crushed_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "comb_macerator": {
                    switch (recipeOperation) {
                        case "addAll": {
                            IUCore.list_comb_crushed_adding.addAll(input);
                            break block6;
                        }
                        case "remove": {
                            IUCore.list_comb_crushed_removing.addAll(input);
                        }
                    }
                }
            }
        }
        return new QuantumQuarryRecipe(id, recipeType, recipeOperation, input);
    }
}

