/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.Planet;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.PlanetRecipe;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PlanetSerializer
implements RecipeSerializer<PlanetRecipe> {
    public static final PlanetSerializer INSTANCE = new PlanetSerializer();
    public static List<String> stringList = new ArrayList<String>();

    public PlanetRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        ResourceLocation texture = new ResourceLocation(json.get("texture").getAsString() + ".png");
        EnumLevels level = EnumLevels.valueOf(json.get("level").getAsString().toUpperCase());
        int temperature = json.get("temperature").getAsInt();
        boolean pressure = json.get("pressure").getAsBoolean();
        double distance = json.get("distance").getAsDouble();
        EnumType type = EnumType.valueOf(json.get("type").getAsString().toUpperCase());
        boolean oxygen = json.get("oxygen").getAsBoolean();
        boolean colonies = json.get("colonies").getAsBoolean();
        int angle = json.get("angle").getAsInt();
        double time = json.get("time").getAsDouble();
        double size = json.get("size").getAsDouble();
        double rotation = json.get("rotation").getAsDouble();
        if (!stringList.contains("planet_" + name)) {
            SpaceInit.regPlanet.add(() -> new Planet(name, SpaceNet.instance.getSystem().stream().filter(systems -> systems.getName().equals(json.get("system").getAsString().toLowerCase())).toList().get(0), texture, level, (IStar)SpaceNet.instance.getBodyFromName(json.get("star").getAsString()), temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
            stringList.add("planet_" + name);
        }
        return new PlanetRecipe(id, name, json.get("star").getAsString(), texture, level, json.get("star").getAsString(), temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation);
    }

    public PlanetRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        String systemName = buf.m_130277_();
        String texturePath = buf.m_130277_();
        ResourceLocation texture = new ResourceLocation(texturePath);
        EnumLevels level = EnumLevels.valueOf(buf.m_130277_().toUpperCase());
        String starName = buf.m_130277_();
        int temperature = buf.m_130242_();
        boolean pressure = buf.readBoolean();
        double distance = buf.readDouble();
        EnumType type = EnumType.valueOf(buf.m_130277_().toUpperCase());
        boolean oxygen = buf.readBoolean();
        boolean colonies = buf.readBoolean();
        int angle = buf.m_130242_();
        double time = buf.readDouble();
        double size = buf.readDouble();
        double rotation = buf.readDouble();
        if (!stringList.contains("planet_" + name)) {
            SpaceInit.regPlanet.add(() -> new Planet(name, SpaceNet.instance.getSystem().stream().filter(systems -> systems.getName().equals(systemName.toLowerCase())).toList().get(0), texture, level, (IStar)SpaceNet.instance.getBodyFromName(starName), temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
            stringList.add("planet_" + name);
        }
        return new PlanetRecipe(id, name, systemName, texture, level, starName, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation);
    }

    public void toNetwork(FriendlyByteBuf buf, PlanetRecipe recipe) {
        buf.m_130070_(recipe.name);
        buf.m_130070_(recipe.system);
        buf.m_130070_(recipe.texture.toString());
        buf.m_130070_(recipe.level.name());
        buf.m_130070_(recipe.star);
        buf.m_130130_(recipe.temperature);
        buf.writeBoolean(recipe.pressure);
        buf.writeDouble(recipe.distance);
        buf.m_130070_(recipe.type.name());
        buf.writeBoolean(recipe.oxygen);
        buf.writeBoolean(recipe.colonies);
        buf.m_130130_(recipe.angle);
        buf.writeDouble(recipe.time);
        buf.writeDouble(recipe.size);
        buf.writeDouble(recipe.rotation);
    }
}

