/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.utils.ModUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class IngredientInput
extends Ingredient {
    private IInputItemStack input;
    private ItemStack[] items;
    private IntList list;

    public IngredientInput(IInputItemStack input) {
        super(Stream.of(new Ingredient.Value[0]));
        this.input = input;
    }

    public ItemStack[] m_43908_() {
        if (this.items == null) {
            this.items = this.input.getInputs().toArray(new ItemStack[0]);
        }
        if (this.input.hasTag() && this.input.getInputs().isEmpty()) {
            this.input = new InputOreDict(this.input.getTag(), this.input.getAmount());
            this.items = this.input.getInputs().toArray(new ItemStack[0]);
        }
        return this.items;
    }

    public JsonElement m_43942_() {
        JsonArray jsonarray = new JsonArray();
        if (this.input.hasTag()) {
            jsonarray.add((JsonElement)new Ingredient.TagValue(this.input.getTag()).m_6544_());
        } else {
            jsonarray.add((JsonElement)new Ingredient.ItemValue(this.input.getInputs().get(0)).m_6544_());
        }
        return jsonarray;
    }

    public boolean test(@Nullable ItemStack item) {
        return this.input.matches(item);
    }

    public IntList m_43931_() {
        if (this.list == null) {
            ItemStack[] items = this.m_43908_();
            this.list = new IntArrayList(items.length);
            for (ItemStack itemstack : items) {
                this.list.add(StackedContents.m_36496_((ItemStack)itemstack));
            }
            this.list.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.list;
    }

    public boolean isSimple() {
        return false;
    }

    public Ingredient getInput() {
        if (!this.input.getInputs().isEmpty() && this.input.getInputs().get(0).m_41782_()) {
            ItemStack stack = this.input.getInputs().get(0);
            ModUtils.removeIgnoreKeys(stack);
            if (!stack.m_41782_()) {
                if (this.input.hasTag()) {
                    return Ingredient.m_204132_(this.input.getTag());
                }
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input.getInputs().get(0)});
            }
            if (this.input.getInputs().size() == 1) {
                return StrictNBTIngredient.of((ItemStack)this.input.getInputs().get(0));
            }
            ArrayList items = new ArrayList();
            this.input.getInputs().forEach(stack1 -> items.add(stack1.m_41720_()));
            return PartialNBTIngredient.of((CompoundTag)this.input.getInputs().get(0).m_41783_(), (ItemLike[])((ItemLike[])items.toArray(new Item[0])));
        }
        if (this.input.hasTag()) {
            return Ingredient.m_204132_(this.input.getTag());
        }
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input.getInputs().get(0)});
    }
}

