/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PacketUpdateRecipe
implements IPacket {
    public PacketUpdateRecipe() {
    }

    public PacketUpdateRecipe(String recipe, boolean isFluid, ServerPlayer player) {
        if (isFluid) {
            List<BaseFluidMachineRecipe> recipes = Recipes.recipes.getRecipeFluid().getRecipeList(recipe);
            this.sendChunkedRecipes(recipe, recipes, true, player);
        } else {
            List<BaseMachineRecipe> recipes = Recipes.recipes.getRecipeList(recipe);
            this.sendChunkedRecipes(recipe, recipes, false, player);
        }
    }

    private <T> void sendChunkedRecipes(String recipeKey, List<T> fullList, boolean isFluid, ServerPlayer player) {
        int CHUNK_SIZE = 64;
        for (int i = 0; i < fullList.size(); i += 64) {
            int end = Math.min(i + 64, fullList.size());
            List<T> chunk = fullList.subList(i, end);
            CustomPacketBuffer buffer = new CustomPacketBuffer();
            buffer.writeByte(this.getId());
            try {
                EncoderHandler.encode(buffer, recipeKey);
                EncoderHandler.encode(buffer, isFluid);
                EncoderHandler.encode(buffer, chunk);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to encode recipe chunk", e);
            }
            buffer.flip();
            IUCore.network.getServer().sendPacket(buffer, player);
        }
    }

    @Override
    public byte getId() {
        return 60;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            String recipe = (String)DecoderHandler.decode(customPacketBuffer);
            boolean isFluid = (Boolean)DecoderHandler.decode(customPacketBuffer);
            if (isFluid) {
                List recipes = (List)DecoderHandler.decode(customPacketBuffer);
                for (BaseFluidMachineRecipe baseFluidMachineRecipe : recipes) {
                    Recipes.recipes.getRecipeFluid().addRecipe(recipe, baseFluidMachineRecipe);
                }
            } else {
                List recipes = (List)DecoderHandler.decode(customPacketBuffer);
                for (BaseMachineRecipe baseFluidMachineRecipe : recipes) {
                    Recipes.recipes.addRecipe(recipe, baseFluidMachineRecipe);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

