/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blockentity.storage.BlockEntityMonitor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PackerUpdateClientAddStack;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketAddStack
implements IPacket {
    public PacketAddStack() {
    }

    public PacketAddStack(Player player, ItemStack stack, BlockPos pos) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, pos);
            EncoderHandler.encode(customPacketBuffer, player.m_20148_());
            EncoderHandler.encode(customPacketBuffer, stack);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 114;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            ItemStack stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_20148_().equals(uuid) && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof BlockEntityMonitor) {
                int count;
                BlockEntityMonitor controller = (BlockEntityMonitor)blockEntity;
                if (controller.network != null && (count = controller.network.canAdd(stack)) > 0) {
                    stack.m_41764_(count);
                    controller.network.addStack(stack);
                    int count1 = entityPlayer.f_36096_.m_142621_().m_41613_() - count;
                    entityPlayer.f_36096_.m_142503_(entityPlayer.f_36096_.m_142621_().m_41620_(count1));
                    new PackerUpdateClientAddStack(entityPlayer, stack);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

