/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.storage.autocrafting.AutoCraftSystem;
import com.denfop.api.storage.autocrafting.AutoCraftSystemVisual;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.blockentity.storage.BlockEntityMonitor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketAddAutoCraft
implements IPacket {
    public PacketAddAutoCraft() {
    }

    public PacketAddAutoCraft(Player player, BlockPos pos, SameStack stack) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, player.m_20148_());
            EncoderHandler.encode(customPacketBuffer, pos);
            EncoderHandler.encode(customPacketBuffer, stack.writeToNBT());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 120;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_36316_().getId().equals(uuid) && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof BlockEntityMonitor) {
                BlockEntityMonitor controller = (BlockEntityMonitor)blockEntity;
                if (controller.network != null) {
                    SameStack stack = SameStack.readFromNBT((CompoundTag)DecoderHandler.decode(customPacketBuffer));
                    AutoCraftSystemVisual visual = controller.network.createAutoCraftVisual(stack);
                    AutoCraftSystem autocraft = controller.network.createAutoCraft(visual);
                    controller.network.addAutoCraft(autocraft);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

