/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.FriendlyByteBuf;

public class CustomPacketBuffer
extends FriendlyByteBuf {
    private static final Charset utf8 = StandardCharsets.UTF_8;

    public CustomPacketBuffer(ByteBuf wrapped) {
        super(wrapped);
    }

    public CustomPacketBuffer(int size) {
        super(Unpooled.buffer().capacity(size));
    }

    public CustomPacketBuffer(byte[] data) {
        this();
        this.writeBytes(data);
    }

    public CustomPacketBuffer() {
        super(Unpooled.buffer());
    }

    public CustomPacketBuffer writeString(String s) {
        byte[] bytes = s.getBytes(utf8);
        this.m_130130_(bytes.length);
        this.writeBytes(bytes);
        return this;
    }

    public String readString() {
        int len = this.m_130242_();
        byte[] bytes = new byte[len];
        this.readBytes(bytes);
        return new String(bytes, utf8);
    }

    public void flip() {
        this.readerIndex(0);
    }

    public ByteBuf toByteBuf() {
        int len = this.writerIndex() - this.readerIndex();
        if (len <= 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((byte[])this.array(), (int)this.readerIndex(), (int)len);
    }
}

