/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.network.NetworkManager;
import com.denfop.network.WorldData;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@OnlyIn(value=Dist.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    @Override
    public void sendPacket(CustomPacketBuffer buffer) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            this.sendPacket(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20186_(), Minecraft.m_91087_().f_91074_.m_20189_(), 2.0, Minecraft.m_91087_().f_91074_.m_9236_().m_46472_())), buffer);
            return;
        }
        UUID playerUUID = IUCore.proxy.getPlayerInstance().m_20148_();
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerUUID);
        this.sendPacket(PacketDistributor.PLAYER.with(() -> serverPlayer), buffer);
    }

    @Override
    public void sendPacket(PacketDistributor.PacketTarget packetDistributor, CustomPacketBuffer buffer) {
        Minecraft.m_91087_().m_91403_().m_104955_(this.makePacket(NetworkDirection.PLAY_TO_SERVER, buffer));
    }

    @Override
    public void onPacketData(CustomPacketBuffer is, byte type) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        IPacket packet = (IPacket)packetMap.get(type);
        if (packet != null && packet.getPacketType() == EnumTypePacket.SERVER) {
            packet.readPacket(is, (Player)player);
        }
    }

    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    public void onTickEnd(WorldData worldData) {
    }
}

