/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.base.IManufacturerBlock;
import com.denfop.componets.AbstractComponent;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.sound.EnumSound;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPurifier
extends BaseEnergyItem
implements UpgradeItem {
    public ItemPurifier(double maxCharge, double transferLimit, int tier) {
        super(maxCharge, transferLimit, 1);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, EnumUpgrades.PURIFIER.list));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237113_((String)Localization.translate("iu.purifier.info")));
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.PURIFIER.list;
    }

    public void m_6883_(ItemStack itemStack, Level p_77663_2_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(itemStack, p_77663_2_, p_41406_, p_41407_, p_41408_);
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Object base;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Direction side = context.m_43719_();
        ItemStack itemstack = context.m_43722_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof BlockEntityInventory) && !(tile instanceof IManufacturerBlock)) {
            return InteractionResult.PASS;
        }
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, itemstack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)itemstack).number * 0.25 : 0.0);
        if (tile instanceof BlockEntityBase) {
            base = (BlockEntityBase)tile;
            double energy = 10000.0;
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, itemstack)) {
                energy = 0.0;
            }
            if (!((BlockEntityBase)((Object)base)).canEntityDestroy((Entity)player)) {
                return InteractionResult.FAIL;
            }
            for (AbstractComponent component : ((BlockEntityBase)((Object)base)).getComponentList()) {
                if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(itemstack, energy * coef)) continue;
                component.workPurifier();
                return InteractionResult.SUCCESS;
            }
        }
        if (tile instanceof BlockEntityMultiMachine) {
            base = (BlockEntityMultiMachine)tile;
            if (!ElectricItem.manager.canUse(itemstack, 500.0 * coef)) {
                return InteractionResult.PASS;
            }
            if (!player.m_6047_()) {
                ItemStack stack_quickly = ItemStack.f_41583_;
                ItemStack stack_modulesize = ItemStack.f_41583_;
                ItemStack stack_modulestorage = ItemStack.f_41583_;
                ItemStack panel = ItemStack.f_41583_;
                ItemStack module_infinity_water = ItemStack.f_41583_;
                ItemStack module_separate = ItemStack.f_41583_;
                if (((BlockEntityMultiMachine)base).multi_process.quickly) {
                    stack_quickly = new ItemStack((ItemLike)IUItem.module_quickly.getItem());
                }
                if (((BlockEntityMultiMachine)base).multi_process.modulesize) {
                    stack_modulesize = new ItemStack((ItemLike)IUItem.module_stack.getItem());
                }
                if (((BlockEntityMultiMachine)base).multi_process.modulestorage) {
                    stack_modulestorage = new ItemStack((ItemLike)IUItem.module_storage.getItem());
                }
                if (((BlockEntityMultiMachine)base).multi_process.modulestorage) {
                    module_infinity_water = new ItemStack((ItemLike)IUItem.module_infinity_water.getItem());
                }
                if (((BlockEntityMultiMachine)base).multi_process.module_separate) {
                    module_separate = new ItemStack((ItemLike)IUItem.module_separate.getItem());
                }
                if (((BlockEntityMultiMachine)base).solartype != null) {
                    panel = new ItemStack((ItemLike)IUItem.module6.getStack(((BlockEntityMultiMachine)base).solartype.meta), 1);
                }
                if (!(stack_quickly.m_41619_() && stack_modulesize.m_41619_() && panel.m_41619_() && module_infinity_water.m_41619_() && module_separate.m_41619_())) {
                    ItemEntity item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), ItemStack.f_41583_);
                    if (!stack_quickly.m_41619_()) {
                        item.m_32045_(stack_quickly);
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                        ((BlockEntityMultiMachine)base).multi_process.setQuickly(false);
                    } else if (!stack_modulesize.m_41619_()) {
                        item.m_32045_(stack_modulesize);
                        ((BlockEntityMultiMachine)base).multi_process.setModulesize(false);
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    } else if (!module_infinity_water.m_41619_()) {
                        item.m_32045_(module_infinity_water);
                        ((BlockEntityMultiMachine)base).multi_process.module_infinity_water = false;
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    } else if (!module_separate.m_41619_()) {
                        item.m_32045_(module_separate);
                        ((BlockEntityMultiMachine)base).multi_process.module_separate = false;
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    } else if (!panel.m_41619_()) {
                        item.m_32045_(panel);
                        ((BlockEntityMultiMachine)base).solartype = null;
                    } else if (!stack_modulestorage.m_41619_()) {
                        item.m_32045_(stack_modulestorage);
                        ((BlockEntityMultiMachine)base).multi_process.setModulestorage(false);
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (!player.m_150109_().m_7983_()) {
                        item.m_32010_(0);
                        world.m_7967_((Entity)item);
                        ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
                        if (player.m_9236_().f_46443_) {
                            player.m_5496_(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                ArrayList<ItemStack> stack_list = new ArrayList<ItemStack>();
                if (((BlockEntityMultiMachine)base).multi_process.quickly) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_quickly.getItem()));
                    ((BlockEntityMultiMachine)base).multi_process.setQuickly(false);
                    ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((BlockEntityMultiMachine)base).multi_process.modulesize) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_stack.getItem()));
                    ((BlockEntityMultiMachine)base).multi_process.setModulesize(false);
                    ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((BlockEntityMultiMachine)base).solartype != null) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module6.getStack(((BlockEntityMultiMachine)base).solartype.meta), 1));
                    ((BlockEntityMultiMachine)base).solartype = null;
                }
                if (((BlockEntityMultiMachine)base).multi_process.modulestorage) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_storage.getItem()));
                    ((BlockEntityMultiMachine)base).multi_process.setModulestorage(false);
                    ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((BlockEntityMultiMachine)base).multi_process.module_infinity_water) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()));
                    ((BlockEntityMultiMachine)base).multi_process.module_infinity_water = false;
                    ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((BlockEntityMultiMachine)base).multi_process.module_separate) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_separate.getItem()));
                    ((BlockEntityMultiMachine)base).multi_process.module_separate = false;
                    ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                }
                for (ItemStack stack : stack_list) {
                    ItemEntity item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                    if (!player.m_9236_().f_46443_) {
                        item.m_32010_(0);
                        world.m_7967_((Entity)item);
                    }
                    if (!player.m_9236_().f_46443_) continue;
                    player.m_5496_(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                }
                ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof IManufacturerBlock) {
            base = (IManufacturerBlock)tile;
            if (player.m_6047_()) {
                this.dropUpgrade(world, player, (IManufacturerBlock)base);
            } else {
                this.dropSingleUpgrade(world, player, (IManufacturerBlock)base);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void dropUpgrade(Level world, Player player, IManufacturerBlock base) {
        int level = base.getLevelMechanism();
        if (level > 0) {
            this.dropItem(world, player, new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), level));
            base.setLevelMech(0);
        }
    }

    private void dropSingleUpgrade(Level world, Player player, IManufacturerBlock base) {
        if (base.getLevelMechanism() > 0) {
            this.dropItem(world, player, new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), 1));
            base.removeLevel(1);
        }
    }

    private void dropItem(Level world, Player player, ItemStack stack) {
        if (!stack.m_41619_() && !world.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
            itemEntity.m_32010_(0);
            world.m_7967_((Entity)itemEntity);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

