/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.book;

import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.GuideTab;
import com.denfop.api.guidebook.Lines;
import com.denfop.api.guidebook.Quest;
import com.denfop.api.guidebook.Shape;
import com.denfop.api.widget.ItemWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.items.book.ContainerMenuBook;
import com.denfop.items.book.GuideQuest;
import com.denfop.items.book.ItemStackBook;
import com.denfop.network.packet.PacketItemStackEvent;
import com.denfop.network.packet.PacketUpdateBookMarks;
import com.denfop.screen.ScreenMain;
import com.denfop.screen.ScreenResearchTableSpace;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBook<T extends ContainerMenuBook>
extends ScreenMain<ContainerMenuBook> {
    public static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guidebook.png");
    public static final ResourceLocation sprites = new ResourceLocation("industrialupgrade", "textures/gui/sprites.png");
    public static final ResourceLocation sprites_lines = new ResourceLocation("industrialupgrade", "textures/gui/slider_guide.png");
    public static final ResourceLocation background1 = new ResourceLocation("industrialupgrade", "textures/gui/guidebook1.png");
    private final Player player;
    public int tab = 0;
    List<Quest> questList = new ArrayList<Quest>();
    LinkedList<GuideQuest> guideQuests = new LinkedList();
    List<Tuple<Integer, Integer>> listBookMark = new LinkedList<Tuple<Integer, Integer>>();
    boolean reset = false;
    private Map<String, List<String>> map;
    private boolean hoverDiscord = false;
    private boolean hoverGithub = false;
    private boolean hoverPU = false;
    private boolean hoverQG = false;
    private boolean hoverSQ = false;
    private boolean bookMark = false;
    private boolean hoverWiki = false;
    private boolean hoverYoutube = false;
    private boolean hoverDeveloper = false;
    private int[] bookMarksSize = new int[2];
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean isDragging = false;
    private boolean isDragging1 = false;
    private int lastMouseX;
    private int lastMouseY;

    public ScreenBook(Player player, ItemStack itemStack1, ContainerMenuBook containerBook) {
        super(containerBook);
        this.player = player;
        this.f_97726_ = 345;
        this.f_97727_ = 195;
        this.elements.clear();
        this.componentList.clear();
        CompoundTag nbt = ModUtils.nbt(((ItemStackBook)((ContainerMenuBook)this.container).base).itemStack1);
        if (nbt.m_128441_("book_info")) {
            int[] decode = ScreenBook.decode(nbt.m_128451_("book_info"));
            this.tab = decode[0];
            this.offsetX = decode[1];
            this.offsetY = decode[2];
        }
        ListTag bookMark = nbt.m_128437_("bookMark", 10);
        for (int i = 0; i < bookMark.size(); ++i) {
            CompoundTag nbt1 = bookMark.m_128728_(i);
            this.listBookMark.add((Tuple<Integer, Integer>)new Tuple((Object)nbt1.m_128451_("tab"), (Object)nbt1.m_128451_("id")));
        }
        this.bookMarksSize = this.calculateGrid(this.listBookMark.size());
        this.questList = GuideBookCore.instance.getQuests(this.tab);
    }

    public static int encode(int tab, int offsetX, int offsetY) {
        if (tab < 0 || tab > 7) {
            throw new IllegalArgumentException("tab out of range: " + tab);
        }
        if (offsetX < -8192 || offsetX > 8191) {
            throw new IllegalArgumentException("offsetX out of range: " + offsetX);
        }
        if (offsetY < -8192 || offsetY > 8191) {
            throw new IllegalArgumentException("offsetY out of range: " + offsetY);
        }
        int x = offsetX & 0x3FFF;
        int y = offsetY & 0x3FFF;
        return y << 17 | x << 3 | tab & 7;
    }

    public static int[] decode(int value) {
        int tab = value & 7;
        int x = value >>> 3 & 0x3FFF;
        int y = value >>> 17 & 0x3FFF;
        if ((x & 0x2000) != 0) {
            x |= 0xFFFFC000;
        }
        if ((y & 0x2000) != 0) {
            y |= 0xFFFFC000;
        }
        return new int[]{tab, x, y};
    }

    public void addBookMark(int tab, int id) {
        this.listBookMark.add((Tuple<Integer, Integer>)new Tuple((Object)tab, (Object)id));
        CompoundTag nbt = ModUtils.nbt(((ItemStackBook)((ContainerMenuBook)this.container).base).itemStack1);
        ListTag bookMark = new ListTag();
        this.listBookMark.forEach(tuple -> {
            CompoundTag nbt1 = new CompoundTag();
            nbt1.m_128405_("tab", ((Integer)tuple.m_14418_()).intValue());
            nbt1.m_128405_("id", ((Integer)tuple.m_14419_()).intValue());
            bookMark.add((Object)nbt1);
        });
        nbt.m_128365_("bookMark", (Tag)bookMark);
        this.bookMarksSize = this.calculateGrid(this.listBookMark.size());
        new PacketUpdateBookMarks(nbt, this.player);
    }

    public void removeBookMark(int tab, int id) {
        this.listBookMark.removeIf(bookMark -> (Integer)bookMark.m_14418_() == tab && (Integer)bookMark.m_14419_() == id);
        CompoundTag nbt = ModUtils.nbt(((ItemStackBook)((ContainerMenuBook)this.container).base).itemStack1);
        ListTag bookMark2 = new ListTag();
        this.listBookMark.forEach(tuple -> {
            CompoundTag nbt1 = new CompoundTag();
            nbt1.m_128405_("tab", ((Integer)tuple.m_14418_()).intValue());
            nbt1.m_128405_("id", ((Integer)tuple.m_14419_()).intValue());
            bookMark2.add((Object)nbt1);
        });
        nbt.m_128365_("bookMark", (Tag)bookMark2);
        new PacketUpdateBookMarks(nbt, this.player);
        this.bookMarksSize = this.calculateGrid(this.listBookMark.size());
    }

    public boolean hasBookMark(int tab, int id) {
        for (Tuple<Integer, Integer> tuple : this.listBookMark) {
            if ((Integer)tuple.m_14418_() != tab || (Integer)tuple.m_14419_() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public void changeParams() {
        super.changeParams();
        this.f_97727_ = 4000;
        this.f_97726_ = 9000;
    }

    public void m_280273_(GuiGraphics pGuiGraphics) {
        if (this.f_96541_.f_91073_ != null) {
            pGuiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            this.m_280039_(pGuiGraphics);
        }
    }

    @Override
    public void m_88315_(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.f_97726_ = 255;
        this.f_97727_ = 195;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        super.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.map = GuideBookCore.uuidGuideMap.get(this.player.m_20148_());
        if (this.reset) {
            this.questList = GuideBookCore.instance.getQuests(this.tab);
            this.offsetX = 0;
            this.offsetY = 0;
            this.lastMouseX = 0;
            this.lastMouseY = 0;
            this.reset = false;
            this.guideQuests.clear();
            new PacketItemStackEvent(ScreenBook.encode(this.tab, this.offsetX, this.offsetY), (Player)this.f_96541_.f_91074_);
            ModUtils.nbt(((ItemStackBook)((ContainerMenuBook)this.container).base).itemStack1).m_128405_("book_info", ScreenBook.encode(this.tab, this.offsetX, this.offsetY));
        }
    }

    public int[] calculateGrid(int count) {
        int bestRows = 1;
        int bestCols = count;
        int bestDiff = Integer.MAX_VALUE;
        for (int rows = 1; rows <= count; ++rows) {
            int cols = (int)Math.ceil((double)count / (double)rows);
            int diff = Math.abs(rows - cols);
            if (rows * cols < count || diff >= bestDiff) continue;
            bestRows = rows;
            bestCols = cols;
            bestDiff = diff;
        }
        return new int[]{bestRows, bestCols};
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        poseStack.m_280218_(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        this.f_97726_ = 255;
        this.f_97727_ = 195;
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = i - xMin;
        int y = j - yMin;
        int y1 = 5;
        if (this.map == null) {
            return;
        }
        for (GuideQuest guideQuest2 : new ArrayList<GuideQuest>(this.guideQuests)) {
            if (!guideQuest2.is(x, y)) continue;
            if (guideQuest2.isRemove(x, y)) {
                this.guideQuests.remove(guideQuest2);
            } else if (guideQuest2.isComplete(this.player, this.tab)) {
                guideQuest2.complete(this.player, this.tab);
            } else if (guideQuest2.isSkip(this.player, this.tab)) {
                guideQuest2.skip(this.player, this.tab);
            } else if (guideQuest2.isBookMark(this.player, this.tab)) {
                guideQuest2.bookMark(this, this.tab);
            }
            return;
        }
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        for (int index = 0; index < guideTabs.size(); ++index) {
            if (index != this.tab) {
                GuideTab guideTab = guideTabs.get(index);
                int dx = -28;
                int u = 5;
                int v = 28;
                int w = 28;
                if (x >= dx && y >= y1 && x <= w + dx && y <= y1 + 27) {
                    this.tab = index;
                    this.reset = true;
                    this.bookMark = false;
                    return;
                }
            }
            y1 += 27;
        }
        if (!this.bookMark) {
            int dx = 255;
            int u = 5;
            int v = 28;
            int w = 28;
            y1 = 5;
            if (x >= dx && y >= y1 && x <= w + dx && y <= y1 + 27) {
                this.bookMark = true;
                this.reset = true;
                this.tab = 0;
                return;
            }
        }
        if (this.hoverDiscord) {
            try {
                Util.m_137581_().m_137648_(new URI("https://discord.com/invite/fqQPH6HKJV"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverGithub) {
            try {
                Util.m_137581_().m_137648_(new URI("https://github.com/ZelGimi/industrialupgrade"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverWiki) {
            try {
                Util.m_137581_().m_137648_(new URI("https://zelgimi.github.io/industrialupgrade/docs/intro"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverDeveloper) {
            try {
                Util.m_137581_().m_137648_(new URI("https://zelgimi.github.io/industrialupgrade/docs/kubejs/"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverYoutube) {
            try {
                Util.m_137581_().m_137648_(new URI("https://www.youtube.com/watch?v=iyCaNkGM77k&list=PLHDBETKnEsdwcMxHDxI75eYkuthlqIjox&index=2"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverPU) {
            try {
                Util.m_137581_().m_137648_(new URI("https://www.curseforge.com/minecraft/mc-mods/power-utilities-iu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverSQ) {
            try {
                Util.m_137581_().m_137648_(new URI("https://www.curseforge.com/minecraft/mc-mods/simply-quarries"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverQG) {
            try {
                Util.m_137581_().m_137648_(new URI("https://www.curseforge.com/minecraft/mc-mods//quantum-generators"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.bookMark) {
            GuideTab guideTab = guideTabs.get(this.tab);
            List<String> quests = this.map.get(guideTab.unLocalized);
            int jj = 0;
            for (Quest quest : GuideBookCore.instance.getQuests(this.tab)) {
                boolean isUnlocked;
                int texW;
                int centerX = 116 + this.offsetX;
                int centerY = 73 + this.offsetY;
                int xOffset = centerX + quest.x + (quest.shape == Shape.EPIC ? 2 : 3);
                int yOffset = centerY + quest.y + (quest.shape == Shape.EPIC ? 2 : 3);
                int texH = texW = quest.shape == Shape.EPIC ? 26 : 24;
                boolean hasPrev = quest.hasPrev;
                boolean bl = isUnlocked = hasPrev ? quests.contains(quest.prevName) : false;
                if (xOffset >= 8 && xOffset + texW <= 246 && yOffset >= 9 && yOffset + texH <= 185 && x >= xOffset && x <= xOffset + texW && y >= yOffset && y <= yOffset + texH) {
                    if (this.guideQuests.contains(new GuideQuest(quest, this.tab, jj))) {
                        this.guideQuests.removeIf(guideQuest -> guideQuest.getQuest().equals(quest));
                    } else if (this.guideQuests.size() <= 1) {
                        this.guideQuests.add(new GuideQuest(quest, ((ItemStackBook)((ContainerMenuBook)this.container).base).player, isUnlocked, this.tab, jj));
                    }
                }
                ++jj;
            }
        } else {
            int centerX = 116 + this.offsetX;
            int centerY = 73 + this.offsetY;
            for (int ii = 0; ii < this.listBookMark.size(); ++ii) {
                boolean isUnlocked;
                int texW;
                int row = ii / this.bookMarksSize[0];
                int col = ii % this.bookMarksSize[1];
                int x1 = centerX + col * 25;
                y1 = centerY + row * 25;
                Tuple<Integer, Integer> tuple = this.listBookMark.get(ii);
                Quest quest = GuideBookCore.instance.getQuests((Integer)tuple.m_14418_()).get((Integer)tuple.m_14419_());
                int xOffset = x1 + (quest.shape == Shape.EPIC ? 2 : 3);
                int yOffset = y1 + (quest.shape == Shape.EPIC ? 2 : 3);
                int texH = texW = quest.shape == Shape.EPIC ? 26 : 24;
                GuideTab guideTab = guideTabs.get((Integer)tuple.m_14418_());
                List<String> quests = this.map.get(guideTab.unLocalized);
                boolean hasPrev = quest.hasPrev;
                boolean bl = isUnlocked = hasPrev ? quests.contains(quest.prevName) : false;
                if (xOffset < 8 || xOffset + texW > 246 || yOffset < 9 || yOffset + texH > 185 || x < xOffset || x > xOffset + texW || y < yOffset || y > yOffset + texH) continue;
                if (this.guideQuests.contains(new GuideQuest(quest, (Integer)tuple.m_14418_(), (Integer)tuple.m_14419_()))) {
                    this.guideQuests.removeIf(guideQuest -> guideQuest.getQuest().equals(quest));
                    continue;
                }
                if (this.guideQuests.size() > 1) continue;
                this.guideQuests.add(new GuideQuest(quest, ((ItemStackBook)((ContainerMenuBook)this.container).base).player, isUnlocked, (Integer)tuple.m_14418_(), (Integer)tuple.m_14419_()));
            }
        }
    }

    @Override
    public void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        block15: {
            int centerY;
            int centerX;
            block14: {
                super.drawForegroundLayer(poseStack, par1, par2);
                for (GuideQuest guideQuest : this.guideQuests) {
                    if (!guideQuest.is(par1, par2)) continue;
                    guideQuest.drawForegroundLayer(this, poseStack, par1, par2);
                    return;
                }
                new TooltipWidget(this, 255, 5, 30, 27).withTooltip(Localization.translate("iu.quest.bookmark")).drawForeground(poseStack, par1, par2);
                List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
                int y = 5;
                for (int index = 0; index < guideTabs.size(); ++index) {
                    boolean isSelectedTab;
                    GuideTab guideTab = guideTabs.get(index);
                    int dx = -28;
                    int w = 28;
                    boolean bl = isSelectedTab = index == this.tab;
                    if (isSelectedTab) {
                        new TooltipWidget(this, -33, y, 33, 27).withTooltip(Localization.translate(guideTab.name)).drawForeground(poseStack, par1, par2);
                    } else {
                        new TooltipWidget(this, dx, y, w, 27).withTooltip(Localization.translate(guideTab.name)).drawForeground(poseStack, par1, par2);
                    }
                    y += 27;
                }
                this.hoverDiscord = false;
                this.hoverGithub = false;
                this.hoverPU = false;
                this.hoverQG = false;
                this.hoverSQ = false;
                this.hoverDeveloper = false;
                this.hoverYoutube = false;
                this.hoverWiki = false;
                if (par1 >= 255 && par1 <= 285 && par2 >= 35 && par2 <= 62) {
                    this.hoverWiki = true;
                }
                if (par1 >= 255 && par1 <= 285 && par2 >= 65 && par2 <= 92) {
                    this.hoverDeveloper = true;
                }
                new TooltipWidget(this, 255, 65, 30, 27).withTooltip(Localization.translate("iu.quest.developer")).drawForeground(poseStack, par1, par2);
                new TooltipWidget(this, 255, 35, 30, 27).withTooltip(Localization.translate("iu.quest.wiki")).drawForeground(poseStack, par1, par2);
                if (par1 >= 10 && par1 <= 37 && par2 >= -15 && par2 <= 2) {
                    this.hoverDiscord = true;
                }
                if (par1 >= 50 && par1 <= 77 && par2 >= -15 && par2 <= 2) {
                    this.hoverGithub = true;
                }
                new TooltipWidget(this, 90, -15, 27, 17).withTooltip(Localization.translate("iu.quest.youtube")).drawForeground(poseStack, par1, par2);
                if (par1 >= 90 && par1 <= 117 && par2 >= -15 && par2 <= 2) {
                    this.hoverYoutube = true;
                }
                if (par1 >= 150 && par1 <= 177 && par2 >= -15 && par2 <= 2) {
                    this.hoverPU = true;
                }
                if (par1 >= 180 && par1 <= 207 && par2 >= -15 && par2 <= 2) {
                    this.hoverQG = true;
                }
                if (par1 >= 210 && par1 <= 237 && par2 >= -15 && par2 <= 2) {
                    this.hoverSQ = true;
                }
                centerX = 116 + this.offsetX;
                centerY = 73 + this.offsetY;
                if (this.bookMark) break block14;
                GuideTab guideTab = guideTabs.get(this.tab);
                if (this.map == null) break block15;
                List<String> quests = this.map.get(guideTab.unLocalized);
                if (par1 < 8 || par2 < 9 || par1 > 247 || par2 > 185) break block15;
                for (Quest quest : GuideBookCore.instance.getQuests(this.tab)) {
                    ScreenBook.bindTexture(sprites);
                    int texW = quest.shape == Shape.EPIC ? 26 : 24;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    new TooltipWidget(this, centerX + quest.x, centerY + quest.y, texW, texW).withTooltip(quest.getLocalizedName()).drawForeground(poseStack, par1, par2);
                }
                break block15;
            }
            for (int i = 0; i < this.listBookMark.size(); ++i) {
                int row = i / this.bookMarksSize[0];
                int col = i % this.bookMarksSize[1];
                int x1 = centerX + col * 25;
                int y1 = centerY + row * 25;
                Tuple<Integer, Integer> tuple = this.listBookMark.get(i);
                Quest quest = GuideBookCore.instance.getQuests((Integer)tuple.m_14418_()).get((Integer)tuple.m_14419_());
                int texW = quest.shape == Shape.EPIC ? 26 : 24;
                new TooltipWidget(this, x1, y1, texW, texW).withTooltip(quest.getLocalizedName()).drawForeground(poseStack, par1, par2);
            }
        }
    }

    private void draw(int mouseX, int mouseY, int x, int x1, String text) {
        if (mouseX >= x && mouseX < x1 && mouseY >= 180 && mouseY < 190) {
            this.drawTooltip(mouseX, mouseY, Collections.singletonList(Localization.translate(text)));
        }
    }

    public void renderLines(GuiGraphics poseStack, Quest current, Lines lines) {
        boolean firstHorizontal;
        int centerX = 116;
        int centerY = 73;
        int x = current.x + 3;
        int y = current.y + 3;
        int prevX = current.prevX + 3;
        int prevY = current.prevY + 3;
        Shape shape = current.shape;
        Shape prevShape = current.prevShape;
        int startPosRender = 24;
        int endPosRender = 24;
        switch (prevShape) {
            case DEFAULT: 
            case UNIQUE: {
                startPosRender = 24;
                break;
            }
            case EPIC: {
                startPosRender = 26;
            }
        }
        switch (shape) {
            case DEFAULT: 
            case UNIQUE: {
                endPosRender = 24;
                break;
            }
            case EPIC: {
                endPosRender = 26;
            }
        }
        int dx = Math.abs(prevX - x);
        int dy = Math.abs(prevY - y);
        if (prevY < 0 && y < 0) {
            dy = Math.abs(-prevY + y);
        }
        if (firstHorizontal = dx < dy) {
            if (prevX < x) {
                if (y > prevY) {
                    this.drawHorizontalLine(poseStack, prevX + startPosRender, prevY + startPosRender / 2 - 1, x + startPosRender / 2 + 1, prevY, lines);
                } else {
                    this.drawHorizontalLine(poseStack, prevX + startPosRender, prevY + startPosRender / 2 - 1, x + startPosRender / 2 + 1, prevY, lines);
                }
                if (y - 1 > 0) {
                    this.drawVerticalLine(poseStack, x + startPosRender / 2 - 1, prevY + startPosRender / 2, x, y, lines);
                } else {
                    this.drawVerticalLine(poseStack, x + startPosRender / 2 - 1, y + startPosRender, x, prevY + startPosRender / 2, lines);
                }
            } else {
                this.drawHorizontalLine(poseStack, x + startPosRender, prevY + startPosRender / 2 - 1, prevX + startPosRender / 2 + 1, prevY, lines);
                if (y > prevY) {
                    if (y - 1 > 0) {
                        this.drawVerticalLine(poseStack, x + startPosRender / 2 - 1, prevY + startPosRender, x, y, lines);
                    } else {
                        this.drawVerticalLine(poseStack, x + startPosRender / 2 - 1, y + startPosRender, x, prevY + startPosRender / 2, lines);
                    }
                } else if (y - 1 > 0) {
                    this.drawVerticalLine(poseStack, x + startPosRender / 2 - 1, y + startPosRender, x, prevY, lines);
                } else {
                    this.drawVerticalLine(poseStack, x + startPosRender / 2 - 1, y + startPosRender, x, prevY, lines);
                }
            }
        } else if (y - 1 > 0) {
            if (y > prevY) {
                this.drawVerticalLine(poseStack, prevX + startPosRender / 2 - 1, prevY + startPosRender, prevX + startPosRender, y + startPosRender / 2 + 1, lines);
                if (prevX < x) {
                    this.drawHorizontalLine(poseStack, prevX + startPosRender / 2, y + startPosRender / 2 - 1, x, y, lines);
                } else {
                    this.drawHorizontalLine(poseStack, x + startPosRender, y + startPosRender / 2 - 1, prevX + startPosRender / 2, y, lines);
                }
            } else {
                this.drawVerticalLine(poseStack, prevX + startPosRender / 2 - 1, y + startPosRender / 2 - 1, prevX + startPosRender, prevY, lines);
                if (prevX < x) {
                    this.drawHorizontalLine(poseStack, prevX + startPosRender, y + startPosRender / 2 - 1, x, y, lines);
                } else if (y == prevY) {
                    this.drawHorizontalLine(poseStack, x + startPosRender, y + startPosRender / 2 - 1, prevX, y, lines);
                } else {
                    this.drawHorizontalLine(poseStack, x + startPosRender, y + startPosRender / 2 - 1, prevX + startPosRender / 2, y, lines);
                }
            }
        } else if (prevY > 0 && y < 0 || prevY < 0 && y > 0) {
            this.drawVerticalLine(poseStack, prevX + startPosRender / 2 - 1, y + startPosRender / 2 - 1, prevX + startPosRender, prevY, lines);
            if (prevX < x) {
                this.drawHorizontalLine(poseStack, prevX + startPosRender / 2, y + startPosRender / 2 - 1, x, y, lines);
            } else {
                this.drawHorizontalLine(poseStack, x + startPosRender / 2, y + startPosRender / 2 - 1, prevX, y, lines);
            }
        } else {
            this.drawVerticalLine(poseStack, prevX + startPosRender / 2 - 1, prevY + startPosRender, prevX + startPosRender, y + startPosRender, lines);
            if (prevX < x) {
                this.drawHorizontalLine(poseStack, prevX + startPosRender, y + startPosRender / 2 - 1, x, y, lines);
            } else {
                this.drawHorizontalLine(poseStack, x + startPosRender, y + startPosRender / 2 - 1, prevX, y, lines);
            }
        }
    }

    public void drawHorizontalLine(GuiGraphics poseStack, int startX, int startY, int endX, int endY, Lines line) {
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        ScreenBook.bindTexture(sprites_lines);
        this.drawTexturedModalRect(poseStack, this.guiLeft + centerX + startX, this.guiTop + centerY + startY, line.getHX(), line.getHY(), endX - startX, 2);
    }

    public void drawVerticalLine(GuiGraphics poseStack, int startX, int startY, int endX, int endY, Lines line) {
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        ScreenBook.bindTexture(sprites_lines);
        this.drawTexturedModalRect(poseStack, this.guiLeft + centerX + startX, this.guiTop + centerY + startY, line.getVX(), line.getVY(), 2, endY - startY);
    }

    @Override
    public boolean m_6050_(double d, double d2, double d3) {
        ScrollDirection direction;
        super.m_6050_(d, d2, d3);
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : (direction = ScrollDirection.stopped);
        if (direction != ScrollDirection.stopped) {
            for (GuideQuest guideQuest : this.guideQuests) {
                if (!guideQuest.is(mouseX, mouseY)) continue;
                if (guideQuest.isTextFields(mouseX, mouseY) && guideQuest.canScroll(direction)) {
                    guideQuest.scroll(direction);
                    return true;
                }
                if (!guideQuest.isItems(mouseX, mouseY) || !guideQuest.canScrollItem(direction)) continue;
                guideQuest.scrollItem(direction);
                return true;
            }
        }
        return super.m_6050_(d, d2, d3);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        mouseX -= (double)this.f_97735_;
        mouseY -= (double)this.f_97736_;
        if (button == 0) {
            for (GuideQuest guideQuest : this.guideQuests) {
                if (!guideQuest.is((int)mouseX, (int)mouseY)) continue;
                if (!this.isDragging1) {
                    this.isDragging1 = true;
                } else {
                    int dx = (int)dragX;
                    int dy = (int)dragY;
                    guideQuest.setOffsetX1(guideQuest.getOffsetX1() + dx);
                    guideQuest.setOffsetY1(guideQuest.getOffsetY1() + dy);
                }
                return true;
            }
        } else {
            this.isDragging1 = false;
        }
        if (mouseX >= 8.0 && mouseY >= 9.0 && mouseX <= 246.0 && mouseY <= 185.0) {
            if (button == 0) {
                if (!this.isDragging) {
                    this.isDragging = true;
                } else {
                    int dx = (int)dragX;
                    int dy = (int)dragY;
                    this.offsetX += dx;
                    this.offsetY += dy;
                    new PacketItemStackEvent(ScreenBook.encode(this.tab, this.offsetX, this.offsetY), (Player)this.f_96541_.f_91074_);
                    ModUtils.nbt(((ItemStackBook)((ContainerMenuBook)this.container).base).itemStack1).m_128405_("book_info", ScreenBook.encode(this.tab, this.offsetX, this.offsetY));
                }
                return true;
            }
            this.isDragging = false;
        }
        return false;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        List<String> quests;
        String tabKey;
        GuideTab guideTab;
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.f_97726_ = 255;
        this.f_97727_ = 195;
        if (this.map == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
        ScreenBook.bindTexture(sprites);
        if (!this.hoverDiscord) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 10, this.guiTop - 15, 202, 7, 27, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 10, this.guiTop - 15 - 6, 229, 1, 27, 22);
        }
        if (!this.hoverGithub) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 50, this.guiTop - 15, 202, 29, 27, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 50, this.guiTop - 15 - 6, 229, 23, 27, 22);
        }
        if (!this.hoverYoutube) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 90, this.guiTop - 15, 202, 117, 27, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 90, this.guiTop - 15 - 6, 229, 111, 27, 22);
        }
        if (!this.hoverPU) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 150, this.guiTop - 15, 202, 51, 27, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 150, this.guiTop - 15 - 6, 229, 45, 27, 22);
        }
        if (!this.hoverQG) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 180, this.guiTop - 15, 202, 73, 27, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 180, this.guiTop - 15 - 6, 229, 67, 27, 22);
        }
        if (!this.hoverSQ) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 210, this.guiTop - 15, 202, 95, 27, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 210, this.guiTop - 15 - 6, 229, 89, 27, 22);
        }
        int x1 = mouseX - this.guiLeft;
        int y1 = mouseY - this.guiTop;
        int y = 5;
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        for (int i = 0; i < guideTabs.size(); ++i) {
            guideTab = guideTabs.get(i);
            tabKey = guideTab.getUnLocalized();
            quests = this.map.get(tabKey);
            boolean isSelectedTab = i == this.tab;
            boolean hasQuests = !quests.isEmpty();
            ScreenBook.bindTexture(sprites);
            if (isSelectedTab) {
                this.drawTexturedModalRect(poseStack, this.guiLeft - 33, this.guiTop + y, 0, hasQuests ? 0 : 56, 33, 27);
                new ItemWidget(this, -24, y + 6, (Supplier<ItemStack>)((Supplier)() -> guideTab.icon)).drawBackground(poseStack, this.guiLeft, this.guiTop);
                ScreenResearchTableSpace.enableScissor(this.guiLeft + 8, this.guiTop + 9, this.guiLeft + 8 + 238, this.guiTop + 9 + 176);
                if (!this.bookMark) {
                    for (Quest quest : GuideBookCore.instance.getQuests(i)) {
                        int texW;
                        ScreenBook.bindTexture(sprites);
                        boolean hasPrev = quest.hasPrev;
                        boolean isUnlocked = hasPrev ? quests.contains(quest.prevName) : quests.contains(quest.unLocalizedName);
                        int xOffset = this.guiLeft + centerX + quest.x + (quest.shape == Shape.EPIC ? 2 : 3);
                        int yOffset = this.guiTop + centerY + quest.y + (quest.shape == Shape.EPIC ? 2 : 3);
                        int texX = 0;
                        int texY = 0;
                        int texH = texW = quest.shape == Shape.EPIC ? 26 : 24;
                        if (hasPrev) {
                            int n = texY = isUnlocked ? 28 : 1;
                            if (!quests.contains(quest.unLocalizedName)) {
                                texY = 57;
                            }
                        } else {
                            texY = isUnlocked ? 1 : 57;
                        }
                        switch (quest.shape) {
                            case DEFAULT: {
                                texX = 36;
                                break;
                            }
                            case UNIQUE: {
                                texX = 61;
                                break;
                            }
                            case EPIC: {
                                texX = 86;
                            }
                        }
                        this.drawTexturedModalRect(poseStack, xOffset, yOffset, texX, texY, texW, texH);
                        if (hasPrev) {
                            ScreenBook.bindTexture(sprites_lines);
                            this.renderLines(poseStack, quest, this.getLine(quest, quests, guideTab));
                        }
                        new ItemWidget(this, centerX + quest.x + 7, centerY + quest.y + 7, (Supplier<ItemStack>)((Supplier)() -> quest.icon)).drawBackground(poseStack, this.guiLeft, this.guiTop);
                    }
                }
                RenderSystem.disableScissor();
            } else {
                int dx = hasQuests ? -28 : -33;
                int u = hasQuests ? 5 : 0;
                int v = hasQuests ? 28 : 56;
                int w = hasQuests ? 28 : 33;
                this.drawTexturedModalRect(poseStack, this.guiLeft + dx, this.guiTop + y, u, v, w, 27);
                new ItemWidget(this, dx + 8, y + 6, (Supplier<ItemStack>)((Supplier)() -> guideTab.icon)).drawBackground(poseStack, this.guiLeft, this.guiTop);
            }
            y += 27;
        }
        ScreenBook.bindTexture(sprites);
        this.drawTexturedModalRect(poseStack, this.guiLeft + 255, this.guiTop + 5, 140, 1, 26, 27);
        if (this.bookMark) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 255, this.guiTop + 5, 171, 1, 30, 27);
        }
        this.drawTexturedModalRect(poseStack, this.guiLeft + 255, this.guiTop + 35, 140, 57, 26, 27);
        if (this.hoverWiki) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 255, this.guiTop + 35, 171, 57, 30, 27);
        }
        this.drawTexturedModalRect(poseStack, this.guiLeft + 255, this.guiTop + 65, 140, 85, 30, 27);
        if (this.hoverDeveloper) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 255, this.guiTop + 65, 171, 85, 30, 27);
        }
        PoseStack posestack = RenderSystem.getModelViewStack();
        if (this.map != null) {
            guideTab = guideTabs.get(this.tab);
            tabKey = guideTab.getUnLocalized();
            quests = this.map.get(tabKey);
            for (GuideQuest guideQuest : this.guideQuests) {
                poseStack.m_280168_().m_85836_();
                poseStack.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
                posestack.m_252880_(0.0f, 0.0f, 300.0f);
                guideQuest.drawBackgroundLayer(this, poseStack, this.guiLeft, this.guiTop, !quests.contains(guideQuest.getQuest().unLocalizedName));
                poseStack.m_280168_().m_85849_();
            }
        }
        if (this.bookMark) {
            ScreenResearchTableSpace.enableScissor(this.guiLeft + 8, this.guiTop + 9, this.guiLeft + 8 + 238, this.guiTop + 9 + 176);
            for (int i = 0; i < this.listBookMark.size(); ++i) {
                int texW;
                int row = i / this.bookMarksSize[0];
                int col = i % this.bookMarksSize[1];
                x1 = this.guiLeft + centerX + col * 25;
                y1 = this.guiTop + centerY + row * 25;
                ScreenBook.bindTexture(sprites);
                Tuple<Integer, Integer> tuple = this.listBookMark.get(i);
                Quest quest = GuideBookCore.instance.getQuests((Integer)tuple.m_14418_()).get((Integer)tuple.m_14419_());
                boolean hasPrev = quest.hasPrev;
                List<String> quests2 = this.map.get(GuideBookCore.instance.getGuideTabs().get((int)((Integer)tuple.m_14418_()).intValue()).unLocalized);
                boolean isUnlocked = hasPrev ? quests2.contains(quest.prevName) : quests2.contains(quest.unLocalizedName);
                int texX = 0;
                int texY = 0;
                int texH = texW = quest.shape == Shape.EPIC ? 26 : 24;
                if (hasPrev) {
                    int n = texY = isUnlocked ? 28 : 1;
                    if (!quests2.contains(quest.unLocalizedName)) {
                        texY = 57;
                    }
                } else {
                    texY = isUnlocked ? 1 : 57;
                }
                texX = switch (quest.shape) {
                    default -> throw new IncompatibleClassChangeError();
                    case Shape.DEFAULT -> 36;
                    case Shape.UNIQUE -> 61;
                    case Shape.EPIC -> 86;
                };
                this.drawTexturedModalRect(poseStack, x1, y1, texX, texY, texW, texH);
                new ItemWidget(this, x1 - this.guiLeft + 4, y1 - this.guiTop + 4, (Supplier<ItemStack>)((Supplier)() -> quest.icon)).drawBackground(poseStack, this.guiLeft, this.guiTop);
            }
            RenderSystem.disableScissor();
        }
    }

    private Lines getLine(Quest quest, List<String> quests, GuideTab guideTab) {
        String PrevName = quest.prevName;
        if (!quests.contains(PrevName)) {
            return Lines.GOLD;
        }
        Quest quest1 = GuideBookCore.instance.getPrev(quest.prevName, guideTab);
        if (quest1.hasPrev) {
            if (quests.contains(quest1.prevName)) {
                return Lines.DARK;
            }
            return Lines.GRAY;
        }
        return Lines.GRAY;
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

