/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.book;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.containermenu.ContainerMenuBeeAnalyzer;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bee.ItemStackBeeAnalyzer;
import com.denfop.items.book.ItemStackBook;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class ItemBook
extends Item
implements IItemStackInventory,
IItemTab,
IUpdatableItemStackEvent {
    private final String internalName;
    private String nameItem;

    public ItemBook(String internalName) {
        super(new Item.Properties().m_41487_(1));
        this.internalName = internalName;
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return "item." + this.internalName + ".name";
    }

    public void save(ItemStack stack, Player player) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128379_("open", true);
        nbt.m_128405_("slot_inventory", player.m_150109_().f_35977_);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackBeeAnalyzer toolbox;
        int slotId;
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("open") && (slotId = nbt.m_128451_("slot_inventory")) != itemSlot && !world.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.m_6915_();
            nbt.m_128379_("open", false);
        }
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackBeeAnalyzer toolbox;
        if (!player.m_9236_().f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.m_6915_();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        BlockHitResult blockhitresult = ItemBook.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (!player.m_9236_().f_46443_ && world.m_7702_(blockhitresult.m_82425_()) == null) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @Override
    public CustomWorldContainer getInventory(Player player, ItemStack stack) {
        return new ItemStackBook(player, stack);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        ModUtils.nbt(stack).m_128405_("book_info", event);
    }
}

